/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz.wrappers;

import java.util.Set;
import org.quartz.JobKey;
import org.terracotta.quartz.collections.ToolkitDSHolder;
import org.terracotta.quartz.wrappers.JobWrapper;
import org.terracotta.toolkit.store.ToolkitStore;

public class JobFacade {
    private final ToolkitStore<JobKey, JobWrapper> jobsByFQN;
    private final Set<String> allJobsGroupNames;
    private final Set<String> pausedJobGroups;
    private final Set<JobKey> blockedJobs;

    public JobFacade(ToolkitDSHolder toolkitDSHolder) {
        this.jobsByFQN = toolkitDSHolder.getOrCreateJobsMap();
        this.allJobsGroupNames = toolkitDSHolder.getOrCreateAllGroupsSet();
        this.pausedJobGroups = toolkitDSHolder.getOrCreatePausedGroupsSet();
        this.blockedJobs = toolkitDSHolder.getOrCreateBlockedJobsSet();
    }

    public JobWrapper get(JobKey jobKey) {
        return (JobWrapper)this.jobsByFQN.get((Object)jobKey);
    }

    public void put(JobKey jobKey, JobWrapper jobWrapper) {
        this.jobsByFQN.putNoReturn((Object)jobKey, (Object)jobWrapper);
    }

    public boolean containsKey(JobKey jobKey) {
        return this.jobsByFQN.containsKey((Object)jobKey);
    }

    public boolean hasGroup(String string) {
        return this.allJobsGroupNames.contains(string);
    }

    public boolean addGroup(String string) {
        return this.allJobsGroupNames.add(string);
    }

    public boolean addPausedGroup(String string) {
        return this.pausedJobGroups.add(string);
    }

    public JobWrapper remove(JobKey jobKey) {
        return (JobWrapper)this.jobsByFQN.remove((Object)jobKey);
    }

    public boolean removeGroup(String string) {
        return this.allJobsGroupNames.remove(string);
    }

    public boolean pausedGroupsContain(String string) {
        return this.pausedJobGroups.contains(string);
    }

    public boolean blockedJobsContain(JobKey jobKey) {
        return this.blockedJobs.contains(jobKey);
    }

    public int numberOfJobs() {
        return this.jobsByFQN.size();
    }

    public Set<String> getAllGroupNames() {
        return this.allJobsGroupNames;
    }

    public boolean removePausedJobGroup(String string) {
        return this.pausedJobGroups.remove(string);
    }

    public void clearPausedJobGroups() {
        this.pausedJobGroups.clear();
    }

    public void addBlockedJob(JobKey jobKey) {
        this.blockedJobs.add(jobKey);
    }

    public boolean removeBlockedJob(JobKey jobKey) {
        return this.blockedJobs.remove(jobKey);
    }
}

