/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredResult;
import org.terracotta.quartz.TerracottaJobStoreExtensions;
import org.terracotta.quartz.TerracottaToolkitBuilder;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.rejoin.RejoinException;

public abstract class AbstractTerracottaJobStore
implements JobStore {
    public static final String TC_CONFIG_PROP = "org.quartz.jobStore.tcConfig";
    public static final String TC_CONFIGURL_PROP = "org.quartz.jobStore.tcConfigUrl";
    public static final String TC_REJOIN_PROP = "org.quartz.jobStore.rejoin";
    private volatile ToolkitInternal toolkit;
    private volatile TerracottaJobStoreExtensions realJobStore;
    private String tcConfig = null;
    private String tcConfigUrl = null;
    private String schedInstId = null;
    private String schedName = null;
    private Long misFireThreshold = null;
    private String synchWrite = null;
    private String rejoin = null;
    private Long estimatedTimeToReleaseAndAcquireTrigger = null;
    private long tcRetryInterval = TimeUnit.SECONDS.toMillis(15L);

    private void init() throws SchedulerConfigException {
        if (this.realJobStore != null) {
            return;
        }
        if (this.tcConfig != null && this.tcConfigUrl != null) {
            throw new SchedulerConfigException("Both org.quartz.jobStore.tcConfig and org.quartz.jobStore.tcConfigUrl are set in your properties. Please define only one of them");
        }
        if (this.tcConfig == null && this.tcConfigUrl == null) {
            throw new SchedulerConfigException("Neither org.quartz.jobStore.tcConfig or org.quartz.jobStore.tcConfigUrl are set in your properties. Please define one of them");
        }
        boolean bl = this.tcConfig == null;
        TerracottaToolkitBuilder terracottaToolkitBuilder = new TerracottaToolkitBuilder();
        if (bl) {
            terracottaToolkitBuilder.setTCConfigUrl(this.tcConfigUrl);
        } else {
            terracottaToolkitBuilder.setTCConfigSnippet(this.tcConfig);
        }
        if (this.rejoin != null) {
            terracottaToolkitBuilder.setRejoin(this.rejoin);
        }
        terracottaToolkitBuilder.addTunnelledMBeanDomain("quartz");
        this.toolkit = (ToolkitInternal)terracottaToolkitBuilder.buildToolkit();
        try {
            this.realJobStore = this.getRealStore(this.toolkit);
        }
        catch (Exception exception) {
            throw new SchedulerConfigException("Unable to create Terracotta client", exception);
        }
    }

    abstract TerracottaJobStoreExtensions getRealStore(ToolkitInternal var1);

    public String getUUID() {
        if (this.realJobStore == null) {
            try {
                this.init();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.realJobStore.getUUID();
    }

    public void setMisfireThreshold(long l) {
        this.misFireThreshold = l;
    }

    public void setTcRetryInterval(long l) {
        this.tcRetryInterval = l;
    }

    @Override
    public List<OperableTrigger> acquireNextTriggers(long l, int n, long l2) throws JobPersistenceException {
        try {
            return this.realJobStore.acquireNextTriggers(l, n, l2);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Trigger acquisition failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public List<String> getCalendarNames() throws JobPersistenceException {
        try {
            return this.realJobStore.getCalendarNames();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Calendar name retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public List<String> getJobGroupNames() throws JobPersistenceException {
        try {
            return this.realJobStore.getJobGroupNames();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Job name retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        try {
            return this.realJobStore.getJobKeys(groupMatcher);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Job key retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public int getNumberOfCalendars() throws JobPersistenceException {
        try {
            return this.realJobStore.getNumberOfCalendars();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Calendar count retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public int getNumberOfJobs() throws JobPersistenceException {
        try {
            return this.realJobStore.getNumberOfJobs();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Job count retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public int getNumberOfTriggers() throws JobPersistenceException {
        try {
            return this.realJobStore.getNumberOfTriggers();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Trigger count retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        try {
            return this.realJobStore.getPausedTriggerGroups();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Paused trigger group retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        try {
            return this.realJobStore.getTriggerGroupNames();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Trigger group retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        try {
            return this.realJobStore.getTriggerKeys(groupMatcher);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Trigger key retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) throws JobPersistenceException {
        try {
            return this.realJobStore.getTriggersForJob(jobKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Trigger retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        try {
            return this.realJobStore.getTriggerState(triggerKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Trigger state retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void initialize(ClassLoadHelper classLoadHelper, SchedulerSignaler schedulerSignaler) throws SchedulerConfigException {
        this.init();
        this.realJobStore.setInstanceId(this.schedInstId);
        this.realJobStore.setInstanceName(this.schedName);
        this.realJobStore.setTcRetryInterval(this.tcRetryInterval);
        if (this.misFireThreshold != null) {
            this.realJobStore.setMisfireThreshold(this.misFireThreshold);
        }
        if (this.synchWrite != null) {
            this.realJobStore.setSynchronousWrite(this.synchWrite);
        }
        if (this.estimatedTimeToReleaseAndAcquireTrigger != null) {
            this.realJobStore.setEstimatedTimeToReleaseAndAcquireTrigger(this.estimatedTimeToReleaseAndAcquireTrigger);
        }
        this.realJobStore.initialize(classLoadHelper, schedulerSignaler);
    }

    @Override
    public void pauseAll() throws JobPersistenceException {
        try {
            this.realJobStore.pauseAll();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Pausing failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void pauseJob(JobKey jobKey) throws JobPersistenceException {
        try {
            this.realJobStore.pauseJob(jobKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Pausing job failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        try {
            return this.realJobStore.pauseJobs(groupMatcher);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Pausing jobs failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        try {
            this.realJobStore.pauseTrigger(triggerKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Pausing trigger failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        try {
            return this.realJobStore.pauseTriggers(groupMatcher);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Pausing triggers failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void releaseAcquiredTrigger(OperableTrigger operableTrigger) {
        this.realJobStore.releaseAcquiredTrigger(operableTrigger);
    }

    @Override
    public boolean removeCalendar(String string) throws JobPersistenceException {
        try {
            return this.realJobStore.removeCalendar(string);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Removing calendar failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public boolean removeJob(JobKey jobKey) throws JobPersistenceException {
        try {
            return this.realJobStore.removeJob(jobKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Removing job failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public boolean removeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        try {
            return this.realJobStore.removeTrigger(triggerKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Removing trigger failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger operableTrigger) throws JobPersistenceException {
        try {
            return this.realJobStore.replaceTrigger(triggerKey, operableTrigger);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Replacing trigger failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void resumeAll() throws JobPersistenceException {
        try {
            this.realJobStore.resumeAll();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Resuming failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void resumeJob(JobKey jobKey) throws JobPersistenceException {
        try {
            this.realJobStore.resumeJob(jobKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Reusming job failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public Collection<String> resumeJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        try {
            return this.realJobStore.resumeJobs(groupMatcher);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Resuming jobs failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        try {
            this.realJobStore.resumeTrigger(triggerKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Resuming trigger failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) throws JobPersistenceException {
        try {
            return this.realJobStore.resumeTriggers(groupMatcher);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Resuming triggers failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public Calendar retrieveCalendar(String string) throws JobPersistenceException {
        try {
            return this.realJobStore.retrieveCalendar(string);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Calendar retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        try {
            return this.realJobStore.retrieveJob(jobKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Job retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        try {
            return this.realJobStore.retrieveTrigger(triggerKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Trigger retrieval failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void schedulerStarted() throws SchedulerException {
        try {
            this.realJobStore.schedulerStarted();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Scheduler start failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void schedulerPaused() {
        this.realJobStore.schedulerPaused();
    }

    @Override
    public void schedulerResumed() {
        this.realJobStore.schedulerResumed();
    }

    @Override
    public void setInstanceId(String string) {
        this.schedInstId = string;
    }

    @Override
    public void setInstanceName(String string) {
        this.schedName = string;
    }

    @Override
    public void setThreadPoolSize(int n) {
        this.realJobStore.setThreadPoolSize(n);
    }

    @Override
    public void shutdown() {
        if (this.realJobStore != null) {
            this.realJobStore.shutdown();
        }
        if (this.toolkit != null) {
            this.toolkit.shutdown();
        }
    }

    @Override
    public void storeCalendar(String string, Calendar calendar, boolean bl, boolean bl2) throws ObjectAlreadyExistsException, JobPersistenceException {
        try {
            this.realJobStore.storeCalendar(string, calendar, bl, bl2);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Storing calendar failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void storeJob(JobDetail jobDetail, boolean bl) throws ObjectAlreadyExistsException, JobPersistenceException {
        try {
            this.realJobStore.storeJob(jobDetail, bl);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Storing job failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void storeJobAndTrigger(JobDetail jobDetail, OperableTrigger operableTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        try {
            this.realJobStore.storeJobAndTrigger(jobDetail, operableTrigger);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Storing job and trigger failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void storeTrigger(OperableTrigger operableTrigger, boolean bl) throws ObjectAlreadyExistsException, JobPersistenceException {
        try {
            this.realJobStore.storeTrigger(operableTrigger, bl);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Storing trigger failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public boolean supportsPersistence() {
        return true;
    }

    @Override
    public void triggeredJobComplete(OperableTrigger operableTrigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction completedExecutionInstruction) {
        this.realJobStore.triggeredJobComplete(operableTrigger, jobDetail, completedExecutionInstruction);
    }

    @Override
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> list) throws JobPersistenceException {
        try {
            return this.realJobStore.triggersFired(list);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Trigger fire marking failed due to client rejoin", rejoinException);
        }
    }

    public void setTcConfig(String string) {
        this.tcConfig = string.trim();
    }

    public void setTcConfigUrl(String string) {
        this.tcConfigUrl = string.trim();
    }

    public void setSynchronousWrite(String string) {
        this.synchWrite = string;
    }

    public void setRejoin(String string) {
        this.rejoin = string;
        this.setSynchronousWrite(Boolean.TRUE.toString());
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return this.realJobStore.getEstimatedTimeToReleaseAndAcquireTrigger();
    }

    public void setEstimatedTimeToReleaseAndAcquireTrigger(long l) {
        this.estimatedTimeToReleaseAndAcquireTrigger = l;
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    @Override
    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        try {
            return this.realJobStore.checkExists(jobKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Job existence check failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        try {
            return this.realJobStore.checkExists(triggerKey);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Trigger existence check failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void clearAllSchedulingData() throws JobPersistenceException {
        try {
            this.realJobStore.clearAllSchedulingData();
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Scheduler data clear failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public boolean removeTriggers(List<TriggerKey> list) throws JobPersistenceException {
        try {
            return this.realJobStore.removeTriggers(list);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Remvoing triggers failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public boolean removeJobs(List<JobKey> list) throws JobPersistenceException {
        try {
            return this.realJobStore.removeJobs(list);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Removing jobs failed due to client rejoin", rejoinException);
        }
    }

    @Override
    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> map, boolean bl) throws ObjectAlreadyExistsException, JobPersistenceException {
        try {
            this.realJobStore.storeJobsAndTriggers(map, bl);
        }
        catch (RejoinException rejoinException) {
            throw new JobPersistenceException("Store jobs and triggers failed due to client rejoin", rejoinException);
        }
    }

    protected TerracottaJobStoreExtensions getRealJobStore() {
        return this.realJobStore;
    }
}

