/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import org.tanukisoftware.wrapper.security.WrapperServicePermission;

final class WSCollection
extends PermissionCollection {
    private Vector m_permissions = new Vector();

    public void add(Permission permission) {
        if (!(permission instanceof WrapperServicePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("Collection is read-only.");
        }
        this.m_permissions.add(permission);
    }

    public boolean implies(Permission permission) {
        int n;
        if (!(permission instanceof WrapperServicePermission)) {
            return false;
        }
        WrapperServicePermission wrapperServicePermission = (WrapperServicePermission)permission;
        int n2 = n = wrapperServicePermission.getActionMask();
        int n3 = 0;
        Enumeration enumeration = this.m_permissions.elements();
        while (enumeration.hasMoreElements()) {
            WrapperServicePermission wrapperServicePermission2 = (WrapperServicePermission)enumeration.nextElement();
            if ((n2 & wrapperServicePermission2.getActionMask()) == 0 || !wrapperServicePermission.impliesIgnoreActionMask(wrapperServicePermission2)) continue;
            if ((n3 |= n & wrapperServicePermission2.getActionMask()) == n) {
                return true;
            }
            n2 = n ^ n3;
        }
        return false;
    }

    public Enumeration elements() {
        return this.m_permissions.elements();
    }
}

