/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.tanukisoftware.wrapper.WrapperInfo;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperProperties;
import org.tanukisoftware.wrapper.WrapperServiceException;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;
import org.tanukisoftware.wrapper.WrapperUser;
import org.tanukisoftware.wrapper.WrapperWin32Service;
import org.tanukisoftware.wrapper.event.WrapperControlEvent;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;
import org.tanukisoftware.wrapper.event.WrapperPingEvent;
import org.tanukisoftware.wrapper.event.WrapperServiceControlEvent;
import org.tanukisoftware.wrapper.event.WrapperTickEvent;
import org.tanukisoftware.wrapper.jmx.WrapperManagerTesting;
import org.tanukisoftware.wrapper.resources.ResourceManager;
import org.tanukisoftware.wrapper.security.WrapperEventPermission;
import org.tanukisoftware.wrapper.security.WrapperPermission;
import org.tanukisoftware.wrapper.security.WrapperServicePermission;

public final class WrapperManager
implements Runnable {
    private static final String WRAPPER_CONNECTION_THREAD_NAME = "Wrapper-Connection";
    private static final int DEFAULT_PORT = 15003;
    private static final int DEFAULT_SO_TIMEOUT = 10000;
    private static final int DEFAULT_CPU_TIMEOUT = 10000;
    private static final int TICK_MS = 100;
    private static final int TIMER_FAST_THRESHOLD = 1728000;
    private static final int TIMER_SLOW_THRESHOLD = 1728000;
    private static final byte WRAPPER_MSG_START = 100;
    private static final byte WRAPPER_MSG_STOP = 101;
    private static final byte WRAPPER_MSG_RESTART = 102;
    private static final byte WRAPPER_MSG_PING = 103;
    private static final byte WRAPPER_MSG_STOP_PENDING = 104;
    private static final byte WRAPPER_MSG_START_PENDING = 105;
    private static final byte WRAPPER_MSG_STARTED = 106;
    private static final byte WRAPPER_MSG_STOPPED = 107;
    private static final byte WRAPPER_MSG_KEY = 110;
    private static final byte WRAPPER_MSG_BADKEY = 111;
    private static final byte WRAPPER_MSG_LOW_LOG_LEVEL = 112;
    private static final byte WRAPPER_MSG_PING_TIMEOUT = 113;
    private static final byte WRAPPER_MSG_SERVICE_CONTROL_CODE = 114;
    private static final byte WRAPPER_MSG_PROPERTIES = 115;
    private static final byte WRAPPER_MSG_LOG = 116;
    public static final int WRAPPER_CTRL_C_EVENT = 200;
    public static final int WRAPPER_CTRL_CLOSE_EVENT = 201;
    public static final int WRAPPER_CTRL_LOGOFF_EVENT = 202;
    public static final int WRAPPER_CTRL_SHUTDOWN_EVENT = 203;
    public static final int WRAPPER_CTRL_TERM_EVENT = 204;
    public static final int WRAPPER_CTRL_HUP_EVENT = 205;
    public static final int WRAPPER_LOG_LEVEL_DEBUG = 1;
    public static final int WRAPPER_LOG_LEVEL_INFO = 2;
    public static final int WRAPPER_LOG_LEVEL_STATUS = 3;
    public static final int WRAPPER_LOG_LEVEL_WARN = 4;
    public static final int WRAPPER_LOG_LEVEL_ERROR = 5;
    public static final int WRAPPER_LOG_LEVEL_FATAL = 6;
    public static final int WRAPPER_LOG_LEVEL_ADVICE = 7;
    public static final int SERVICE_CONTROL_CODE_START = 65536;
    public static final int SERVICE_CONTROL_CODE_STOP = 1;
    public static final int SERVICE_CONTROL_CODE_PAUSE = 2;
    public static final int SERVICE_CONTROL_CODE_CONTINUE = 3;
    public static final int SERVICE_CONTROL_CODE_INTERROGATE = 4;
    public static final int SERVICE_CONTROL_CODE_SHUTDOWN = 5;
    private static PrintStream m_out;
    private static PrintStream m_err;
    private static boolean m_securityManagerChecked;
    private static boolean m_disposed;
    private static boolean m_started;
    private static WrapperManager m_instance;
    private static Thread m_hook;
    private static boolean m_hookTriggered;
    private static boolean m_shutdownJVMComplete;
    private static String[] m_args;
    private static int m_port;
    private static int m_jvmPort;
    private static int m_jvmPortMin;
    private static int m_jvmPortMax;
    private static String m_key;
    private static int m_soTimeout;
    private static long m_cpuTimeout;
    private static int m_startedTicks;
    private static int m_lowLogLevel;
    private static int m_pingTimeout;
    private static boolean m_ignoreSignals;
    private static Thread m_commRunner;
    private static boolean m_commRunnerStarted;
    private static Thread m_eventRunner;
    private static int m_eventRunnerTicks;
    private static Thread m_startupRunner;
    private static boolean m_useSystemTime;
    private static int m_timerFastThreshold;
    private static int m_timerSlowThreshold;
    private static int m_jvmBits;
    private static volatile int m_ticks;
    private static WrapperListener m_listener;
    private static int m_lastPingTicks;
    private static ServerSocket m_serverSocket;
    private static Socket m_socket;
    private static boolean m_shuttingDown;
    private static boolean m_appearHung;
    private static Method m_addShutdownHookMethod;
    private static Method m_removeShutdownHookMethod;
    private static boolean m_service;
    private static boolean m_debug;
    private static int m_jvmId;
    private static boolean m_stopping;
    private static Thread m_stoppingThread;
    private static int m_exitCode;
    private static boolean m_libraryOK;
    private static byte[] m_commandBuffer;
    private static WrapperProperties m_properties;
    private static List m_wrapperEventListenerMaskList;
    private static WrapperEventListenerMask[] m_wrapperEventListenerMasks;
    private static boolean m_produceCoreEvents;
    private static ResourceManager m_res;
    private static ResourceManager m_error;
    private static ResourceManager m_warning;
    private static ResourceManager m_info;
    private static char PROPERTY_SEPARATOR;
    private static byte[] m_socketReadBuffer;
    static /* synthetic */ Class class$org$tanukisoftware$wrapper$WrapperManager;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    private static void privilegedClassInit() {
        String string;
        String string2;
        Object object;
        block32: {
            m_out = System.out;
            m_err = System.err;
            m_properties = new WrapperProperties();
            m_properties.lock();
            WrapperManager.checkSecurityManager();
            m_debug = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.debug", false);
            if (m_debug) {
                m_out.println("WrapperManager class initialized by thread: " + Thread.currentThread().getName() + "  Using classloader: " + (class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager).getClassLoader());
            }
            m_out.println("Wrapper (Version " + WrapperManager.getVersion() + ") http://wrapper.tanukisoftware.org");
            m_out.println("  Copyright 1999-2006 Tanuki Software, Inc.  All Rights Reserved.");
            m_out.println();
            m_jvmId = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvmid", 1);
            if (m_debug) {
                m_out.println("Wrapper Manager: JVM #" + m_jvmId);
            }
            m_jvmBits = Integer.getInteger("sun.arch.data.model", -1);
            if (m_debug) {
                if (m_jvmBits > 0) {
                    m_out.println("Running a " + m_jvmBits + "-bit JVM.");
                } else {
                    m_out.println("The bit depth of this JVM could not be determined.");
                }
            }
            m_ticks = 0x7FFFFF37;
            m_useSystemTime = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.use_system_time", false);
            m_timerFastThreshold = WrapperSystemPropertyUtil.getIntProperty("wrapper.timer_fast_threshold", 1728000) * 1000 / 100;
            m_timerSlowThreshold = WrapperSystemPropertyUtil.getIntProperty("wrapper.timer_slow_threshold", 1728000) * 1000 / 100;
            boolean bl = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.disable_shutdown_hook", false);
            try {
                m_addShutdownHookMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = WrapperManager.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = WrapperManager.class$("java.lang.Thread")) : class$java$lang$Thread);
                m_removeShutdownHookMethod = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = WrapperManager.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("removeShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = WrapperManager.class$("java.lang.Thread")) : class$java$lang$Thread);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (m_debug) {
                    m_out.println("Wrapper Manager: Shutdown hooks not supported by current JVM.");
                }
                m_addShutdownHookMethod = null;
                m_removeShutdownHookMethod = null;
                bl = true;
            }
            if (!bl) {
                if (m_debug) {
                    m_out.println("Wrapper Manager: Registering shutdown hook");
                }
                m_hook = new Thread("Wrapper-Shutdown-Hook"){

                    public void run() {
                        m_hookTriggered = true;
                        if (m_debug) {
                            m_out.println("Wrapper Manager: ShutdownHook started");
                        }
                        m_startupRunner = null;
                        WrapperManager.stop(0);
                        if (m_debug) {
                            m_out.println("Wrapper Manager: ShutdownHook complete");
                        }
                    }
                };
                try {
                    m_addShutdownHookMethod.invoke((Object)Runtime.getRuntime(), m_hook);
                }
                catch (IllegalAccessException illegalAccessException) {
                    m_out.println("Wrapper Manager: Unable to register shutdown hook: " + illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = invocationTargetException.getTargetException();
                    if (object == null) {
                        object = invocationTargetException;
                    }
                    m_out.println("Wrapper Manager: Unable to register shutdown hook: " + object);
                }
            }
            if ((m_key = System.getProperty("wrapper.key")) == null) {
                if (m_debug) {
                    m_out.println("Wrapper Manager: Not using wrapper.  (key not specified)");
                }
                m_port = 0;
                m_jvmPort = 0;
                m_jvmPortMin = 0;
                m_jvmPortMax = 0;
                m_service = false;
                m_cpuTimeout = 31557600000L;
            } else {
                if (m_debug) {
                    m_out.println("Wrapper Manager: Using wrapper");
                }
                if ((string2 = System.getProperty("wrapper.port")) == null) {
                    String string3 = m_res.format("MISSING_PORT");
                    m_out.println(string3);
                    throw new ExceptionInInitializerError(string3);
                }
                try {
                    m_port = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    object = m_res.format("BAD_PORT", string2);
                    m_out.println((String)object);
                    throw new ExceptionInInitializerError((String)object);
                }
                m_jvmPort = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvm.port", 0);
                m_jvmPortMin = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvm.port.min", 31000);
                m_jvmPortMax = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvm.port.max", 31999);
                m_ignoreSignals = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.ignore_signals", false);
                m_service = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.service", false);
                string = System.getProperty("wrapper.cpu.timeout");
                if (string == null) {
                    m_cpuTimeout = 10000L;
                } else {
                    try {
                        m_cpuTimeout = (long)Integer.parseInt(string) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string4 = m_res.format("BAD_CPU_TIMEOUT", string);
                        m_out.println(string4);
                        throw new ExceptionInInitializerError(string4);
                    }
                }
            }
            WrapperManager.verifyWrapperVersion();
            if (WrapperSystemPropertyUtil.getBooleanProperty((class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager).getName() + ".mbean", true)) {
                WrapperManager.registerMBean(new org.tanukisoftware.wrapper.jmx.WrapperManager(), "org.tanukisoftware.wrapper:type=WrapperManager");
            }
            if (WrapperSystemPropertyUtil.getBooleanProperty((class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager).getName() + ".mbean.testing", false)) {
                WrapperManager.registerMBean(new WrapperManagerTesting(), "org.tanukisoftware.wrapper:type=WrapperManagerTesting");
            }
            WrapperManager.initializeNativeLibrary();
            if (m_libraryOK) {
                WrapperManager.verifyNativeLibraryVersion();
                try {
                    System.setProperty("wrapper.java.pid", Integer.toString(WrapperManager.nativeGetJavaPID()));
                }
                catch (Throwable throwable) {
                    if (!m_debug) break block32;
                    m_out.println("Call to nativeGetJavaPID() failed: " + throwable);
                }
            }
        }
        m_eventRunnerTicks = WrapperManager.getTicks();
        m_eventRunner = new Thread("Wrapper-Control-Event-Monitor"){

            public void run() {
                if (m_debug) {
                    m_out.println("Control event monitor thread started.");
                }
                try {
                    WrapperTickEventImpl wrapperTickEventImpl = new WrapperTickEventImpl();
                    int n = 0;
                    boolean bl = true;
                    while (!m_shuttingDown) {
                        int n2;
                        int n3;
                        int n4;
                        if (!m_useSystemTime) {
                            n4 = WrapperManager.getSystemTicks();
                            m_ticks++;
                            int n5 = n4 - m_ticks;
                            n3 = n5 - n;
                            if (bl) {
                                bl = false;
                            } else if (n3 > m_timerSlowThreshold) {
                                m_out.println("The timer fell behind the system clock by " + n3 * 100 + "ms.");
                            } else if (n3 < -m_timerFastThreshold) {
                                m_out.println("The system clock fell behind the timer by " + -1 * n3 * 100 + "ms.");
                            }
                            n = n5;
                        } else {
                            n3 = 0;
                        }
                        n4 = WrapperManager.getTicks();
                        long l = WrapperManager.getTickAge(m_eventRunnerTicks, n4);
                        if (m_cpuTimeout > 0L && l > m_cpuTimeout) {
                            m_out.println("JVM Process has not received any CPU time for " + l / 1000L + " seconds.  Extending timeouts.");
                            m_lastPingTicks = n4;
                        }
                        m_eventRunnerTicks = n4;
                        if (m_produceCoreEvents) {
                            wrapperTickEventImpl.m_ticks = n4;
                            wrapperTickEventImpl.m_tickOffset = n3;
                            WrapperManager.fireWrapperEvent(wrapperTickEventImpl);
                        }
                        if (m_libraryOK && (n2 = WrapperManager.nativeGetControlEvent()) != 0) {
                            WrapperManager.controlEvent(n2);
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (m_debug) {
                        m_out.println("Control event monitor thread stopped.");
                    }
                    throw throwable;
                }
                if (m_debug) {
                    m_out.println("Control event monitor thread stopped.");
                }
            }
        };
        m_eventRunner.setDaemon(true);
        m_eventRunner.start();
        string2 = System.getProperty("java.fullversion");
        string = System.getProperty("java.vm.vendor", "");
        object = System.getProperty("os.name", "").toLowerCase();
        if (string2 == null) {
            string2 = System.getProperty("java.runtime.version") + " " + System.getProperty("java.vm.name");
        }
        if (m_debug) {
            m_out.println("Java Version   : " + string2);
            m_out.println("Java VM Vendor : " + string);
            m_out.println();
        }
        m_startupRunner = new Thread("Wrapper-Startup-Runner"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                if (m_debug) {
                    m_out.println("Startup runner thread started.");
                }
                try {
                    while (true) {
                        if (m_startupRunner == null) {
                            Object var3_2 = null;
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (!m_debug) throw throwable;
                    m_out.println("Startup runner thread stopped.");
                    throw throwable;
                }
                if (!m_debug) return;
                m_out.println("Startup runner thread stopped.");
            }
        };
        m_startupRunner.setDaemon(false);
        m_startupRunner.start();
        m_instance = new WrapperManager();
    }

    private static native void nativeInit(boolean var0);

    private static native String nativeGetLibraryVersion();

    private static native int nativeGetJavaPID();

    private static native int nativeGetControlEvent();

    private static native void nativeRequestThreadDump();

    private static native void accessViolationInner();

    private static native void nativeSetConsoleTitle(byte[] var0);

    private static native WrapperUser nativeGetUser(boolean var0);

    private static native WrapperUser nativeGetInteractiveUser(boolean var0);

    private static native WrapperWin32Service[] nativeListServices();

    private static native WrapperWin32Service nativeSendServiceControlCode(byte[] var0, int var1);

    private static int getSystemTicks() {
        return (int)(System.currentTimeMillis() / 100L);
    }

    private static int getTicks() {
        if (m_useSystemTime) {
            return WrapperManager.getSystemTicks();
        }
        return m_ticks;
    }

    private static long getTickAge(int n, int n2) {
        return (long)(n2 - n) * 100L;
    }

    private static String loadNativeLibrary(String string, String string2) {
        try {
            System.loadLibrary(string);
            if (m_debug) {
                m_out.println("Loaded native library: " + string2);
            }
            return null;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string3;
            if (m_debug) {
                m_out.println("Loading native library failed: " + string2 + "  Cause: " + unsatisfiedLinkError);
            }
            if ((string3 = unsatisfiedLinkError.getMessage()) == null) {
                string3 = unsatisfiedLinkError.toString();
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (m_debug) {
                m_out.println("Loading native library failed: " + string2 + "  Cause: " + throwable);
            }
            String string4 = throwable.toString();
            return string4;
        }
    }

    private static void registerMBean(Object object, String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.management.ManagementFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (m_debug) {
                m_out.println("Registering MBeans not supported by current JVM: " + string);
            }
            return;
        }
        try {
            Class<?> clazz2 = Class.forName("javax.management.MBeanServer");
            Class<?> clazz3 = Class.forName("javax.management.ObjectName");
            Method method = clazz.getMethod("getPlatformMBeanServer", null);
            Constructor<?> constructor = clazz3.getConstructor(class$java$lang$String == null ? (class$java$lang$String = WrapperManager.class$("java.lang.String")) : class$java$lang$String);
            Method method2 = clazz2.getMethod("registerMBean", class$java$lang$Object == null ? (class$java$lang$Object = WrapperManager.class$("java.lang.Object")) : class$java$lang$Object, clazz3);
            Object object2 = method.invoke(null, null);
            Object obj = constructor.newInstance(string);
            method2.invoke(object2, object, obj);
            if (m_debug) {
                m_out.println("Registered MBean with Platform MBean Server: " + string);
            }
        }
        catch (Throwable throwable) {
            m_err.println("Unable to register the " + string + " MBean.");
            throwable.printStackTrace();
        }
    }

    private static File locateFileOnPath(String string, String string2) {
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(new File(stringTokenizer.nextToken()), string);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private static String generateDetailedNativeLibraryBaseName(String string, int n, boolean bl) {
        String string2 = System.getProperty("os.name", "").toLowerCase();
        if (string2.startsWith("windows")) {
            string2 = "windows";
        } else if (string2.equals("sunos")) {
            string2 = "solaris";
        } else if (string2.equals("hp-ux") || string2.equals("hp-ux64")) {
            string2 = "hpux";
        } else if (string2.equals("mac os x")) {
            string2 = "macosx";
        } else if (string2.equals("unix_sv")) {
            string2 = "unixware";
        }
        String string3 = System.getProperty("os.arch", "").toLowerCase();
        if (bl) {
            string3 = "universal";
        } else if (string3.equals("amd64") || string3.equals("athlon") || string3.equals("ia32") || string3.equals("ia64") || string3.equals("x86_64") || string3.equals("i686") || string3.equals("i586") || string3.equals("i486") || string3.equals("i386")) {
            string3 = "x86";
        } else if (string3.startsWith("sparc")) {
            string3 = "sparc";
        } else if (string3.equals("power") || string3.equals("powerpc") || string3.equals("ppc64")) {
            string3 = "ppc";
        } else if (string3.equals("pa_risc") || string3.equals("pa-risc")) {
            string3 = "parisc";
        }
        return string + "-" + string2 + "-" + string3 + "-" + n;
    }

    private static void initializeNativeLibrary() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("wrapper.native_library");
        if (string2 == null) {
            m_out.println("WARNING - The wrapper.native_library system property was not");
            m_out.println("          set. Using the default value, 'wrapper'.");
            string2 = "wrapper";
        }
        String[] stringArray = new String[4];
        if (m_jvmBits > 0) {
            stringArray[0] = WrapperManager.generateDetailedNativeLibraryBaseName(string2, m_jvmBits, false);
            if (string.startsWith("mac")) {
                stringArray[1] = WrapperManager.generateDetailedNativeLibraryBaseName(string2, m_jvmBits, true);
            }
        } else {
            stringArray[0] = WrapperManager.generateDetailedNativeLibraryBaseName(string2, 32, false);
            stringArray[1] = WrapperManager.generateDetailedNativeLibraryBaseName(string2, 64, false);
            if (string.startsWith("mac")) {
                stringArray[2] = WrapperManager.generateDetailedNativeLibraryBaseName(string2, 32, true);
                stringArray[3] = WrapperManager.generateDetailedNativeLibraryBaseName(string2, 64, true);
            }
        }
        String string3 = System.mapLibraryName(string2);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                stringArray2[n] = System.mapLibraryName(stringArray[n]);
            }
            ++n;
        }
        String[] stringArray3 = new String[stringArray.length];
        String string4 = null;
        if (m_debug) {
            m_out.println("Load native library.  One or more attempts may fail if platform specific libraries do not exist.");
        }
        m_libraryOK = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] != null) {
                stringArray3[n2] = WrapperManager.loadNativeLibrary(stringArray[n2], stringArray2[n2]);
                if (stringArray3[n2] == null) {
                    m_libraryOK = true;
                    break;
                }
            }
            ++n2;
        }
        if (!m_libraryOK && (string4 = WrapperManager.loadNativeLibrary(string2, string3)) == null) {
            m_libraryOK = true;
        }
        if (m_libraryOK) {
            if (m_debug) {
                m_out.println("Calling native initialization method.");
            }
            WrapperManager.nativeInit(m_debug);
        } else {
            String string5 = System.getProperty("java.library.path");
            m_out.println();
            if (string5.equals("")) {
                m_out.println("WARNING - Unable to load the Wrapper's native library because the");
                m_out.println("          java.library.path was set to ''.  Please see the");
                m_out.println("          documentation for the wrapper.java.library.path ");
                m_out.println("          configuration property.");
            } else {
                String string6 = null;
                File file = null;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray2[n3] != null && (file = WrapperManager.locateFileOnPath(stringArray2[n3], string5)) != null) {
                        string6 = stringArray3[n3];
                        break;
                    }
                    ++n3;
                }
                if (file == null && (file = WrapperManager.locateFileOnPath(string3, string5)) != null) {
                    string6 = string4;
                }
                if (file == null) {
                    m_out.println("WARNING - Unable to load the Wrapper's native library because none of the");
                    m_out.println("          following files:");
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        if (stringArray2[n4] != null) {
                            m_out.println("            " + stringArray2[n4]);
                        }
                        ++n4;
                    }
                    m_out.println("            " + string3);
                    m_out.println("          could be located on the following java.library.path:");
                    String string7 = System.getProperty("path.separator");
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, string7);
                    while (stringTokenizer.hasMoreTokens()) {
                        File file2 = new File(stringTokenizer.nextToken());
                        m_out.println("            " + file2.getAbsolutePath());
                    }
                    m_out.println("          Please see the documentation for the wrapper.java.library.path");
                    m_out.println("          configuration property.");
                } else {
                    m_out.println("WARNING - Unable to load the Wrapper's native library '" + file.getName() + "'.");
                    m_out.println("          The file is located on the path at the following location but");
                    m_out.println("          could not be loaded:");
                    m_out.println("            " + file.getAbsolutePath());
                    m_out.println("          Please verify that the file is readable by the current user");
                    m_out.println("          and that the file has not been corrupted in any way.");
                    m_out.println("          One common cause of this problem is running a 32-bit version");
                    m_out.println("          of the Wrapper with a 64-bit version of Java, or vica versa.");
                    if (m_jvmBits > 0) {
                        m_out.println("          This is a " + m_jvmBits + "-bit JVM.");
                    } else {
                        m_out.println("          The bit depth of this JVM could not be determined.");
                    }
                    m_out.println("          Reported cause:");
                    m_out.println("            " + string6);
                }
            }
            m_out.println("          System signals will not be handled correctly.");
            m_out.println();
        }
    }

    private static void verifyWrapperVersion() {
        if (!WrapperManager.isControlledByNativeWrapper()) {
            return;
        }
        String string = System.getProperty("wrapper.version");
        if (string == null) {
            string = "unknown";
        }
        if (!WrapperInfo.getVersion().equals(string)) {
            m_out.println("WARNING - The Wrapper jar file currently in use is version \"" + WrapperInfo.getVersion() + "\"");
            m_out.println("          while the version of the Wrapper which launched this JVM is ");
            m_out.println("          \"" + string + "\".");
            m_out.println("          The Wrapper may appear to work correctly but some features may");
            m_out.println("          not function correctly.  This configuration has not been tested");
            m_out.println("          and is not supported.");
            m_out.println();
        }
    }

    private static void verifyNativeLibraryVersion() {
        String string;
        try {
            string = WrapperManager.nativeGetLibraryVersion();
        }
        catch (Throwable throwable) {
            if (m_debug) {
                m_out.println("Call to nativeGetLibraryVersion() failed: " + throwable);
            }
            string = "unknown";
        }
        if (!WrapperInfo.getVersion().equals(string)) {
            m_out.println("WARNING - The Wrapper jar file currently in use is version \"" + WrapperInfo.getVersion() + "\"");
            m_out.println("          while the version of the native library is \"" + string + "\".");
            m_out.println("          The Wrapper may appear to work correctly but some features may");
            m_out.println("          not function correctly.  This configuration has not been tested");
            m_out.println("          and is not supported.");
            m_out.println();
        }
    }

    public static String getVersion() {
        return WrapperInfo.getVersion();
    }

    public static String getBuildTime() {
        return WrapperInfo.getBuildTime();
    }

    public static int getJVMId() {
        return m_jvmId;
    }

    public static void setConsoleTitle(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("setConsoleTitle"));
        }
        if (m_libraryOK) {
            byte[] byArray = string.getBytes();
            byte[] byArray2 = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray.length] = 0;
            WrapperManager.nativeSetConsoleTitle(byArray2);
        }
    }

    public static WrapperUser getUser(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("getUser"));
        }
        WrapperUser wrapperUser = null;
        if (m_libraryOK) {
            wrapperUser = WrapperManager.nativeGetUser(bl);
        }
        return wrapperUser;
    }

    public static WrapperUser getInteractiveUser(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("getInteractiveUser"));
        }
        WrapperUser wrapperUser = null;
        if (m_libraryOK) {
            wrapperUser = WrapperManager.nativeGetInteractiveUser(bl);
        }
        return wrapperUser;
    }

    public static Properties getProperties() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("getProperties"));
        }
        return m_properties;
    }

    public static int getWrapperPID() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("getWrapperPID"));
        }
        return WrapperSystemPropertyUtil.getIntProperty("wrapper.pid", 0);
    }

    public static int getJavaPID() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("getJavaPID"));
        }
        return WrapperSystemPropertyUtil.getIntProperty("wrapper.java.pid", 0);
    }

    public static void requestThreadDump() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("requestThreadDump"));
        }
        if (m_libraryOK) {
            WrapperManager.nativeRequestThreadDump();
        } else {
            m_out.println("  wrapper library not loaded.");
        }
    }

    public static void appearHung() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("test.appearHung"));
        }
        m_out.println("WARNING: Making JVM appear to be hung...");
        m_appearHung = true;
    }

    public static void accessViolation() {
        block4: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new WrapperPermission("test.accessViolation"));
            }
            m_out.println("WARNING: Attempting to cause an access violation...");
            try {
                Class<?> clazz = Class.forName("java.lang.String");
                Method method = clazz.getDeclaredMethod(null, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                if (exception instanceof NoSuchFieldException) break block4;
                exception.printStackTrace();
            }
        }
        m_out.println("  Attempt to cause access violation failed.  JVM is still alive.");
    }

    public static void accessViolationNative() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("test.accessViolationNative"));
        }
        m_out.println("WARNING: Attempting to cause an access violation...");
        if (m_libraryOK) {
            WrapperManager.accessViolationInner();
            m_out.println("  Attempt to cause access violation failed.  JVM is still alive.");
        } else {
            m_out.println("  wrapper library not loaded.");
        }
    }

    public static boolean isControlledByNativeWrapper() {
        return m_key != null;
    }

    public static boolean isLaunchedAsService() {
        return m_service;
    }

    public static boolean isDebugEnabled() {
        return m_debug;
    }

    public static synchronized void start(final WrapperListener wrapperListener, final String[] stringArray) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedStart(wrapperListener, stringArray);
                return null;
            }
        });
    }

    private static void privilegedStart(WrapperListener wrapperListener, String[] stringArray) {
        WrapperManager.checkSecurityManager();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (m_debug) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("args[");
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("\"");
                stringBuffer.append(stringArray[n]);
                stringBuffer.append("\"");
                ++n;
            }
            stringBuffer.append("]");
            m_out.println("WrapperManager.start(" + wrapperListener + ", " + stringBuffer.toString() + ") " + "called by thread: " + Thread.currentThread().getName());
        }
        if (m_disposed) {
            throw new IllegalStateException("WrapperManager has already been disposed.");
        }
        if (m_listener != null) {
            throw new IllegalStateException("WrapperManager has already been started with a WrapperListener.");
        }
        if (wrapperListener == null) {
            throw new IllegalStateException("A WrapperListener must be specified.");
        }
        m_listener = wrapperListener;
        m_args = stringArray;
        WrapperManager.startRunner();
        if (!WrapperManager.isControlledByNativeWrapper()) {
            WrapperManager.startInner();
        }
    }

    public static void restart() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("restart"));
        }
        if (m_debug) {
            m_out.println("WrapperManager.restart() called by thread: " + Thread.currentThread().getName());
        }
        WrapperManager.restartInner();
    }

    public static void restartAndReturn() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("restart"));
        }
        Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        synchronized (clazz) {
            if (m_stopping) {
                if (m_debug) {
                    m_out.println("WrapperManager.restartAndReturn() called by thread: " + Thread.currentThread().getName() + " already stopping.");
                }
                return;
            }
            if (m_debug) {
                m_out.println("WrapperManager.restartAndReturn() called by thread: " + Thread.currentThread().getName());
            }
        }
        Thread thread = new Thread("Wrapper-Restarter"){

            public void run() {
                WrapperManager.restartInner();
            }
        };
        thread.setDaemon(false);
        thread.start();
    }

    private static void restartInner() {
        boolean bl;
        Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        synchronized (clazz) {
            bl = m_stopping;
            if (!bl) {
                m_stopping = true;
            }
        }
        if (!bl) {
            if (!m_commRunnerStarted) {
                WrapperManager.startRunner();
            }
            WrapperManager.sendCommand((byte)102, "restart");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedStopInner(0);
                return null;
            }
        });
    }

    public static void stop(final int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("stop"));
        }
        if (m_debug) {
            m_out.println("WrapperManager.stop(" + n + ") called by thread: " + Thread.currentThread().getName());
        }
        WrapperManager.stopCommon(n, 1000);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedStopInner(n);
                return null;
            }
        });
    }

    public static void stopAndReturn(final int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("stop"));
        }
        Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        synchronized (clazz) {
            if (m_stopping) {
                if (m_debug) {
                    m_out.println("WrapperManager.stopAndReturn(" + n + ") called by thread: " + Thread.currentThread().getName() + " already stopping.");
                }
                return;
            }
            if (m_debug) {
                m_out.println("WrapperManager.stopAndReturn(" + n + ") called by thread: " + Thread.currentThread().getName());
            }
        }
        Thread thread = new Thread("Wrapper-Stopper"){

            public void run() {
                WrapperManager.stopCommon(n, 1000);
                AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 9 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public Object run() {
                        WrapperManager.access$2600(9.access$2800(this.this$0));
                        return null;
                    }
                });
            }

            static /* synthetic */ int access$2800(9 var0) {
                return var0.n;
            }
        };
        thread.setDaemon(false);
        thread.start();
    }

    public static void stopImmediate(final int n) {
        Method method;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("stopImmediate"));
        }
        if (m_debug) {
            m_out.println("WrapperManager.stopImmediate(" + n + ") called by thread: " + Thread.currentThread().getName());
        }
        WrapperManager.stopCommon(n, 250);
        WrapperManager.signalStopped(n);
        try {
            method = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = WrapperManager.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("halt", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            m_out.println("halt not supported by current JVM.");
            method = null;
        }
        if (method != null) {
            Runtime runtime = Runtime.getRuntime();
            try {
                method.invoke((Object)runtime, new Integer(n));
            }
            catch (IllegalAccessException illegalAccessException) {
                m_out.println("Unable to call runtime.halt: " + illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable == null) {
                    throwable = invocationTargetException;
                }
                m_out.println("Unable to call runtime.halt: " + throwable);
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    WrapperManager.privilegedStopInner(n);
                    return null;
                }
            });
        }
    }

    public static void signalStarting(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("signalStarting"));
        }
        WrapperManager.sendCommand((byte)105, Integer.toString(n));
    }

    public static void signalStopping(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("signalStopping"));
        }
        m_stopping = true;
        WrapperManager.sendCommand((byte)104, Integer.toString(n));
    }

    public static void signalStopped(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("signalStopped"));
        }
        m_stopping = true;
        WrapperManager.sendCommand((byte)107, Integer.toString(n));
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean hasShutdownHookBeenTriggered() {
        return m_hookTriggered;
    }

    public static void log(int n, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("log"));
        }
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("The specified logLevel is not valid.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The message parameter can not be null.");
        }
        if (m_lowLogLevel <= n) {
            WrapperManager.sendCommand((byte)(116 + n), string);
        }
    }

    public static WrapperWin32Service[] listServices() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            throw new SecurityException("A SecurityManager has not yet been set.");
        }
        securityManager.checkPermission(new WrapperPermission("listServices"));
        if (m_libraryOK) {
            return WrapperManager.nativeListServices();
        }
        return null;
    }

    public static WrapperWin32Service sendServiceControlCode(String string, int n) throws WrapperServiceException, SecurityException {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            throw new SecurityException("A SecurityManager has not yet been set.");
        }
        switch (n) {
            case 65536: {
                object = WrapperServicePermission.ACTION_START;
                break;
            }
            case 1: {
                object = WrapperServicePermission.ACTION_STOP;
                break;
            }
            case 2: {
                object = WrapperServicePermission.ACTION_PAUSE;
                break;
            }
            case 3: {
                object = WrapperServicePermission.ACTION_CONTINUE;
                break;
            }
            case 4: {
                object = WrapperServicePermission.ACTION_INTERROGATE;
                break;
            }
            default: {
                object = WrapperServicePermission.ACTION_USER_CODE;
            }
        }
        securityManager.checkPermission(new WrapperServicePermission(string, (String)object));
        object = null;
        if (m_libraryOK) {
            object = WrapperManager.nativeSendServiceControlCode(string.getBytes(), n);
        }
        return object;
    }

    public static void addWrapperEventListener(WrapperEventListener wrapperEventListener, long l) {
        Serializable serializable;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            serializable = new StringBuffer();
            boolean bl = true;
            if ((l & 1L) != 0L) {
                bl = false;
                ((StringBuffer)serializable).append(WrapperEventPermission.EVENT_TYPE_SERVICE);
            }
            if ((l & 2L) != 0L) {
                if (bl) {
                    bl = false;
                } else {
                    ((StringBuffer)serializable).append(",");
                }
                ((StringBuffer)serializable).append(WrapperEventPermission.EVENT_TYPE_CONTROL);
            }
            if ((l & 0xF000000000000000L) != 0L) {
                if (bl) {
                    bl = false;
                } else {
                    ((StringBuffer)serializable).append(",");
                }
                ((StringBuffer)serializable).append(WrapperEventPermission.EVENT_TYPE_CORE);
            }
            securityManager.checkPermission(new WrapperEventPermission(((StringBuffer)serializable).toString()));
        }
        serializable = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        synchronized (serializable) {
            WrapperEventListenerMask wrapperEventListenerMask = new WrapperEventListenerMask();
            wrapperEventListenerMask.m_listener = wrapperEventListener;
            wrapperEventListenerMask.m_mask = l;
            m_wrapperEventListenerMaskList.add(wrapperEventListenerMask);
            m_wrapperEventListenerMasks = null;
        }
        WrapperManager.updateWrapperEventListenerFlags();
    }

    public static void removeWrapperEventListener(WrapperEventListener wrapperEventListener) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new WrapperPermission("removeWrapperEventListener"));
        }
        Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        synchronized (clazz) {
            Iterator iterator = m_wrapperEventListenerMaskList.iterator();
            while (iterator.hasNext()) {
                WrapperEventListenerMask wrapperEventListenerMask = (WrapperEventListenerMask)iterator.next();
                if (wrapperEventListenerMask.m_listener != wrapperEventListener) continue;
                iterator.remove();
                m_wrapperEventListenerMasks = null;
                break;
            }
        }
        WrapperManager.updateWrapperEventListenerFlags();
    }

    private WrapperManager() {
    }

    private static void checkSecurityManager() {
        if (m_securityManagerChecked) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (m_debug) {
                m_out.println("Detected a SecurityManager: " + securityManager.getClass().getName());
            }
            try {
                securityManager.checkPermission(new AllPermission());
            }
            catch (SecurityException securityException) {
                m_out.println();
                m_out.println("WARNING - Detected that a SecurityManager has been installed but the ");
                m_out.println("          wrapper.jar has not been granted the java.security.AllPermission");
                m_out.println("          permission.  This will most likely result in SecurityExceptions");
                m_out.println("          being thrown by the Wrapper.");
                m_out.println();
            }
            m_securityManagerChecked = true;
        }
    }

    private static WrapperEventListenerMask[] getWrapperEventListenerMasks() {
        WrapperEventListenerMask[] wrapperEventListenerMaskArray = m_wrapperEventListenerMasks;
        if (wrapperEventListenerMaskArray == null) {
            Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
            synchronized (clazz) {
                if (wrapperEventListenerMaskArray == null) {
                    wrapperEventListenerMaskArray = new WrapperEventListenerMask[m_wrapperEventListenerMaskList.size()];
                    m_wrapperEventListenerMaskList.toArray(wrapperEventListenerMaskArray);
                    m_wrapperEventListenerMasks = wrapperEventListenerMaskArray;
                }
            }
        }
        return wrapperEventListenerMaskArray;
    }

    private static void updateWrapperEventListenerFlags() {
        boolean bl = false;
        WrapperEventListenerMask[] wrapperEventListenerMaskArray = WrapperManager.getWrapperEventListenerMasks();
        int n = 0;
        while (n < wrapperEventListenerMaskArray.length) {
            long l = wrapperEventListenerMaskArray[n].m_mask;
            bl |= (l & 0xF000000000000000L) != 0L;
            ++n;
        }
        m_produceCoreEvents = bl;
    }

    private static void fireWrapperEvent(WrapperEvent wrapperEvent) {
        long l = wrapperEvent.getFlags();
        WrapperEventListenerMask[] wrapperEventListenerMaskArray = WrapperManager.getWrapperEventListenerMasks();
        int n = 0;
        while (n < wrapperEventListenerMaskArray.length) {
            long l2 = wrapperEventListenerMaskArray[n].m_mask;
            if ((l2 & l) != 0L) {
                WrapperEventListener wrapperEventListener = wrapperEventListenerMaskArray[n].m_listener;
                try {
                    wrapperEventListener.fired(wrapperEvent);
                }
                catch (Throwable throwable) {
                    m_out.println("Encountered an uncaught exception while notifying WrapperEventListener of an event:");
                    throwable.printStackTrace(m_out);
                }
            }
            ++n;
        }
    }

    private static void stopCommon(int n, int n2) {
        boolean bl;
        Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        synchronized (clazz) {
            bl = m_stopping;
            if (!bl) {
                m_stopping = true;
            }
        }
        if (!bl) {
            if (!m_commRunnerStarted) {
                WrapperManager.startRunner();
            }
            WrapperManager.sendCommand((byte)101, Integer.toString(n));
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void dispose() {
        Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        synchronized (clazz) {
            m_disposed = true;
            WrapperManager.closeSocket();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void startInner() {
        int n = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(5);
        if (m_listener == null) {
            if (m_debug) {
                m_out.println("No WrapperListener has been set.  Nothing to start.");
            }
        } else {
            if (m_debug) {
                m_out.println("calling WrapperListener.start()");
            }
            final Integer[] integerArray = new Integer[1];
            final Throwable[] throwableArray = new Throwable[1];
            if (Thread.currentThread().isDaemon()) {
                Thread thread = new Thread("WrapperListener_start_runner"){

                    public void run() {
                        if (m_debug) {
                            m_out.println("WrapperListener.start runner thread started.");
                        }
                        try {
                            try {
                                integerArray[0] = m_listener.start(m_args);
                            }
                            catch (Throwable throwable) {
                                throwableArray[0] = throwable;
                            }
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (m_debug) {
                                m_out.println("WrapperListener.start runner thread stopped.");
                            }
                            throw throwable;
                        }
                        if (m_debug) {
                            m_out.println("WrapperListener.start runner thread stopped.");
                        }
                    }
                };
                thread.setDaemon(false);
                thread.start();
                if (m_debug) {
                    m_out.println("Waiting for WrapperListener.start runner thread to complete.");
                }
                while (thread != null && thread.isAlive()) {
                    try {
                        thread.join();
                        thread = null;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } else {
                try {
                    integerArray[0] = m_listener.start(m_args);
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                }
            }
            if (throwableArray[0] != null) {
                m_out.println("Error in WrapperListener.start callback.  " + throwableArray[0]);
                throwableArray[0].printStackTrace();
                WrapperManager.privilegedStopInner(1);
                return;
            }
            if (m_debug) {
                m_out.println("returned from WrapperListener.start()");
            }
            if (integerArray[0] != null) {
                int n2 = integerArray[0];
                if (m_debug) {
                    m_out.println("WrapperListener.start() returned an exit code of " + n2 + ".");
                }
                WrapperManager.stop(n2);
                return;
            }
        }
        m_startedTicks = WrapperManager.getTicks();
        m_startupRunner = null;
        WrapperManager.checkSecurityManager();
        Thread.currentThread().setPriority(n);
        WrapperManager.signalStarted();
    }

    private static void shutdownJVM(int n) {
        if (m_debug) {
            m_out.println("shutdownJVM(" + n + ") Thread:" + Thread.currentThread().getName());
        }
        if (Thread.currentThread() == m_hook) {
            WrapperManager.signalStopped(n);
            WrapperManager.dispose();
            m_shutdownJVMComplete = true;
        } else {
            if (!m_hookTriggered && m_hook != null) {
                try {
                    m_removeShutdownHookMethod.invoke((Object)Runtime.getRuntime(), m_hook);
                }
                catch (IllegalAccessException illegalAccessException) {
                    m_out.println("Wrapper Manager: Unable to unregister shutdown hook: " + illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (throwable == null) {
                        throwable = invocationTargetException;
                    }
                    m_out.println("Wrapper Manager: Unable to unregister shutdown hook: " + throwable);
                }
            }
            WrapperManager.signalStopped(n);
            WrapperManager.dispose();
            if (m_debug) {
                m_out.println("calling System.exit(" + n + ")");
            }
            m_shutdownJVMComplete = true;
            WrapperManager.safeSystemExit(n);
        }
    }

    private static void safeSystemExit(int n) {
        try {
            System.exit(n);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            m_out.println("Wrapper Manager: Attempted System.exit(" + n + ") call failed: " + illegalThreadStateException.toString());
            m_out.println("                 Trying Runtime.halt(" + n + ")");
            Runtime.getRuntime().halt(n);
        }
    }

    private static void privilegedStopInner(int n) {
        boolean bl;
        Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        synchronized (clazz) {
            m_stopping = true;
            if (m_stoppingThread == null) {
                m_stoppingThread = Thread.currentThread();
                bl = false;
            } else {
                if (Thread.currentThread() == m_stoppingThread) {
                    throw new IllegalStateException("WrapperManager.stop() can not be called recursively.");
                }
                bl = true;
            }
        }
        if (bl) {
            if (m_debug) {
                m_out.println("Thread, " + Thread.currentThread().getName() + ", waiting for the JVM to exit.");
                if (Thread.currentThread() == m_hook) {
                    m_out.println("System.exit appears to have been called from within the");
                    m_out.println("  WrapperListener.stop() method.  If possible the application");
                    m_out.println("  should be modified to avoid this behavior.");
                    m_out.println("  To avoid a deadlock, this thread will only wait 5 seconds");
                    m_out.println("  for the application to shutdown.  This may result in the");
                    m_out.println("  application failing to shutdown completely before the JVM");
                    m_out.println("  exists.  Removing the offending System.exit call will");
                    m_out.println("  resolve this.");
                }
            }
            int n2 = 0;
            int n3 = 50;
            while (true) {
                try {
                    Thread.sleep(n3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Thread.currentThread() == m_hook && (m_shutdownJVMComplete || n2 > 5000 / n3)) {
                    if (!m_shutdownJVMComplete && m_debug) {
                        m_out.println("Thread, " + Thread.currentThread().getName() + ", continuing after 5 seconds.");
                    }
                    WrapperManager.signalStopped(m_exitCode);
                    return;
                }
                ++n2;
            }
        }
        if (m_debug) {
            m_out.println("Thread, " + Thread.currentThread().getName() + ", handling the shutdown process.");
        }
        m_exitCode = n;
        int n4 = n;
        if (m_started) {
            int n5 = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(5);
            if (m_listener == null) {
                if (m_debug) {
                    m_out.println("No WrapperListener has been set.  Nothing to stop.");
                }
            } else {
                if (m_debug) {
                    m_out.println("calling listener.stop()");
                }
                if (Thread.currentThread().isDaemon()) {
                    final Integer[] integerArray = new Integer[]{new Integer(n4)};
                    Thread thread = new Thread("WrapperListener_stop_runner"){

                        public void run() {
                            if (m_debug) {
                                m_out.println("WrapperListener.stop runner thread started.");
                            }
                            try {
                                try {
                                    integerArray[0] = new Integer(m_listener.stop(integerArray[0]));
                                }
                                catch (Throwable throwable) {
                                    m_out.println("Error in WrapperListener.stop callback.  " + throwable);
                                    throwable.printStackTrace();
                                }
                                Object var3_2 = null;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                if (m_debug) {
                                    m_out.println("WrapperListener.stop runner thread stopped.");
                                }
                                throw throwable;
                            }
                            if (m_debug) {
                                m_out.println("WrapperListener.stop runner thread stopped.");
                            }
                        }
                    };
                    thread.setDaemon(false);
                    thread.start();
                    if (m_debug) {
                        m_out.println("Waiting for WrapperListener.stop runner thread to complete.");
                    }
                    while (thread != null && thread.isAlive()) {
                        try {
                            thread.join();
                            thread = null;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    n4 = integerArray[0];
                } else {
                    try {
                        n4 = m_listener.stop(n4);
                    }
                    catch (Throwable throwable) {
                        m_out.println("Error in WrapperListener.stop callback.  " + throwable);
                        throwable.printStackTrace();
                    }
                }
                if (m_debug) {
                    m_out.println("returned from listener.stop() -> " + n4);
                }
            }
            Thread.currentThread().setPriority(n5);
        }
        WrapperManager.shutdownJVM(n4);
    }

    private static void signalStarted() {
        WrapperManager.sendCommand((byte)106, "");
        m_started = true;
    }

    private static void controlEvent(int n) {
        boolean bl;
        String string;
        switch (n) {
            case 200: {
                string = "WRAPPER_CTRL_C_EVENT";
                bl = m_ignoreSignals;
                break;
            }
            case 201: {
                string = "WRAPPER_CTRL_CLOSE_EVENT";
                bl = m_ignoreSignals;
                break;
            }
            case 202: {
                string = "WRAPPER_CTRL_LOGOFF_EVENT";
                bl = false;
                break;
            }
            case 203: {
                string = "WRAPPER_CTRL_SHUTDOWN_EVENT";
                bl = false;
                break;
            }
            case 204: {
                string = "WRAPPER_CTRL_TERM_EVENT";
                bl = m_ignoreSignals;
                break;
            }
            case 205: {
                string = "WRAPPER_CTRL_HUP_EVENT";
                bl = m_ignoreSignals;
                break;
            }
            default: {
                string = "Unexpected event: " + n;
                bl = false;
            }
        }
        WrapperControlEvent wrapperControlEvent = new WrapperControlEvent(n, string);
        if (bl) {
            wrapperControlEvent.consume();
        }
        WrapperManager.fireWrapperEvent(wrapperControlEvent);
        if (!wrapperControlEvent.isConsumed()) {
            if (bl) {
                if (m_debug) {
                    m_out.println("Ignoring control event(" + string + ")");
                }
            } else {
                if (m_debug) {
                    m_out.println("Processing control event(" + string + ")");
                }
                if (m_listener != null) {
                    try {
                        m_listener.controlEvent(n);
                    }
                    catch (Throwable throwable) {
                        m_out.println("Error in WrapperListener.controlEvent callback.  " + throwable);
                        throwable.printStackTrace();
                    }
                } else {
                    WrapperManager.stop(0);
                }
            }
        }
    }

    private static void readProperties(String string) {
        WrapperProperties wrapperProperties = new WrapperProperties();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            do {
                int n3;
                if ((n3 = string.indexOf(PROPERTY_SEPARATOR, n2)) >= 0) {
                    if (n3 > 0) {
                        stringBuffer.append(string.substring(n2, n3));
                    }
                    if (n3 < n - 1) {
                        if (string.charAt(n3 + 1) == PROPERTY_SEPARATOR) {
                            stringBuffer.append(PROPERTY_SEPARATOR);
                            n2 = n3 + 2;
                            continue;
                        }
                        bl = true;
                        n2 = n3 + 1;
                        continue;
                    }
                    bl = true;
                    n2 = n3 + 1;
                    continue;
                }
                stringBuffer.append(string.substring(n2));
                bl = true;
                n2 = n;
            } while (!bl);
            String string2 = stringBuffer.toString();
            int n4 = string2.indexOf(61);
            if (n4 <= 0) continue;
            String string3 = string2.substring(0, n4);
            String string4 = n4 < string2.length() - 1 ? string2.substring(n4 + 1) : "";
            wrapperProperties.setProperty(string3, string4);
        }
        wrapperProperties.lock();
        m_properties = wrapperProperties;
    }

    private static synchronized Socket openSocket() {
        boolean bl;
        int n;
        InetAddress inetAddress;
        if (m_debug) {
            m_out.println("Open socket to wrapper..." + Thread.currentThread().getName());
        }
        try {
            inetAddress = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException unknownHostException) {
            m_out.println(unknownHostException);
            WrapperManager.stop(1);
            return null;
        }
        boolean bl2 = false;
        if (m_jvmPort > 0) {
            n = m_jvmPort;
            bl = true;
        } else {
            n = m_jvmPortMin;
            bl = false;
        }
        do {
            try {
                m_socket = new Socket(inetAddress, m_port, inetAddress, n);
                if (m_debug) {
                    m_out.println("Opened Socket from " + n + " to " + m_port);
                }
                bl2 = true;
                break;
            }
            catch (SocketException socketException) {
                String string = socketException.getMessage();
                if (socketException instanceof ConnectException) {
                    m_out.println("Failed to connect to the Wrapper at port " + m_port + ".");
                    m_out.println(socketException);
                    m_out.println("Exiting JVM...");
                    WrapperManager.stopImmediate(1);
                    continue;
                }
                if (socketException instanceof BindException || string != null && string.indexOf("errno: 48") >= 0) {
                    if (m_debug) {
                        m_out.println("Failed attempt to bind using local port " + n);
                    }
                    if (bl) {
                        n = m_jvmPortMin;
                        bl = false;
                        continue;
                    }
                    ++n;
                    continue;
                }
                m_out.println(socketException);
                m_socket = null;
                return null;
            }
            catch (IOException iOException) {
                m_out.println(iOException);
                m_socket = null;
                return null;
            }
        } while (n <= m_jvmPortMax);
        if (bl2) {
            if (m_jvmPort > 0 && m_jvmPort != n) {
                m_out.println("Port " + m_jvmPort + " already in use, using port " + n + " instead.");
            }
        } else {
            if (m_jvmPortMax > m_jvmPortMin) {
                m_out.println("Failed to connect to the Wrapper at port " + m_port + " by binding to any " + "ports in the range " + m_jvmPortMin + " to " + m_jvmPortMax + ".");
            } else {
                m_out.println("Failed to connect to the Wrapper at port " + m_port + " by binding to port " + m_jvmPortMin + ".");
            }
            m_out.println("Exiting JVM...");
            WrapperManager.stopImmediate(1);
        }
        try {
            m_socket.setTcpNoDelay(true);
            if (m_soTimeout > 0) {
                m_socket.setSoTimeout(m_soTimeout);
            }
        }
        catch (IOException iOException) {
            m_out.println(iOException);
        }
        WrapperManager.sendCommand((byte)110, m_key);
        return m_socket;
    }

    private static synchronized void closeSocket() {
        if (m_socket != null) {
            if (m_debug) {
                m_out.println("Closing socket.");
            }
            try {
                try {
                    m_socket.close();
                }
                catch (IOException iOException) {
                    Object var2_1 = null;
                    m_socket = null;
                }
                Object var2 = null;
                m_socket = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                m_socket = null;
                throw throwable;
            }
        }
    }

    private static String getPacketCodeName(byte by) {
        String string;
        switch (by) {
            case 100: {
                string = "START";
                break;
            }
            case 101: {
                string = "STOP";
                break;
            }
            case 102: {
                string = "RESTART";
                break;
            }
            case 103: {
                string = "PING";
                break;
            }
            case 104: {
                string = "STOP_PENDING";
                break;
            }
            case 105: {
                string = "START_PENDING";
                break;
            }
            case 106: {
                string = "STARTED";
                break;
            }
            case 107: {
                string = "STOPPED";
                break;
            }
            case 110: {
                string = "KEY";
                break;
            }
            case 111: {
                string = "BADKEY";
                break;
            }
            case 112: {
                string = "LOW_LOG_LEVEL";
                break;
            }
            case 113: {
                string = "PING_TIMEOUT";
                break;
            }
            case 114: {
                string = "SERVICE_CONTROL_CODE";
                break;
            }
            case 115: {
                string = "PROPERTIES";
                break;
            }
            case 117: {
                string = "LOG(DEBUG)";
                break;
            }
            case 118: {
                string = "LOG(INFO)";
                break;
            }
            case 119: {
                string = "LOG(STATUS)";
                break;
            }
            case 120: {
                string = "LOG(WARN)";
                break;
            }
            case 121: {
                string = "LOG(ERROR)";
                break;
            }
            case 122: {
                string = "LOG(FATAL)";
                break;
            }
            case 123: {
                string = "LOG(ADVICE)";
                break;
            }
            default: {
                string = "UNKNOWN(" + by + ")";
            }
        }
        return string;
    }

    private static synchronized void sendCommand(byte by, String string) {
        if (m_debug) {
            m_out.println("Send a packet " + WrapperManager.getPacketCodeName(by) + " : " + string);
        }
        if (!m_appearHung) {
            Socket socket = m_socket;
            if (socket == null && WrapperManager.isControlledByNativeWrapper() && !m_stopping) {
                socket = WrapperManager.openSocket();
            }
            if (by == 105 || by == 106) {
                m_lastPingTicks = WrapperManager.getTicks();
            }
            if (socket != null) {
                try {
                    byte[] byArray = string.getBytes();
                    if (m_commandBuffer.length < byArray.length + 2) {
                        m_commandBuffer = new byte[byArray.length + 2];
                    }
                    WrapperManager.m_commandBuffer[0] = by;
                    System.arraycopy(byArray, 0, m_commandBuffer, 1, byArray.length);
                    int n = byArray.length + 2;
                    WrapperManager.m_commandBuffer[n - 1] = 0;
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write(m_commandBuffer, 0, n);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    m_out.println(iOException);
                    iOException.printStackTrace();
                    WrapperManager.closeSocket();
                }
            }
        }
    }

    private static void handleSocket() {
        WrapperPingEvent wrapperPingEvent = new WrapperPingEvent();
        try {
            if (m_debug) {
                m_out.println("handleSocket(" + m_socket + ")");
            }
            DataInputStream dataInputStream = new DataInputStream(m_socket.getInputStream());
            block23: while (!m_disposed) {
                int n;
                try {
                    Object object;
                    byte by = dataInputStream.readByte();
                    int n2 = 0;
                    do {
                        if ((n = (int)dataInputStream.readByte()) == 0) continue;
                        if (n2 >= m_socketReadBuffer.length) {
                            object = m_socketReadBuffer;
                            m_socketReadBuffer = new byte[((byte[])object).length + 256];
                            System.arraycopy(object, 0, m_socketReadBuffer, 0, ((byte[])object).length);
                        }
                        WrapperManager.m_socketReadBuffer[n2] = n;
                        ++n2;
                    } while (n != 0);
                    object = new String(m_socketReadBuffer, 0, n2);
                    if (m_appearHung) continue;
                    if (m_debug) {
                        Object object2 = by == 115 ? "(Property Values)" : (Object)object;
                        m_out.println("Received a packet " + WrapperManager.getPacketCodeName(by) + " : " + (String)object2);
                    }
                    switch (by) {
                        case 100: {
                            WrapperManager.startInner();
                            break;
                        }
                        case 101: {
                            if (m_stopping) continue block23;
                            WrapperManager.privilegedStopInner(0);
                            break;
                        }
                        case 103: {
                            m_lastPingTicks = WrapperManager.getTicks();
                            WrapperManager.sendCommand((byte)103, "ok");
                            if (!m_produceCoreEvents) continue block23;
                            WrapperManager.fireWrapperEvent(wrapperPingEvent);
                            break;
                        }
                        case 111: {
                            m_out.println("Authorization key rejected by Wrapper.  Exiting JVM.");
                            WrapperManager.closeSocket();
                            WrapperManager.privilegedStopInner(1);
                            break;
                        }
                        case 112: {
                            try {
                                m_lowLogLevel = Integer.parseInt((String)object);
                                boolean bl = m_debug = m_lowLogLevel <= 1;
                                if (!m_debug) continue block23;
                                m_out.println("Wrapper Manager: LowLogLevel from Wrapper is " + m_lowLogLevel);
                            }
                            catch (NumberFormatException numberFormatException) {
                                m_out.println("Encountered an Illegal LowLogLevel from the Wrapper: " + (String)object);
                            }
                            continue block23;
                        }
                        case 113: {
                            try {
                                m_pingTimeout = Integer.parseInt((String)object) * 1000;
                                if (m_debug) {
                                    m_out.println("PingTimeout from Wrapper is " + m_pingTimeout);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                m_out.println("Encountered an Illegal PingTimeout from the Wrapper: " + (String)object);
                            }
                            if (m_pingTimeout <= 0) {
                                m_socket.setSoTimeout(0);
                                break;
                            }
                            if (m_soTimeout >= m_pingTimeout) continue block23;
                            m_socket.setSoTimeout(m_pingTimeout);
                            break;
                        }
                        case 114: {
                            try {
                                int n3 = Integer.parseInt((String)object);
                                if (m_debug) {
                                    m_out.println("ServiceControlCode from Wrapper with code " + n3);
                                }
                                WrapperServiceControlEvent wrapperServiceControlEvent = new WrapperServiceControlEvent(n3);
                                WrapperManager.fireWrapperEvent(wrapperServiceControlEvent);
                            }
                            catch (NumberFormatException numberFormatException) {
                                m_out.println("Encountered an Illegal ServiceControlCode from the Wrapper: " + (String)object);
                            }
                            continue block23;
                        }
                        case 115: {
                            WrapperManager.readProperties((String)object);
                            break;
                        }
                        default: {
                            m_out.println("Wrapper code received an unknown packet type: " + by);
                        }
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    n = WrapperManager.getTicks();
                    if (!m_started || m_stopping) continue;
                    if (m_debug) {
                        m_out.println("Read Timed out. (Last Ping was " + WrapperManager.getTickAge(m_lastPingTicks, n) + " milliseconds ago)");
                    }
                    if (m_appearHung) continue;
                    long l = WrapperManager.getTickAge(m_lastPingTicks, n);
                    long l2 = WrapperManager.getTickAge(m_eventRunnerTicks, n);
                    if (l2 >= 10000L || m_pingTimeout <= 0) continue;
                    if (l > (long)(m_pingTimeout + 90000)) {
                        m_out.println("Wrapper Manager: JVM did not exit.  Give up.");
                        WrapperManager.safeSystemExit(1);
                        continue;
                    }
                    if (l <= (long)m_pingTimeout) continue;
                    m_out.println("Wrapper Manager: The Wrapper code did not ping the JVM for " + l / 1000L + " seconds.  " + "Quit and let the Wrapper resynch.");
                    if (m_stopping) continue;
                    WrapperManager.sendCommand((byte)102, "restart");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    WrapperManager.privilegedStopInner(1);
                }
            }
            return;
        }
        catch (SocketException socketException) {
            if (m_debug && m_socket != null) {
                m_out.println("Closed socket: " + socketException);
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void startRunner() {
        block8: {
            if (!WrapperManager.isControlledByNativeWrapper()) break block8;
            if (WrapperManager.m_commRunner == null) {
                WrapperManager.m_commRunner = new Thread((Runnable)WrapperManager.m_instance, "Wrapper-Connection");
                WrapperManager.m_commRunner.setDaemon(true);
                WrapperManager.m_commRunner.start();
            }
            var0 = WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager == null ? (WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager;
            synchronized (var0) {
                if (true) ** GOTO lbl21
            }
        }
        var0_1 = WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager == null ? (WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager;
        synchronized (var0_1) {
            WrapperManager.m_commRunnerStarted = true;
            (WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager == null ? (WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager).notifyAll();
            return;
        }
        {
            do {
                try {
                    (WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : WrapperManager.class$org$tanukisoftware$wrapper$WrapperManager).wait(100L);
                }
                catch (InterruptedException var1_2) {
                    // empty catch block
                }
lbl21:
                // 3 sources

            } while (!WrapperManager.m_commRunnerStarted);
            return;
        }
    }

    public void run() {
        Class clazz;
        if (Thread.currentThread() != m_commRunner) {
            throw new IllegalStateException("Only the comm runner thread is allowed to call this method.");
        }
        if (m_debug) {
            m_out.println("Communications runner thread started.");
        }
        Thread.currentThread().setPriority(10);
        m_lastPingTicks = WrapperManager.getTicks();
        boolean bl = false;
        while (!m_disposed) {
            try {
                Object var5_7;
                try {
                    WrapperManager.openSocket();
                    if (!m_commRunnerStarted) {
                        clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager;
                        synchronized (clazz) {
                            m_commRunnerStarted = true;
                            (class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager).notifyAll();
                        }
                    }
                    if (m_socket != null) {
                        WrapperManager.handleSocket();
                    } else {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    var5_7 = null;
                }
                catch (Throwable throwable) {
                    var5_7 = null;
                    WrapperManager.closeSocket();
                    throw throwable;
                }
                WrapperManager.closeSocket();
                {
                }
            }
            catch (ThreadDeath threadDeath) {
                m_out.println(m_warning.format("SERVER_DAEMON_KILLED"));
            }
            catch (Throwable throwable) {
                if (m_shuttingDown) continue;
                m_out.println(m_error.format("SERVER_DAEMON_DIED"));
                throwable.printStackTrace();
            }
        }
        clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
        synchronized (clazz) {
            if (!m_commRunnerStarted) {
                m_commRunnerStarted = true;
                (class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager).notifyAll();
            }
        }
        if (m_debug) {
            m_out.println(m_info.format("SERVER_DAEMON_SHUT_DOWN"));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_securityManagerChecked = false;
        m_disposed = false;
        m_started = false;
        m_instance = null;
        m_hook = null;
        m_hookTriggered = false;
        m_shutdownJVMComplete = false;
        m_port = 15003;
        m_soTimeout = 10000;
        m_cpuTimeout = 10000L;
        m_lowLogLevel = 8;
        m_pingTimeout = 30000;
        m_ignoreSignals = false;
        m_commRunnerStarted = false;
        m_shuttingDown = false;
        m_appearHung = false;
        m_addShutdownHookMethod = null;
        m_removeShutdownHookMethod = null;
        m_service = false;
        m_debug = false;
        m_jvmId = 0;
        m_stopping = false;
        m_libraryOK = false;
        m_commandBuffer = new byte[512];
        m_wrapperEventListenerMaskList = new ArrayList();
        m_wrapperEventListenerMasks = null;
        m_produceCoreEvents = false;
        m_error = m_res = ResourceManager.getResourceManager();
        m_warning = m_res;
        m_info = m_res;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedClassInit();
                return null;
            }
        });
        PROPERTY_SEPARATOR = (char)9;
        m_socketReadBuffer = new byte[256];
    }

    private static class WrapperTickEventImpl
    extends WrapperTickEvent {
        private int m_ticks;
        private int m_tickOffset;

        private WrapperTickEventImpl() {
        }

        public int getTicks() {
            return this.m_ticks;
        }

        public int getTickOffset() {
            return this.m_tickOffset;
        }
    }

    private static class WrapperEventListenerMask {
        private WrapperEventListener m_listener;
        private long m_mask;

        private WrapperEventListenerMask() {
        }
    }
}

