/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.jmx;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineStart;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineTerminate;
import org.squirrelframework.foundation.fsm.jmx.StateMachineManagement;

public class ManagementService {
    public static final String DOMAIN = "org.squirrelframework";

    public void register(StateMachine<?, ?, ?, ?> stateMachine) {
        if (stateMachine.isRemoteMonitorEnabled()) {
            stateMachine.addDeclarativeListener(this);
        }
    }

    @OnStateMachineStart
    public void onStateMachineStart(StateMachine<?, ?, ?, ?> stateMachine) {
        ObjectName objectName;
        StateMachineManagement stateMachineManagement = new StateMachineManagement(stateMachine);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (!mBeanServer.isRegistered(objectName = this.createObjectName(stateMachine))) {
            try {
                mBeanServer.registerMBean(stateMachineManagement, objectName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @OnStateMachineTerminate
    public void onStateMachineTerminate(StateMachine<?, ?, ?, ?> stateMachine) {
        ObjectName objectName;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mBeanServer.isRegistered(objectName = this.createObjectName(stateMachine))) {
            try {
                mBeanServer.unregisterMBean(objectName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected ObjectName createObjectName(StateMachine<?, ?, ?, ?> stateMachine) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
        hashtable.put("type", ManagementService.quote(stateMachine.getClass().getSimpleName()));
        hashtable.put("name", ManagementService.quote(stateMachine.getIdentifier()));
        try {
            return new ObjectName(DOMAIN, hashtable);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException();
        }
    }

    public static String quote(String string) {
        return Pattern.compile("[:\",=*?]").matcher(string).find() ? ObjectName.quote(string) : string;
    }
}

