/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.Conditions;
import org.squirrelframework.foundation.fsm.Converter;
import org.squirrelframework.foundation.fsm.ConverterProvider;
import org.squirrelframework.foundation.fsm.HistoryType;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.StateCompositeType;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineBuilder;
import org.squirrelframework.foundation.fsm.StateMachineBuilderFactory;
import org.squirrelframework.foundation.fsm.StateMachineImporter;
import org.squirrelframework.foundation.fsm.impl.StateMachineBuilderImpl;
import org.squirrelframework.foundation.fsm.impl.TransitionBuilderImpl;
import org.squirrelframework.foundation.util.ReflectUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StateMachineImporterImpl<T extends StateMachine<T, S, E, C>, S, E, C>
extends DefaultHandler
implements StateMachineImporter<T, S, E, C> {
    public static String SQRL_NAMESPACE = "http://squirrelframework.org/squirrel";
    public static String SCXML_NAMESPACE = "http://www.w3.org/2005/07/scxml";
    protected String value = "";
    protected String sqrlPrefix = "";
    protected Converter<S> stateConverter;
    protected Converter<E> eventConverter;
    protected StateMachineBuilder<T, S, E, C> stateMachineBuilder;
    protected final Stack<MutableState<T, S, E, C>> currentStates = new Stack();
    protected TransitionBuilderImpl<T, S, E, C> currentTranstionBuilder;
    protected final ListMultimap<MutableState<T, S, E, C>, MutableState<T, S, E, C>> hierarchicalStateStore = ArrayListMultimap.create();
    protected Boolean isEntryAction;
    protected final Map<String, Object> reusableInstance = Maps.newHashMap();

    public StateMachineImporterImpl() {
        this.registerReusableInstance(Conditions.always());
        this.registerReusableInstance(Conditions.never());
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (string2.equals(SQRL_NAMESPACE)) {
            this.sqrlPrefix = string;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.value = new String(cArray, n, n2);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("fsm") && string.equals(SQRL_NAMESPACE)) {
            String string4;
            String string5;
            Object object;
            String string6 = attributes.getValue("fsm-type");
            Class<?> clazz = ReflectUtils.getClass(string6);
            Preconditions.checkNotNull(clazz);
            String string7 = attributes.getValue("state-type");
            Class<?> clazz2 = ReflectUtils.getClass(string7);
            Preconditions.checkNotNull(clazz2);
            this.stateConverter = ConverterProvider.INSTANCE.getConverter(clazz2);
            Preconditions.checkNotNull(this.stateConverter);
            String string8 = attributes.getValue("event-type");
            Class<?> clazz3 = ReflectUtils.getClass(string8);
            Preconditions.checkNotNull(clazz3);
            this.eventConverter = ConverterProvider.INSTANCE.getConverter(clazz3);
            Preconditions.checkNotNull(this.eventConverter);
            String string9 = attributes.getValue("context-type");
            Class<?> clazz4 = ReflectUtils.getClass(string9);
            Preconditions.checkNotNull(clazz4);
            String string10 = attributes.getValue("extra-parameters");
            Class[] classArray = new Class[]{};
            if (string10 != null && string10.length() > 2) {
                object = StringUtils.split(string10.substring(1, string10.length() - 1), ',');
                classArray = new Class[((String[])object).length];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    classArray[i] = ReflectUtils.getClass(object[i]);
                }
            }
            this.stateMachineBuilder = StateMachineBuilderFactory.create(clazz, clazz2, clazz3, clazz4, classArray);
            ((StateMachineBuilderImpl)this.stateMachineBuilder).setScanAnnotations(false);
            object = attributes.getValue("finish-event");
            if (object != null) {
                E e = this.eventConverter.convertFromString((String)object);
                this.stateMachineBuilder.defineFinishEvent(e);
            }
            if ((string5 = attributes.getValue("start-event")) != null) {
                string4 = this.eventConverter.convertFromString(string5);
                this.stateMachineBuilder.defineStartEvent(string4);
            }
            if ((string4 = attributes.getValue("terminate-event")) != null) {
                E e = this.eventConverter.convertFromString(string4);
                this.stateMachineBuilder.defineTerminateEvent(e);
            }
            this.currentStates.clear();
            this.currentTranstionBuilder = null;
        } else if (string3.equals("state") || string3.equals("final") || string3.equals("parallel")) {
            MutableState<T, S, E, C> mutableState = null;
            if (this.currentStates.size() > 0) {
                mutableState = this.getCurrentState();
            }
            String string11 = attributes.getValue("id");
            S s = this.stateConverter.convertFromString(string11);
            if (string3.equals("final")) {
                this.currentStates.push(this.stateMachineBuilder.defineFinalState(s));
            } else {
                this.currentStates.push(this.stateMachineBuilder.defineState(s));
                if (string3.equals("parallel")) {
                    this.getCurrentState().setCompositeType(StateCompositeType.PARALLEL);
                }
            }
            String string12 = attributes.getValue("initial");
            if (string12 != null) {
                S s2 = this.stateConverter.convertFromString(string12);
                this.getCurrentState().setInitialState(this.stateMachineBuilder.defineState(s2));
            }
            if (mutableState != null) {
                this.hierarchicalStateStore.put(mutableState, this.getCurrentState());
            }
        } else if (string3.equals("history")) {
            String string13 = attributes.getValue("type");
            if (string13.equals("deep")) {
                this.getCurrentState().setHistoryType(HistoryType.DEEP);
            } else if (string13.equals("shallow")) {
                this.getCurrentState().setHistoryType(HistoryType.SHALLOW);
            }
        } else if (string3.equals("onentry")) {
            this.isEntryAction = Boolean.TRUE;
        } else if (string3.equals("onexit")) {
            this.isEntryAction = Boolean.FALSE;
        } else if (string2.equals("action") && string.equals(SQRL_NAMESPACE)) {
            String string14 = attributes.getValue("content");
            int n = string14.indexOf("#");
            String string15 = string14.substring(0, n);
            String string16 = string14.substring(n + 1);
            n = string16.indexOf(":");
            String string17 = string16;
            String string18 = "";
            if (n > 0) {
                string17 = string16.substring(0, n);
                string18 = string16.substring(n + 1);
            }
            if (string15.equals("method")) {
                String string19 = string17 + ":" + string18;
                if (this.isConstructState()) {
                    if (Boolean.TRUE == this.isEntryAction) {
                        this.stateMachineBuilder.onEntry(this.getCurrentState().getStateId()).callMethod(string19);
                    } else {
                        this.stateMachineBuilder.onExit(this.getCurrentState().getStateId()).callMethod(string19);
                    }
                } else if (this.isConstructTransition()) {
                    this.getCurrentTranstionBuilder().callMethod(string19);
                }
            } else if (string15.equals("instance")) {
                Action action = (Action)this.newInstance(string17);
                if (this.isConstructState()) {
                    if (Boolean.TRUE == this.isEntryAction) {
                        this.stateMachineBuilder.onEntry(this.getCurrentState().getStateId()).perform(action);
                    } else if (Boolean.FALSE == this.isEntryAction) {
                        this.stateMachineBuilder.onExit(this.getCurrentState().getStateId()).perform(action);
                    }
                } else if (this.isConstructTransition()) {
                    this.getCurrentTranstionBuilder().perform(action);
                }
            } else if (string15.equals("mvel")) {
                if (this.isConstructState()) {
                    if (Boolean.TRUE == this.isEntryAction) {
                        this.stateMachineBuilder.onEntry(this.getCurrentState().getStateId()).evalMvel(string17);
                    } else if (Boolean.FALSE == this.isEntryAction) {
                        this.stateMachineBuilder.onExit(this.getCurrentState().getStateId()).evalMvel(string17);
                    }
                } else if (this.isConstructTransition()) {
                    this.getCurrentTranstionBuilder().evalMvel(string17);
                }
            }
        } else if (string3.equals("transition")) {
            String string20 = attributes.getValue("event");
            E e = this.eventConverter.convertFromString(string20);
            String string21 = attributes.getValue("target");
            S s = this.stateConverter.convertFromString(string21);
            String string22 = attributes.getValue(SQRL_NAMESPACE, "type");
            Integer n = 1;
            try {
                n = Integer.valueOf(attributes.getValue(SQRL_NAMESPACE, "priority"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            TransitionBuilderImpl transitionBuilderImpl = null;
            transitionBuilderImpl = string22.equals("INTERNAL") ? (TransitionBuilderImpl)this.stateMachineBuilder.internalTransition(n) : (string22.equals("LOCAL") ? (TransitionBuilderImpl)this.stateMachineBuilder.localTransition(n) : (TransitionBuilderImpl)this.stateMachineBuilder.externalTransition(n));
            this.currentTranstionBuilder = transitionBuilderImpl;
            this.getCurrentTranstionBuilder().from(this.getCurrentState().getStateId()).to(s).on(e);
            String string23 = attributes.getValue("cond");
            int n2 = string23.indexOf("#");
            String string24 = string23.substring(0, n2);
            String string25 = string23.substring(n2 + 1);
            if (string24.equals("instance")) {
                Condition condition = (Condition)this.newInstance(string25);
                this.getCurrentTranstionBuilder().when(condition);
            } else if (string24.equals("mvel")) {
                this.getCurrentTranstionBuilder().whenMvel(string25);
            }
        }
    }

    protected boolean isConstructState() {
        return this.currentStates.size() > 0 && this.currentTranstionBuilder == null && this.isEntryAction != null;
    }

    protected boolean isConstructTransition() {
        return this.currentStates.size() > 0 && this.currentTranstionBuilder != null && this.isEntryAction == null;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("onentry") || string3.equals("onexit")) {
            this.isEntryAction = null;
        } else if (string3.equals("state") || string3.equals("final") || string3.equals("parallel")) {
            MutableState<T, S, E, C> mutableState = this.currentStates.pop();
            Collection collection = this.hierarchicalStateStore.removeAll(mutableState);
            if (!collection.isEmpty()) {
                for (MutableState mutableState2 : collection) {
                    mutableState2.setParentState(mutableState);
                    mutableState.addChildState(mutableState2);
                }
            }
        } else if (string3.equals("transition")) {
            this.currentTranstionBuilder = null;
        }
    }

    private <M> M newInstance(String string) {
        Object object = this.reusableInstance.get(string);
        if (object == null) {
            object = ReflectUtils.newInstance(string);
        }
        return (M)object;
    }

    protected MutableState<T, S, E, C> getCurrentState() {
        return this.currentStates.peek();
    }

    protected TransitionBuilderImpl<T, S, E, C> getCurrentTranstionBuilder() {
        return this.currentTranstionBuilder;
    }

    @Override
    public StateMachineBuilder<T, S, E, C> importFromInputStream(InputStream inputStream) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this);
            return this.stateMachineBuilder;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Incorrect content format.", exception);
        }
    }

    @Override
    public StateMachineBuilder<T, S, E, C> importFromString(String string) {
        return this.importFromInputStream(new ByteArrayInputStream(string.getBytes()));
    }

    @Override
    public StateMachineBuilder<T, S, E, C> importFromFile(File file) {
        try {
            return this.importFromInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("Canont find file", fileNotFoundException);
        }
    }

    @Override
    public void registerReusableInstance(Object object) {
        this.registerReusableInstance(object.getClass().getName(), object);
    }

    @Override
    public void unregisterReusableInstance(String string) {
        this.reusableInstance.remove(string);
    }

    @Override
    public void registerReusableInstance(String string, Object object) {
        this.reusableInstance.put(string, object);
    }
}

