/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.ActionWrapper;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.Conditions;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.builder.DeferBoundActionBuilder;
import org.squirrelframework.foundation.fsm.builder.DeferBoundActionFrom;
import org.squirrelframework.foundation.fsm.builder.DeferBoundActionTo;
import org.squirrelframework.foundation.fsm.builder.On;
import org.squirrelframework.foundation.fsm.builder.When;
import org.squirrelframework.foundation.fsm.impl.DeferBoundActionInfo;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;

public class DeferBoundActionBuilderImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements DeferBoundActionBuilder<T, S, E, C>,
DeferBoundActionFrom<T, S, E, C>,
DeferBoundActionTo<T, S, E, C>,
On<T, S, E, C>,
SquirrelComponent {
    private final List<DeferBoundActionInfo<T, S, E, C>> deferBoundActionInfoList;
    private final ExecutionContext executionContext;
    private S from;
    private S to;
    private DeferBoundActionInfo<T, S, E, C> deferBoundActionInfo;
    private Condition<C> condition;

    DeferBoundActionBuilderImpl(List<DeferBoundActionInfo<T, S, E, C>> list, ExecutionContext executionContext) {
        this.deferBoundActionInfoList = list;
        this.executionContext = executionContext;
    }

    @Override
    public void perform(Action<T, S, E, C> action) {
        if (this.condition == null) {
            this.deferBoundActionInfo.setActions(Collections.singletonList(action));
        } else {
            this.deferBoundActionInfo.setActions(Collections.singletonList(this.warpConditionalAction(action)));
        }
    }

    @Override
    public void perform(List<? extends Action<T, S, E, C>> list) {
        if (this.condition == null) {
            this.deferBoundActionInfo.setActions(list);
        } else {
            List list2 = Lists.transform(list, new Function<Action<T, S, E, C>, Action<T, S, E, C>>(){

                @Override
                public Action<T, S, E, C> apply(Action<T, S, E, C> action) {
                    return DeferBoundActionBuilderImpl.this.warpConditionalAction(action);
                }
            });
            this.deferBoundActionInfo.setActions(list2);
        }
    }

    @Override
    public void evalMvel(String string) {
        Action action = FSM.newMvelAction(string, this.executionContext);
        this.perform(action);
    }

    @Override
    public void callMethod(String string) {
        MethodCallActionProxyImpl methodCallActionProxyImpl = FSM.newMethodCallActionProxy(string, this.executionContext);
        this.perform(methodCallActionProxyImpl);
    }

    @Override
    public On<T, S, E, C> on(E e) {
        this.deferBoundActionInfo = new DeferBoundActionInfo(this.from, this.to, e);
        this.deferBoundActionInfoList.add(this.deferBoundActionInfo);
        return this;
    }

    @Override
    public On<T, S, E, C> onAny() {
        this.deferBoundActionInfo = new DeferBoundActionInfo(this.from, this.to, null);
        this.deferBoundActionInfoList.add(this.deferBoundActionInfo);
        return this;
    }

    @Override
    public DeferBoundActionTo<T, S, E, C> to(S s) {
        this.to = s;
        return this;
    }

    @Override
    public DeferBoundActionTo<T, S, E, C> toAny() {
        return this;
    }

    @Override
    public DeferBoundActionFrom<T, S, E, C> fromAny() {
        return this;
    }

    @Override
    public DeferBoundActionFrom<T, S, E, C> from(S s) {
        this.from = s;
        return this;
    }

    @Override
    public When<T, S, E, C> when(Condition<C> condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public When<T, S, E, C> whenMvel(String string) {
        this.condition = FSM.newMvelCondition(string, this.executionContext.getScriptManager());
        return this;
    }

    private Action<T, S, E, C> warpConditionalAction(Action<T, S, E, C> action) {
        return new ActionWrapper<T, S, E, C>(action){

            @Override
            public void execute(S s, S s2, E e, C c, T t) {
                if (Conditions.isSatified(DeferBoundActionBuilderImpl.this.condition, c)) {
                    super.execute(s, s2, e, c, t);
                }
            }
        };
    }
}

