/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertiesParser {
    Properties props = null;

    public PropertiesParser(Properties properties) {
        this.props = properties;
    }

    public Properties getUnderlyingProperties() {
        return this.props;
    }

    public String getStringProperty(String string) {
        return this.getStringProperty(string, null);
    }

    public String getStringProperty(String string, String string2) {
        String string3 = this.props.getProperty(string, string2);
        if (string3 == null) {
            return string2;
        }
        return (string3 = string3.trim()).length() == 0 ? string2 : string3;
    }

    public String[] getStringArrayProperty(String string) {
        return this.getStringArrayProperty(string, null);
    }

    public String[] getStringArrayProperty(String string, String[] stringArray) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (Exception exception) {
            return stringArray;
        }
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getStringProperty(string);
        return string2 == null ? bl : Boolean.valueOf(string2);
    }

    public byte getByteProperty(String string) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Byte.parseByte(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public byte getByteProperty(String string, byte by) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return by;
        }
        try {
            return Byte.parseByte(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public char getCharProperty(String string) {
        return this.getCharProperty(string, '\u0000');
    }

    public char getCharProperty(String string, char c) {
        String string2 = this.getStringProperty(string);
        return string2 == null ? c : string2.charAt(0);
    }

    public double getDoubleProperty(String string) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public double getDoubleProperty(String string, double d) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public float getFloatProperty(String string) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public float getFloatProperty(String string, float f) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return f;
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public int getIntProperty(String string) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public int getIntProperty(String string, int n) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public int[] getIntArrayProperty(String string) throws NumberFormatException {
        return this.getIntArrayProperty(string, null);
    }

    public int[] getIntArrayProperty(String string, int[] nArray) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return nArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    arrayList.add(new Integer(stringTokenizer.nextToken().trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NumberFormatException(" '" + string2 + "'");
                }
            }
            int[] nArray2 = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                nArray2[i] = (Integer)arrayList.get(i);
            }
            return nArray2;
        }
        catch (Exception exception) {
            return nArray;
        }
    }

    public long getLongProperty(String string) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public long getLongProperty(String string, long l) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public short getShortProperty(String string) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Short.parseShort(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public short getShortProperty(String string, short s) throws NumberFormatException {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return s;
        }
        try {
            return Short.parseShort(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public String[] getPropertyGroups(String string) {
        Enumeration<?> enumeration = this.props.propertyNames();
        HashSet<String> hashSet = new HashSet<String>(10);
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length(), string2.indexOf(46, string.length()));
            hashSet.add(string3);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public Properties getPropertyGroup(String string) {
        return this.getPropertyGroup(string, false, null);
    }

    public Properties getPropertyGroup(String string, boolean bl) {
        return this.getPropertyGroup(string, bl, null);
    }

    public Properties getPropertyGroup(String string, boolean bl, String[] stringArray) {
        Enumeration<?> enumeration = this.props.propertyNames();
        Properties properties = new Properties();
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            boolean bl2 = false;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length && !bl2; ++i) {
                    bl2 = string2.startsWith(stringArray[i]);
                }
            }
            if (bl2) continue;
            String string3 = this.getStringProperty(string2, "");
            if (bl) {
                properties.put(string2.substring(string.length()), string3);
                continue;
            }
            properties.put(string2, string3);
        }
        return properties;
    }
}

