/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJobFactory
implements JobFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public Job newJob(TriggerFiredBundle triggerFiredBundle, Scheduler scheduler) throws SchedulerException {
        JobDetail jobDetail = triggerFiredBundle.getJobDetail();
        Class<? extends Job> clazz = jobDetail.getJobClass();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Producing instance of Job '" + jobDetail.getKey() + "', class=" + clazz.getName());
            }
            return clazz.newInstance();
        }
        catch (Exception exception) {
            SchedulerException schedulerException = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "'", exception);
            throw schedulerException;
        }
    }
}

