/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class PropertySettingJobFactory
extends SimpleJobFactory {
    private boolean warnIfNotFound = false;
    private boolean throwIfNotFound = false;

    @Override
    public Job newJob(TriggerFiredBundle triggerFiredBundle, Scheduler scheduler) throws SchedulerException {
        Job job = super.newJob(triggerFiredBundle, scheduler);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.putAll(scheduler.getContext());
        jobDataMap.putAll(triggerFiredBundle.getJobDetail().getJobDataMap());
        jobDataMap.putAll(triggerFiredBundle.getTrigger().getJobDataMap());
        this.setBeanProps(job, jobDataMap);
        return job;
    }

    protected void setBeanProps(Object object, JobDataMap jobDataMap) throws SchedulerException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            this.handleError("Unable to introspect Job class.", introspectionException);
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (Map.Entry entry : jobDataMap.getWrappedMap().entrySet()) {
            String string = (String)entry.getKey();
            String string2 = string.substring(0, 1).toUpperCase(Locale.US);
            String string3 = "set" + string2 + string.substring(1);
            Method method = this.getSetMethod(string3, propertyDescriptorArray);
            Class<?> clazz = null;
            Object object2 = null;
            try {
                if (method == null) {
                    this.handleError("No setter on Job class " + object.getClass().getName() + " for property '" + string + "'");
                    continue;
                }
                clazz = method.getParameterTypes()[0];
                object2 = entry.getValue();
                Object object3 = null;
                if (clazz.isPrimitive()) {
                    if (object2 == null) {
                        this.handleError("Cannot set primitive property '" + string + "' on Job class " + object.getClass().getName() + " to null.");
                        continue;
                    }
                    if (clazz.equals(Integer.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Integer.valueOf((String)object2);
                        } else if (object2 instanceof Integer) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Long.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Long.valueOf((String)object2);
                        } else if (object2 instanceof Long) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Float.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Float.valueOf((String)object2);
                        } else if (object2 instanceof Float) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Double.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Double.valueOf((String)object2);
                        } else if (object2 instanceof Double) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Boolean.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Boolean.valueOf((String)object2);
                        } else if (object2 instanceof Boolean) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Byte.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Byte.valueOf((String)object2);
                        } else if (object2 instanceof Byte) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Short.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Short.valueOf((String)object2);
                        } else if (object2 instanceof Short) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Character.TYPE)) {
                        if (object2 instanceof String) {
                            String string4 = (String)object2;
                            if (string4.length() == 1) {
                                object3 = Character.valueOf(string4.charAt(0));
                            }
                        } else if (object2 instanceof Character) {
                            object3 = object2;
                        }
                    }
                } else if (object2 != null && clazz.isAssignableFrom(object2.getClass())) {
                    object3 = object2;
                }
                if (object2 != null && object3 == null) {
                    this.handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' expects a " + clazz + " but was given " + object2.getClass().getName());
                    continue;
                }
                method.invoke(object, object3);
            }
            catch (NumberFormatException numberFormatException) {
                this.handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' expects a " + clazz + " but was given " + object2.getClass().getName(), numberFormatException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' expects a " + clazz + " but was given " + object2.getClass().getName(), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' could not be accessed.", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' could not be invoked.", invocationTargetException);
            }
        }
    }

    private void handleError(String string) throws SchedulerException {
        this.handleError(string, null);
    }

    private void handleError(String string, Exception exception) throws SchedulerException {
        if (this.isThrowIfPropertyNotFound()) {
            throw new SchedulerException(string, exception);
        }
        if (this.isWarnIfPropertyNotFound()) {
            if (exception == null) {
                this.getLog().warn(string);
            } else {
                this.getLog().warn(string, exception);
            }
        }
    }

    private Method getSetMethod(String string, PropertyDescriptor[] propertyDescriptorArray) {
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Method method = propertyDescriptorArray[i].getWriteMethod();
            if (method == null || method.getParameterTypes().length != 1 || !method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    public boolean isThrowIfPropertyNotFound() {
        return this.throwIfNotFound;
    }

    public void setThrowIfPropertyNotFound(boolean bl) {
        this.throwIfNotFound = bl;
    }

    public boolean isWarnIfPropertyNotFound() {
        return this.warnIfNotFound;
    }

    public void setWarnIfPropertyNotFound(boolean bl) {
        this.warnIfNotFound = bl;
    }
}

