/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jmx;

import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXInvokerJob
implements Job {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            Object[] objectArray = null;
            String[] stringArray = null;
            String string = null;
            String string2 = null;
            JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
            String[] stringArray2 = jobDataMap.getKeys();
            for (int i = 0; i < stringArray2.length; ++i) {
                String string3 = jobDataMap.getString(stringArray2[i]);
                if ("JMX_OBJECTNAME".equalsIgnoreCase(stringArray2[i])) {
                    string = string3;
                    continue;
                }
                if ("JMX_METHOD".equalsIgnoreCase(stringArray2[i])) {
                    string2 = string3;
                    continue;
                }
                if (!"JMX_PARAMDEFS".equalsIgnoreCase(stringArray2[i])) continue;
                String[] stringArray3 = this.split(string3, ",");
                objectArray = new Object[stringArray3.length];
                stringArray = new String[stringArray3.length];
                block16: for (int j = 0; j < stringArray3.length; ++j) {
                    String[] stringArray4 = this.split(stringArray3[j], ":");
                    if (stringArray4.length < 2) {
                        throw new Exception("Invalid parameter definition: required parts missing " + stringArray3[j]);
                    }
                    switch (stringArray4[0].charAt(0)) {
                        case 'i': {
                            objectArray[j] = Integer.valueOf(jobDataMap.getString(stringArray4[1]));
                            stringArray[j] = Integer.TYPE.getName();
                            continue block16;
                        }
                        case 'I': {
                            objectArray[j] = Integer.valueOf(jobDataMap.getString(stringArray4[1]));
                            stringArray[j] = Integer.class.getName();
                            continue block16;
                        }
                        case 'l': {
                            objectArray[j] = Long.valueOf(jobDataMap.getString(stringArray4[1]));
                            stringArray[j] = Long.TYPE.getName();
                            continue block16;
                        }
                        case 'L': {
                            objectArray[j] = Long.valueOf(jobDataMap.getString(stringArray4[1]));
                            stringArray[j] = Long.class.getName();
                            continue block16;
                        }
                        case 'f': {
                            objectArray[j] = Float.valueOf(jobDataMap.getString(stringArray4[1]));
                            stringArray[j] = Float.TYPE.getName();
                            continue block16;
                        }
                        case 'F': {
                            objectArray[j] = Float.valueOf(jobDataMap.getString(stringArray4[1]));
                            stringArray[j] = Float.class.getName();
                            continue block16;
                        }
                        case 'd': {
                            objectArray[j] = Double.valueOf(jobDataMap.getString(stringArray4[1]));
                            stringArray[j] = Double.TYPE.getName();
                            continue block16;
                        }
                        case 'D': {
                            objectArray[j] = Double.valueOf(jobDataMap.getString(stringArray4[1]));
                            stringArray[j] = Double.class.getName();
                            continue block16;
                        }
                        case 's': {
                            objectArray[j] = jobDataMap.getString(stringArray4[1]);
                            stringArray[j] = String.class.getName();
                            continue block16;
                        }
                        case 'b': {
                            objectArray[j] = Boolean.valueOf(jobDataMap.getString(stringArray4[1]));
                            stringArray[j] = Boolean.TYPE.getName();
                            continue block16;
                        }
                        case 'B': {
                            objectArray[j] = Boolean.valueOf(jobDataMap.getString(stringArray4[1]));
                            stringArray[j] = Boolean.class.getName();
                        }
                    }
                }
            }
            if (string == null || string2 == null) {
                throw new Exception("Required parameters missing");
            }
            jobExecutionContext.setResult(this.invoke(string, string2, objectArray, stringArray));
        }
        catch (Exception exception) {
            String string = "Caught a " + exception.getClass().getName() + " exception : " + exception.getMessage();
            this.getLog().error(string, exception);
            throw new JobExecutionException(string, exception, false);
        }
    }

    private String[] split(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            linkedList.add(string3);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private Object invoke(String string, String string2, Object[] objectArray, String[] stringArray) throws Exception {
        MBeanServer mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
        ObjectName objectName = new ObjectName(string);
        if (mBeanServer == null) {
            throw new Exception("Can't find mbean server");
        }
        this.getLog().info("invoking " + string2);
        return mBeanServer.invoke(objectName, string2, objectArray, stringArray);
    }

    protected Logger getLog() {
        return this.log;
    }
}

