/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.jobs.FileScanListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class FileScanJob
implements Job {
    public static final String FILE_NAME = "FILE_NAME";
    public static final String FILE_SCAN_LISTENER_NAME = "FILE_SCAN_LISTENER_NAME";
    public static final String MINIMUM_UPDATE_AGE = "MINIMUM_UPDATE_AGE";
    private static final String LAST_MODIFIED_TIME = "LAST_MODIFIED_TIME";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getMergedJobDataMap();
        SchedulerContext schedulerContext = null;
        try {
            schedulerContext = jobExecutionContext.getScheduler().getContext();
        }
        catch (SchedulerException schedulerException) {
            throw new JobExecutionException("Error obtaining scheduler context.", schedulerException, false);
        }
        String string = jobDataMap.getString(FILE_NAME);
        String string2 = jobDataMap.getString(FILE_SCAN_LISTENER_NAME);
        if (string == null) {
            throw new JobExecutionException("Required parameter 'FILE_NAME' not found in merged JobDataMap");
        }
        if (string2 == null) {
            throw new JobExecutionException("Required parameter 'FILE_SCAN_LISTENER_NAME' not found in merged JobDataMap");
        }
        FileScanListener fileScanListener = (FileScanListener)schedulerContext.get(string2);
        if (fileScanListener == null) {
            throw new JobExecutionException("FileScanListener named '" + string2 + "' not found in SchedulerContext");
        }
        long l = -1L;
        if (jobDataMap.containsKey(LAST_MODIFIED_TIME)) {
            l = jobDataMap.getLong(LAST_MODIFIED_TIME);
        }
        long l2 = 5000L;
        if (jobDataMap.containsKey(MINIMUM_UPDATE_AGE)) {
            l2 = jobDataMap.getLong(MINIMUM_UPDATE_AGE);
        }
        long l3 = System.currentTimeMillis() + l2;
        long l4 = this.getLastModifiedDate(string);
        if (l4 < 0L) {
            this.log.warn("File '" + string + "' does not exist.");
            return;
        }
        if (l > 0L && l4 > l && l4 < l3) {
            this.log.info("File '" + string + "' updated, notifying listener.");
            fileScanListener.fileUpdated(string);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("File '" + string + "' unchanged.");
        }
        jobExecutionContext.getJobDetail().getJobDataMap().put(LAST_MODIFIED_TIME, l4);
    }

    protected long getLastModifiedDate(String string) {
        File file;
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        String string2 = uRL == null ? string : URLDecoder.decode(uRL.getFile());
        int n = string2.indexOf(33);
        if (n > 0) {
            string2 = string2.substring(5, string2.indexOf(33));
        }
        if (!(file = new File(string2)).exists()) {
            return -1L;
        }
        return file.lastModified();
    }
}

