/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore.oracle.weblogic;

import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.oracle.OracleDelegate;
import weblogic.jdbc.vendor.oracle.OracleThinBlob;

public class WebLogicOracleDelegate
extends OracleDelegate {
    @Override
    protected Blob writeDataToBlob(ResultSet resultSet, int n, byte[] byArray) throws SQLException {
        Blob blob = resultSet.getBlob(n);
        if (blob == null) {
            throw new SQLException("Driver's Blob representation is null!");
        }
        if (blob instanceof OracleThinBlob) {
            ((OracleThinBlob)blob).putBytes(1L, byArray);
            return blob;
        }
        if (blob.getClass().getPackage().getName().startsWith("weblogic.")) {
            try {
                Method method = blob.getClass().getMethod("putBytes", Long.TYPE, byte[].class);
                method.invoke((Object)blob, new Long(1L), byArray);
            }
            catch (Exception exception) {
                try {
                    Method method = blob.getClass().getMethod("setBytes", Long.TYPE, byte[].class);
                    method.invoke((Object)blob, new Long(1L), byArray);
                }
                catch (Exception exception2) {
                    throw new SQLException("Unable to find putBytes(long,byte[]) or setBytes(long,byte[]) methods on blob: " + exception2);
                }
            }
            return blob;
        }
        return super.writeDataToBlob(resultSet, n, byArray);
    }
}

