/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.jdbcjobstore.TriggerPersistenceDelegate;
import org.quartz.spi.OperableTrigger;

public class PointbaseDelegate
extends StdJDBCDelegate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertJobDetail(Connection connection, JobDetail jobDetail) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(jobDetail.getJobDataMap());
        int n = byteArrayOutputStream.toByteArray().length;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        PreparedStatement preparedStatement = null;
        int n2 = 0;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA)  VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            preparedStatement.setString(1, jobDetail.getKey().getName());
            preparedStatement.setString(2, jobDetail.getKey().getGroup());
            preparedStatement.setString(3, jobDetail.getDescription());
            preparedStatement.setString(4, jobDetail.getJobClass().getName());
            this.setBoolean(preparedStatement, 5, jobDetail.isDurable());
            this.setBoolean(preparedStatement, 6, jobDetail.isConcurrentExectionDisallowed());
            this.setBoolean(preparedStatement, 7, jobDetail.isPersistJobDataAfterExecution());
            this.setBoolean(preparedStatement, 8, jobDetail.requestsRecovery());
            preparedStatement.setBinaryStream(9, (InputStream)byteArrayInputStream, n);
            n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            PointbaseDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        PointbaseDelegate.closeStatement(preparedStatement);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateJobDetail(Connection connection, JobDetail jobDetail) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(jobDetail.getJobDataMap());
        int n = byteArrayOutputStream.toByteArray().length;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        PreparedStatement preparedStatement = null;
        int n2 = 0;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_NONCONCURRENT = ?, IS_UPDATE_DATA = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setString(1, jobDetail.getDescription());
            preparedStatement.setString(2, jobDetail.getJobClass().getName());
            this.setBoolean(preparedStatement, 3, jobDetail.isDurable());
            this.setBoolean(preparedStatement, 4, jobDetail.isConcurrentExectionDisallowed());
            this.setBoolean(preparedStatement, 5, jobDetail.isPersistJobDataAfterExecution());
            this.setBoolean(preparedStatement, 6, jobDetail.requestsRecovery());
            preparedStatement.setBinaryStream(7, (InputStream)byteArrayInputStream, n);
            preparedStatement.setString(8, jobDetail.getKey().getName());
            preparedStatement.setString(9, jobDetail.getKey().getGroup());
            n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            PointbaseDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        PointbaseDelegate.closeStatement(preparedStatement);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertTrigger(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        PreparedStatement preparedStatement;
        block6: {
            ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(operableTrigger.getJobDataMap());
            int n2 = byteArrayOutputStream.toByteArray().length;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            preparedStatement = null;
            n = 0;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA, PRIORITY)  VALUES({1}, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                preparedStatement.setString(1, operableTrigger.getKey().getName());
                preparedStatement.setString(2, operableTrigger.getKey().getGroup());
                preparedStatement.setString(3, operableTrigger.getJobKey().getName());
                preparedStatement.setString(4, operableTrigger.getJobKey().getGroup());
                preparedStatement.setString(5, operableTrigger.getDescription());
                preparedStatement.setBigDecimal(6, new BigDecimal(String.valueOf(operableTrigger.getNextFireTime().getTime())));
                long l = -1L;
                if (operableTrigger.getPreviousFireTime() != null) {
                    l = operableTrigger.getPreviousFireTime().getTime();
                }
                preparedStatement.setBigDecimal(7, new BigDecimal(String.valueOf(l)));
                preparedStatement.setString(8, string);
                TriggerPersistenceDelegate triggerPersistenceDelegate = this.findTriggerPersistenceDelegate(operableTrigger);
                String string2 = "BLOB";
                if (triggerPersistenceDelegate != null) {
                    string2 = triggerPersistenceDelegate.getHandledTriggerTypeDiscriminator();
                }
                preparedStatement.setString(9, string2);
                preparedStatement.setBigDecimal(10, new BigDecimal(String.valueOf(operableTrigger.getStartTime().getTime())));
                long l2 = 0L;
                if (operableTrigger.getEndTime() != null) {
                    l2 = operableTrigger.getEndTime().getTime();
                }
                preparedStatement.setBigDecimal(11, new BigDecimal(String.valueOf(l2)));
                preparedStatement.setString(12, operableTrigger.getCalendarName());
                preparedStatement.setInt(13, operableTrigger.getMisfireInstruction());
                preparedStatement.setBinaryStream(14, (InputStream)byteArrayInputStream, n2);
                preparedStatement.setInt(15, operableTrigger.getPriority());
                n = preparedStatement.executeUpdate();
                if (triggerPersistenceDelegate == null) {
                    this.insertBlobTrigger(connection, operableTrigger);
                    break block6;
                }
                triggerPersistenceDelegate.insertExtendedTriggerProperties(connection, operableTrigger, string, jobDetail);
            }
            catch (Throwable throwable) {
                PointbaseDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        PointbaseDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateTrigger(Connection connection, OperableTrigger operableTrigger, String string, JobDetail jobDetail) throws SQLException, IOException {
        int n;
        PreparedStatement preparedStatement;
        block7: {
            ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(operableTrigger.getJobDataMap());
            int n2 = byteArrayOutputStream.toByteArray().length;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            preparedStatement = null;
            n = 0;
            try {
                preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ?, JOB_DATA = ? WHERE SCHED_NAME = {1} AND TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                preparedStatement.setString(1, operableTrigger.getJobKey().getName());
                preparedStatement.setString(2, operableTrigger.getJobKey().getGroup());
                preparedStatement.setString(3, operableTrigger.getDescription());
                long l = -1L;
                if (operableTrigger.getNextFireTime() != null) {
                    l = operableTrigger.getNextFireTime().getTime();
                }
                preparedStatement.setBigDecimal(4, new BigDecimal(String.valueOf(l)));
                long l2 = -1L;
                if (operableTrigger.getPreviousFireTime() != null) {
                    l2 = operableTrigger.getPreviousFireTime().getTime();
                }
                preparedStatement.setBigDecimal(5, new BigDecimal(String.valueOf(l2)));
                preparedStatement.setString(6, string);
                TriggerPersistenceDelegate triggerPersistenceDelegate = this.findTriggerPersistenceDelegate(operableTrigger);
                String string2 = "BLOB";
                if (triggerPersistenceDelegate != null) {
                    string2 = triggerPersistenceDelegate.getHandledTriggerTypeDiscriminator();
                }
                preparedStatement.setString(7, string2);
                preparedStatement.setBigDecimal(8, new BigDecimal(String.valueOf(operableTrigger.getStartTime().getTime())));
                long l3 = 0L;
                if (operableTrigger.getEndTime() != null) {
                    l3 = operableTrigger.getEndTime().getTime();
                }
                preparedStatement.setBigDecimal(9, new BigDecimal(String.valueOf(l3)));
                preparedStatement.setString(10, operableTrigger.getCalendarName());
                preparedStatement.setInt(11, operableTrigger.getMisfireInstruction());
                preparedStatement.setInt(12, operableTrigger.getPriority());
                preparedStatement.setBinaryStream(13, (InputStream)byteArrayInputStream, n2);
                preparedStatement.setString(14, operableTrigger.getKey().getName());
                preparedStatement.setString(15, operableTrigger.getKey().getGroup());
                n = preparedStatement.executeUpdate();
                if (triggerPersistenceDelegate == null) {
                    this.updateBlobTrigger(connection, operableTrigger);
                    break block7;
                }
                triggerPersistenceDelegate.updateExtendedTriggerProperties(connection, operableTrigger, string, jobDetail);
            }
            catch (Throwable throwable) {
                PointbaseDelegate.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        PointbaseDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateJobData(Connection connection, JobDetail jobDetail) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = this.serializeJobData(jobDetail.getJobDataMap());
        int n2 = byteArrayOutputStream.toByteArray().length;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE SCHED_NAME = {1} AND JOB_NAME = ? AND JOB_GROUP = ?"));
            preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, n2);
            preparedStatement.setString(2, jobDetail.getKey().getName());
            preparedStatement.setString(3, jobDetail.getKey().getGroup());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            PointbaseDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        PointbaseDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insertCalendar(Connection connection, String string, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = this.serializeObject(calendar);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (SCHED_NAME, CALENDAR_NAME, CALENDAR)  VALUES({1}, ?, ?)"));
            preparedStatement.setString(1, string);
            preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, byArray.length);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            PointbaseDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        PointbaseDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateCalendar(Connection connection, String string, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = this.serializeObject(calendar);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE SCHED_NAME = {1} AND CALENDAR_NAME = ?"));
            preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
            preparedStatement.setString(2, string);
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            PointbaseDelegate.closeStatement(preparedStatement);
            throw throwable;
        }
        PointbaseDelegate.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getObjectFromBlob(ResultSet resultSet, String string) throws ClassNotFoundException, IOException, SQLException {
        Object object = null;
        byte[] byArray = resultSet.getBytes(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (null != byteArrayInputStream && ((InputStream)byteArrayInputStream).available() != 0) {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                object = objectInputStream.readObject();
            }
            finally {
                objectInputStream.close();
            }
        }
        return object;
    }

    @Override
    protected Object getJobDataFromBlob(ResultSet resultSet, String string) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            byte[] byArray = resultSet.getBytes(string);
            if (byArray == null) {
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream;
        }
        return this.getObjectFromBlob(resultSet, string);
    }
}

