/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchedulerDetailsSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerDetailsSetter.class);

    private SchedulerDetailsSetter() {
    }

    static void setDetails(Object object, String string, String string2) throws SchedulerException {
        SchedulerDetailsSetter.set(object, "setInstanceName", string);
        SchedulerDetailsSetter.set(object, "setInstanceId", string2);
    }

    private static void set(Object object, String string, String string2) throws SchedulerException {
        Method method;
        try {
            method = object.getClass().getMethod(string, String.class);
        }
        catch (SecurityException securityException) {
            LOGGER.error("A SecurityException occured: " + securityException.getMessage(), securityException);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.warn(object.getClass().getName() + " does not contain public method " + string + "(String)");
            return;
        }
        if (Modifier.isAbstract(method.getModifiers())) {
            LOGGER.warn(object.getClass().getName() + " does not implement " + string + "(String)");
            return;
        }
        try {
            method.invoke(object, string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SchedulerException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
    }
}

