/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.JobRunShell;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzSchedulerThread
extends Thread {
    private QuartzScheduler qs;
    private QuartzSchedulerResources qsRsrcs;
    private final Object sigLock = new Object();
    private boolean signaled;
    private long signaledNextFireTime;
    private boolean paused;
    private AtomicBoolean halted;
    private Random random = new Random(System.currentTimeMillis());
    private static long DEFAULT_IDLE_WAIT_TIME = 30000L;
    private long idleWaitTime = DEFAULT_IDLE_WAIT_TIME;
    private int idleWaitVariablness = 7000;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    QuartzSchedulerThread(QuartzScheduler quartzScheduler, QuartzSchedulerResources quartzSchedulerResources) {
        this(quartzScheduler, quartzSchedulerResources, quartzSchedulerResources.getMakeSchedulerThreadDaemon(), 5);
    }

    QuartzSchedulerThread(QuartzScheduler quartzScheduler, QuartzSchedulerResources quartzSchedulerResources, boolean bl, int n) {
        super(quartzScheduler.getSchedulerThreadGroup(), quartzSchedulerResources.getThreadName());
        this.qs = quartzScheduler;
        this.qsRsrcs = quartzSchedulerResources;
        this.setDaemon(bl);
        if (quartzSchedulerResources.isThreadsInheritInitializersClassLoadContext()) {
            this.log.info("QuartzSchedulerThread Inheriting ContextClassLoader of thread: " + Thread.currentThread().getName());
            this.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        }
        this.setPriority(n);
        this.paused = true;
        this.halted = new AtomicBoolean(false);
    }

    void setIdleWaitTime(long l) {
        this.idleWaitTime = l;
        this.idleWaitVariablness = (int)((double)l * 0.2);
    }

    private long getRandomizedIdleWaitTime() {
        return this.idleWaitTime - (long)this.random.nextInt(this.idleWaitVariablness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void togglePause(boolean bl) {
        Object object = this.sigLock;
        synchronized (object) {
            this.paused = bl;
            if (this.paused) {
                this.signalSchedulingChange(0L);
            } else {
                this.sigLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void halt(boolean bl) {
        Object object = this.sigLock;
        synchronized (object) {
            this.halted.set(true);
            if (this.paused) {
                this.sigLock.notifyAll();
            } else {
                this.signalSchedulingChange(0L);
            }
        }
        if (bl) {
            boolean bl2 = false;
            try {
                while (true) {
                    try {
                        this.join();
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    boolean isPaused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalSchedulingChange(long l) {
        Object object = this.sigLock;
        synchronized (object) {
            this.signaled = true;
            this.signaledNextFireTime = l;
            this.sigLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSignaledSchedulingChange() {
        Object object = this.sigLock;
        synchronized (object) {
            this.signaled = false;
            this.signaledNextFireTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScheduleChanged() {
        Object object = this.sigLock;
        synchronized (object) {
            return this.signaled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSignaledNextFireTime() {
        Object object = this.sigLock;
        synchronized (object) {
            return this.signaledNextFireTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        while (!this.halted.get()) {
            try {
                long l;
                List<OperableTrigger> list;
                block43: {
                    Object object = this.sigLock;
                    synchronized (object) {
                        while (this.paused && !this.halted.get()) {
                            try {
                                this.sigLock.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (this.halted.get()) {
                            break;
                        }
                    }
                    int n = this.qsRsrcs.getThreadPool().blockForAvailableThreads();
                    if (n <= 0) continue;
                    list = null;
                    l = System.currentTimeMillis();
                    this.clearSignaledSchedulingChange();
                    try {
                        list = this.qsRsrcs.getJobStore().acquireNextTriggers(l + this.idleWaitTime, Math.min(n, this.qsRsrcs.getMaxBatchSize()), this.qsRsrcs.getBatchTimeWindow());
                        bl = false;
                        if (!this.log.isDebugEnabled()) break block43;
                        this.log.debug("batch acquisition of " + (list == null ? 0 : list.size()) + " triggers");
                    }
                    catch (JobPersistenceException jobPersistenceException) {
                        if (!bl) {
                            this.qs.notifySchedulerListenersError("An error occurred while scanning for the next triggers to fire.", jobPersistenceException);
                        }
                        bl = true;
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        if (!bl) {
                            this.getLog().error("quartzSchedulerThreadLoop: RuntimeException " + runtimeException.getMessage(), runtimeException);
                        }
                        bl = true;
                        continue;
                    }
                }
                if (list != null && !list.isEmpty()) {
                    List<Object> list2;
                    block44: {
                        l = System.currentTimeMillis();
                        long l2 = list.get(0).getNextFireTime().getTime();
                        long l3 = l2 - l;
                        while (l3 > 2L) {
                            list2 = this.sigLock;
                            synchronized (list2) {
                                if (this.halted.get()) {
                                    break;
                                }
                                if (!this.isCandidateNewTimeEarlierWithinReason(l2, false)) {
                                    try {
                                        l = System.currentTimeMillis();
                                        l3 = l2 - l;
                                        if (l3 >= 1L) {
                                            this.sigLock.wait(l3);
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (this.releaseIfScheduleChangedSignificantly(list, l2)) break;
                            l = System.currentTimeMillis();
                            l3 = l2 - l;
                        }
                        if (list.isEmpty()) continue;
                        list2 = new ArrayList();
                        boolean bl2 = true;
                        List<TriggerFiredResult> list3 = this.sigLock;
                        synchronized (list3) {
                            bl2 = !this.halted.get();
                        }
                        if (bl2) {
                            try {
                                list3 = this.qsRsrcs.getJobStore().triggersFired(list);
                                if (list3 == null) break block44;
                                list2 = list3;
                            }
                            catch (SchedulerException schedulerException) {
                                this.qs.notifySchedulerListenersError("An error occurred while firing triggers '" + list + "'", schedulerException);
                                for (int i = 0; i < list.size(); ++i) {
                                    this.qsRsrcs.getJobStore().releaseAcquiredTrigger(list.get(i));
                                }
                                continue;
                            }
                        }
                    }
                    for (int i = 0; i < list2.size(); ++i) {
                        TriggerFiredResult triggerFiredResult = (TriggerFiredResult)list2.get(i);
                        TriggerFiredBundle triggerFiredBundle = triggerFiredResult.getTriggerFiredBundle();
                        Exception exception = triggerFiredResult.getException();
                        if (exception instanceof RuntimeException) {
                            this.getLog().error("RuntimeException while firing trigger " + list.get(i), exception);
                            this.qsRsrcs.getJobStore().releaseAcquiredTrigger(list.get(i));
                            continue;
                        }
                        if (triggerFiredBundle == null) {
                            this.qsRsrcs.getJobStore().releaseAcquiredTrigger(list.get(i));
                            continue;
                        }
                        JobRunShell jobRunShell = null;
                        try {
                            jobRunShell = this.qsRsrcs.getJobRunShellFactory().createJobRunShell(triggerFiredBundle);
                            jobRunShell.initialize(this.qs);
                        }
                        catch (SchedulerException schedulerException) {
                            this.qsRsrcs.getJobStore().triggeredJobComplete(list.get(i), triggerFiredBundle.getJobDetail(), Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR);
                            continue;
                        }
                        if (this.qsRsrcs.getThreadPool().runInThread(jobRunShell)) continue;
                        this.getLog().error("ThreadPool.runInThread() return false!");
                        this.qsRsrcs.getJobStore().triggeredJobComplete(list.get(i), triggerFiredBundle.getJobDetail(), Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR);
                    }
                    continue;
                }
                long l4 = System.currentTimeMillis();
                long l5 = l4 + this.getRandomizedIdleWaitTime();
                long l6 = l5 - l4;
                Object object = this.sigLock;
                synchronized (object) {
                    try {
                        if (!this.halted.get() && !this.isScheduleChanged()) {
                            this.sigLock.wait(l6);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                this.getLog().error("Runtime error occurred in main trigger firing loop.", runtimeException);
            }
        }
        this.qs = null;
        this.qsRsrcs = null;
    }

    private boolean releaseIfScheduleChangedSignificantly(List<OperableTrigger> list, long l) {
        if (this.isCandidateNewTimeEarlierWithinReason(l, true)) {
            for (OperableTrigger operableTrigger : list) {
                this.qsRsrcs.getJobStore().releaseAcquiredTrigger(operableTrigger);
            }
            list.clear();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCandidateNewTimeEarlierWithinReason(long l, boolean bl) {
        Object object = this.sigLock;
        synchronized (object) {
            long l2;
            if (!this.isScheduleChanged()) {
                return false;
            }
            boolean bl2 = false;
            if (this.getSignaledNextFireTime() == 0L) {
                bl2 = true;
            } else if (this.getSignaledNextFireTime() < l) {
                bl2 = true;
            }
            if (bl2 && (l2 = l - System.currentTimeMillis()) < (this.qsRsrcs.getJobStore().supportsPersistence() ? 70L : 7L)) {
                bl2 = false;
            }
            if (bl) {
                this.clearSignaledSchedulingChange();
            }
            return bl2;
        }
    }

    public Logger getLog() {
        return this.log;
    }
}

