/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.core.NullSampledStatisticsImpl;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.SampledStatistics;
import org.quartz.core.SampledStatisticsImpl;
import org.quartz.core.jmx.JobDetailSupport;
import org.quartz.core.jmx.JobExecutionContextSupport;
import org.quartz.core.jmx.QuartzSchedulerMBean;
import org.quartz.core.jmx.TriggerSupport;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.spi.OperableTrigger;

public class QuartzSchedulerMBeanImpl
extends StandardMBean
implements NotificationEmitter,
QuartzSchedulerMBean,
JobListener,
SchedulerListener {
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final QuartzScheduler scheduler;
    private boolean sampledStatisticsEnabled;
    private SampledStatistics sampledStatistics;
    private static final SampledStatistics NULL_SAMPLED_STATISTICS;
    protected final Emitter emitter = new Emitter();
    protected final AtomicLong sequenceNumber = new AtomicLong();

    protected QuartzSchedulerMBeanImpl(QuartzScheduler quartzScheduler) throws NotCompliantMBeanException {
        super(QuartzSchedulerMBean.class);
        this.scheduler = quartzScheduler;
        this.scheduler.addInternalJobListener(this);
        this.scheduler.addInternalSchedulerListener(this);
        this.sampledStatistics = NULL_SAMPLED_STATISTICS;
        this.sampledStatisticsEnabled = false;
    }

    @Override
    public TabularData getCurrentlyExecutingJobs() throws Exception {
        try {
            List<JobExecutionContext> list = this.scheduler.getCurrentlyExecutingJobs();
            return JobExecutionContextSupport.toTabularData(list);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public TabularData getAllJobDetails() throws Exception {
        try {
            ArrayList<JobDetail> arrayList = new ArrayList<JobDetail>();
            for (String string : this.scheduler.getJobGroupNames()) {
                for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals(string))) {
                    arrayList.add(this.scheduler.getJobDetail(jobKey));
                }
            }
            return JobDetailSupport.toTabularData(arrayList.toArray(new JobDetail[arrayList.size()]));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<CompositeData> getAllTriggers() throws Exception {
        try {
            ArrayList<Trigger> arrayList = new ArrayList<Trigger>();
            for (String string : this.scheduler.getTriggerGroupNames()) {
                for (TriggerKey triggerKey : this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals(string))) {
                    arrayList.add(this.scheduler.getTrigger(triggerKey));
                }
            }
            return TriggerSupport.toCompositeList(arrayList);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void addJob(CompositeData compositeData, boolean bl) throws Exception {
        try {
            this.scheduler.addJob(JobDetailSupport.newJobDetail(compositeData), bl);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    private static void invokeSetter(Object object, String string, Object object2) throws Exception {
        String string2 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        Class[] classArray = new Class[]{object2.getClass()};
        Method method = QuartzSchedulerMBeanImpl.findMethod(object.getClass(), string2, classArray);
        if (method == null) {
            throw new Exception("Unable to find setter for attribute '" + string + "' and value '" + object2 + "'");
        }
        method.invoke(object, object2);
    }

    private static Class<?> getWrapperIfPrimitive(Class<?> clazz) {
        Class clazz2 = clazz;
        try {
            Field field = clazz.getField("TYPE");
            field.setAccessible(true);
            clazz2 = (Class)field.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz2;
    }

    private static Method findMethod(Class<?> clazz, String string, Class<?>[] classArray) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        if (beanInfo != null) {
            for (MethodDescriptor methodDescriptor : beanInfo.getMethodDescriptors()) {
                Method method = methodDescriptor.getMethod();
                Class<?>[] classArray2 = method.getParameterTypes();
                if (!string.equals(method.getName()) || classArray.length != classArray2.length) continue;
                boolean bl = true;
                for (int i = 0; i < classArray.length; ++i) {
                    if (QuartzSchedulerMBeanImpl.getWrapperIfPrimitive(classArray[i]) == classArray2[i]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return method;
            }
        }
        return null;
    }

    @Override
    public void scheduleBasicJob(Map<String, Object> map, Map<String, Object> map2) throws Exception {
        try {
            JobDetail jobDetail = JobDetailSupport.newJobDetail(map);
            OperableTrigger operableTrigger = TriggerSupport.newTrigger(map2);
            this.scheduler.deleteJob(jobDetail.getKey());
            this.scheduler.scheduleJob(jobDetail, operableTrigger);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void scheduleJob(Map<String, Object> map, Map<String, Object> map2) throws Exception {
        try {
            Object object;
            String string;
            String string2 = (String)map2.remove("triggerClass");
            if (string2 == null) {
                throw new IllegalArgumentException("No triggerClass specified");
            }
            Class<?> clazz = Class.forName(string2);
            Trigger trigger = (Trigger)clazz.newInstance();
            String string3 = (String)map.remove("jobDetailClass");
            if (string3 == null) {
                throw new IllegalArgumentException("No jobDetailClass specified");
            }
            Class<?> clazz2 = Class.forName(string3);
            JobDetail jobDetail = (JobDetail)clazz2.newInstance();
            String string4 = (String)map.remove("jobClass");
            if (string4 == null) {
                throw new IllegalArgumentException("No jobClass specified");
            }
            Class<?> clazz3 = Class.forName(string4);
            map.put("jobClass", clazz3);
            for (Map.Entry<String, Object> object22 : map2.entrySet()) {
                string = object22.getKey();
                object = object22.getValue();
                if ("jobDataMap".equals(string)) {
                    object = new JobDataMap((Map)object);
                }
                QuartzSchedulerMBeanImpl.invokeSetter(trigger, string, object);
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                string = entry.getKey();
                object = entry.getValue();
                if ("jobDataMap".equals(string)) {
                    object = new JobDataMap((Map)object);
                }
                QuartzSchedulerMBeanImpl.invokeSetter(jobDetail, string, object);
            }
            AbstractTrigger abstractTrigger = (AbstractTrigger)trigger;
            abstractTrigger.setKey(new TriggerKey(abstractTrigger.getName(), abstractTrigger.getGroup()));
            Date date = abstractTrigger.getStartTime();
            if (date == null || date.before(new Date())) {
                abstractTrigger.setStartTime(new Date());
            }
            this.scheduler.deleteJob(jobDetail.getKey());
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void scheduleJob(String string, String string2, Map<String, Object> map) throws Exception {
        try {
            JobKey jobKey = new JobKey(string, string2);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (jobDetail == null) {
                throw new IllegalArgumentException("No such job '" + jobKey + "'");
            }
            String string3 = (String)map.remove("triggerClass");
            if (string3 == null) {
                throw new IllegalArgumentException("No triggerClass specified");
            }
            Class<?> clazz = Class.forName(string3);
            Trigger trigger = (Trigger)clazz.newInstance();
            for (Map.Entry<String, Object> object2 : map.entrySet()) {
                String string4 = object2.getKey();
                Object object = object2.getValue();
                if ("jobDataMap".equals(string4)) {
                    object = new JobDataMap((Map)object);
                }
                QuartzSchedulerMBeanImpl.invokeSetter(trigger, string4, object);
            }
            AbstractTrigger abstractTrigger = (AbstractTrigger)trigger;
            abstractTrigger.setKey(new TriggerKey(abstractTrigger.getName(), abstractTrigger.getGroup()));
            Date date = abstractTrigger.getStartTime();
            if (date == null || date.before(new Date())) {
                abstractTrigger.setStartTime(new Date());
            }
            this.scheduler.scheduleJob(trigger);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void addJob(Map<String, Object> map, boolean bl) throws Exception {
        try {
            String string = (String)map.remove("jobDetailClass");
            if (string == null) {
                throw new IllegalArgumentException("No jobDetailClass specified");
            }
            Class<?> clazz = Class.forName(string);
            JobDetail jobDetail = (JobDetail)clazz.newInstance();
            String string2 = (String)map.remove("jobClass");
            if (string2 == null) {
                throw new IllegalArgumentException("No jobClass specified");
            }
            Class<?> clazz2 = Class.forName(string2);
            map.put("jobClass", clazz2);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string3 = entry.getKey();
                Object object = entry.getValue();
                if ("jobDataMap".equals(string3)) {
                    object = new JobDataMap((Map)object);
                }
                QuartzSchedulerMBeanImpl.invokeSetter(jobDetail, string3, object);
            }
            this.scheduler.addJob(jobDetail, bl);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    private Exception newPlainException(Exception exception) {
        String string = exception.getClass().getName();
        if (string.startsWith("java.") || string.startsWith("javax.")) {
            return exception;
        }
        Exception exception2 = new Exception(exception.getMessage());
        exception2.setStackTrace(exception.getStackTrace());
        return exception2;
    }

    @Override
    public void deleteCalendar(String string) throws Exception {
        try {
            this.scheduler.deleteCalendar(string);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public boolean deleteJob(String string, String string2) throws Exception {
        try {
            return this.scheduler.deleteJob(JobKey.jobKey(string, string2));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<String> getCalendarNames() throws Exception {
        try {
            return this.scheduler.getCalendarNames();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public CompositeData getJobDetail(String string, String string2) throws Exception {
        try {
            JobDetail jobDetail = this.scheduler.getJobDetail(JobKey.jobKey(string, string2));
            return JobDetailSupport.toCompositeData(jobDetail);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<String> getJobGroupNames() throws Exception {
        try {
            return this.scheduler.getJobGroupNames();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<String> getJobNames(String string) throws Exception {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals(string))) {
                arrayList.add(jobKey.getName());
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public String getJobStoreClassName() {
        return this.scheduler.getJobStoreClass().getName();
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws Exception {
        try {
            return this.scheduler.getPausedTriggerGroups();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public CompositeData getTrigger(String string, String string2) throws Exception {
        try {
            Trigger trigger = this.scheduler.getTrigger(TriggerKey.triggerKey(string, string2));
            return TriggerSupport.toCompositeData(trigger);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<String> getTriggerGroupNames() throws Exception {
        try {
            return this.scheduler.getTriggerGroupNames();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<String> getTriggerNames(String string) throws Exception {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TriggerKey triggerKey : this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals(string))) {
                arrayList.add(triggerKey.getName());
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public String getTriggerState(String string, String string2) throws Exception {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey(string, string2);
            Trigger.TriggerState triggerState = this.scheduler.getTriggerState(triggerKey);
            return triggerState.name();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public List<CompositeData> getTriggersOfJob(String string, String string2) throws Exception {
        try {
            JobKey jobKey = JobKey.jobKey(string, string2);
            return TriggerSupport.toCompositeList(this.scheduler.getTriggersOfJob(jobKey));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public boolean interruptJob(String string, String string2) throws Exception {
        try {
            return this.scheduler.interrupt(JobKey.jobKey(string, string2));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public boolean interruptJob(String string) throws Exception {
        try {
            return this.scheduler.interrupt(string);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public Date scheduleJob(String string, String string2, String string3, String string4) throws Exception {
        try {
            JobKey jobKey = JobKey.jobKey(string, string2);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (jobDetail == null) {
                throw new IllegalArgumentException("No such job: " + jobKey);
            }
            TriggerKey triggerKey = TriggerKey.triggerKey(string3, string4);
            Trigger trigger = this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                throw new IllegalArgumentException("No such trigger: " + triggerKey);
            }
            return this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public boolean unscheduleJob(String string, String string2) throws Exception {
        try {
            return this.scheduler.unscheduleJob(TriggerKey.triggerKey(string, string2));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void clear() throws Exception {
        try {
            this.scheduler.clear();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public String getVersion() {
        return this.scheduler.getVersion();
    }

    @Override
    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    @Override
    public boolean isStarted() {
        return this.scheduler.isStarted();
    }

    @Override
    public void start() throws Exception {
        try {
            this.scheduler.start();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
    }

    @Override
    public void standby() {
        this.scheduler.standby();
    }

    @Override
    public boolean isStandbyMode() {
        return this.scheduler.isInStandbyMode();
    }

    @Override
    public String getSchedulerName() {
        return this.scheduler.getSchedulerName();
    }

    @Override
    public String getSchedulerInstanceId() {
        return this.scheduler.getSchedulerInstanceId();
    }

    @Override
    public String getThreadPoolClassName() {
        return this.scheduler.getThreadPoolClass().getName();
    }

    @Override
    public int getThreadPoolSize() {
        return this.scheduler.getThreadPoolSize();
    }

    @Override
    public void pauseJob(String string, String string2) throws Exception {
        try {
            this.scheduler.pauseJob(JobKey.jobKey(string, string2));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    public void pauseJobs(GroupMatcher<JobKey> groupMatcher) throws Exception {
        try {
            this.scheduler.pauseJobs(groupMatcher);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void pauseJobGroup(String string) throws Exception {
        this.pauseJobs(GroupMatcher.groupEquals(string));
    }

    @Override
    public void pauseJobsStartingWith(String string) throws Exception {
        this.pauseJobs(GroupMatcher.groupStartsWith(string));
    }

    @Override
    public void pauseJobsEndingWith(String string) throws Exception {
        this.pauseJobs(GroupMatcher.groupEndsWith(string));
    }

    @Override
    public void pauseJobsContaining(String string) throws Exception {
        this.pauseJobs(GroupMatcher.groupContains(string));
    }

    @Override
    public void pauseJobsAll() throws Exception {
        this.pauseJobs(GroupMatcher.anyJobGroup());
    }

    @Override
    public void pauseAllTriggers() throws Exception {
        try {
            this.scheduler.pauseAll();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    private void pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) throws Exception {
        try {
            this.scheduler.pauseTriggers(groupMatcher);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void pauseTriggerGroup(String string) throws Exception {
        this.pauseTriggers(GroupMatcher.groupEquals(string));
    }

    @Override
    public void pauseTriggersStartingWith(String string) throws Exception {
        this.pauseTriggers(GroupMatcher.groupStartsWith(string));
    }

    @Override
    public void pauseTriggersEndingWith(String string) throws Exception {
        this.pauseTriggers(GroupMatcher.groupEndsWith(string));
    }

    @Override
    public void pauseTriggersContaining(String string) throws Exception {
        this.pauseTriggers(GroupMatcher.groupContains(string));
    }

    @Override
    public void pauseTriggersAll() throws Exception {
        this.pauseTriggers(GroupMatcher.anyTriggerGroup());
    }

    @Override
    public void pauseTrigger(String string, String string2) throws Exception {
        try {
            this.scheduler.pauseTrigger(TriggerKey.triggerKey(string, string2));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void resumeAllTriggers() throws Exception {
        try {
            this.scheduler.resumeAll();
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void resumeJob(String string, String string2) throws Exception {
        try {
            this.scheduler.resumeJob(JobKey.jobKey(string, string2));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    public void resumeJobs(GroupMatcher<JobKey> groupMatcher) throws Exception {
        try {
            this.scheduler.resumeJobs(groupMatcher);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void resumeJobGroup(String string) throws Exception {
        this.resumeJobs(GroupMatcher.groupEquals(string));
    }

    @Override
    public void resumeJobsStartingWith(String string) throws Exception {
        this.resumeJobs(GroupMatcher.groupStartsWith(string));
    }

    @Override
    public void resumeJobsEndingWith(String string) throws Exception {
        this.resumeJobs(GroupMatcher.groupEndsWith(string));
    }

    @Override
    public void resumeJobsContaining(String string) throws Exception {
        this.resumeJobs(GroupMatcher.groupContains(string));
    }

    @Override
    public void resumeJobsAll() throws Exception {
        this.resumeJobs(GroupMatcher.anyJobGroup());
    }

    @Override
    public void resumeTrigger(String string, String string2) throws Exception {
        try {
            this.scheduler.resumeTrigger(TriggerKey.triggerKey(string, string2));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    private void resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) throws Exception {
        try {
            this.scheduler.resumeTriggers(groupMatcher);
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void resumeTriggerGroup(String string) throws Exception {
        this.resumeTriggers(GroupMatcher.groupEquals(string));
    }

    @Override
    public void resumeTriggersStartingWith(String string) throws Exception {
        this.resumeTriggers(GroupMatcher.groupStartsWith(string));
    }

    @Override
    public void resumeTriggersEndingWith(String string) throws Exception {
        this.resumeTriggers(GroupMatcher.groupEndsWith(string));
    }

    @Override
    public void resumeTriggersContaining(String string) throws Exception {
        this.resumeTriggers(GroupMatcher.groupContains(string));
    }

    @Override
    public void resumeTriggersAll() throws Exception {
        this.resumeTriggers(GroupMatcher.anyTriggerGroup());
    }

    @Override
    public void triggerJob(String string, String string2, Map<String, String> map) throws Exception {
        try {
            this.scheduler.triggerJob(JobKey.jobKey(string, string2), new JobDataMap(map));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    public void triggerJob(CompositeData compositeData) throws Exception {
        try {
            this.scheduler.triggerJob(TriggerSupport.newTrigger(compositeData));
        }
        catch (Exception exception) {
            throw this.newPlainException(exception);
        }
    }

    @Override
    public void jobAdded(JobDetail jobDetail) {
        this.sendNotification("jobAdded", JobDetailSupport.toCompositeData(jobDetail));
    }

    @Override
    public void jobDeleted(JobKey jobKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobName", jobKey.getName());
        hashMap.put("jobGroup", jobKey.getGroup());
        this.sendNotification("jobDeleted", hashMap);
    }

    @Override
    public void jobScheduled(Trigger trigger) {
        this.sendNotification("jobScheduled", TriggerSupport.toCompositeData(trigger));
    }

    @Override
    public void jobUnscheduled(TriggerKey triggerKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("triggerName", triggerKey.getName());
        hashMap.put("triggerGroup", triggerKey.getGroup());
        this.sendNotification("jobUnscheduled", hashMap);
    }

    @Override
    public void schedulingDataCleared() {
        this.sendNotification("schedulingDataCleared");
    }

    @Override
    public void jobPaused(JobKey jobKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobName", jobKey.getName());
        hashMap.put("jobGroup", jobKey.getGroup());
        this.sendNotification("jobsPaused", hashMap);
    }

    @Override
    public void jobsPaused(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobName", null);
        hashMap.put("jobGroup", string);
        this.sendNotification("jobsPaused", hashMap);
    }

    @Override
    public void jobsResumed(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobName", null);
        hashMap.put("jobGroup", string);
        this.sendNotification("jobsResumed", hashMap);
    }

    @Override
    public void jobResumed(JobKey jobKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("jobName", jobKey.getName());
        hashMap.put("jobGroup", jobKey.getGroup());
        this.sendNotification("jobsResumed", hashMap);
    }

    @Override
    public void schedulerError(String string, SchedulerException schedulerException) {
        this.sendNotification("schedulerError", schedulerException.getMessage());
    }

    @Override
    public void schedulerStarted() {
        this.sendNotification("schedulerStarted");
    }

    @Override
    public void schedulerStarting() {
    }

    @Override
    public void schedulerInStandbyMode() {
        this.sendNotification("schedulerPaused");
    }

    @Override
    public void schedulerShutdown() {
        this.scheduler.removeInternalSchedulerListener(this);
        this.scheduler.removeInternalJobListener(this.getName());
        this.sendNotification("schedulerShutdown");
    }

    @Override
    public void schedulerShuttingdown() {
    }

    @Override
    public void triggerFinalized(Trigger trigger) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("triggerName", trigger.getKey().getName());
        hashMap.put("triggerGroup", trigger.getKey().getGroup());
        this.sendNotification("triggerFinalized", hashMap);
    }

    @Override
    public void triggersPaused(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("triggerName", null);
        hashMap.put("triggerGroup", string);
        this.sendNotification("triggersPaused", hashMap);
    }

    @Override
    public void triggerPaused(TriggerKey triggerKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (triggerKey != null) {
            hashMap.put("triggerName", triggerKey.getName());
            hashMap.put("triggerGroup", triggerKey.getGroup());
        }
        this.sendNotification("triggersPaused", hashMap);
    }

    @Override
    public void triggersResumed(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("triggerName", null);
        hashMap.put("triggerGroup", string);
        this.sendNotification("triggersResumed", hashMap);
    }

    @Override
    public void triggerResumed(TriggerKey triggerKey) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (triggerKey != null) {
            hashMap.put("triggerName", triggerKey.getName());
            hashMap.put("triggerGroup", triggerKey.getGroup());
        }
        this.sendNotification("triggersResumed", hashMap);
    }

    @Override
    public String getName() {
        return "QuartzSchedulerMBeanImpl.listener";
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
        try {
            this.sendNotification("jobExecutionVetoed", JobExecutionContextSupport.toCompositeData(jobExecutionContext));
        }
        catch (Exception exception) {
            throw new RuntimeException(this.newPlainException(exception));
        }
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        try {
            this.sendNotification("jobToBeExecuted", JobExecutionContextSupport.toCompositeData(jobExecutionContext));
        }
        catch (Exception exception) {
            throw new RuntimeException(this.newPlainException(exception));
        }
    }

    @Override
    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        try {
            this.sendNotification("jobWasExecuted", JobExecutionContextSupport.toCompositeData(jobExecutionContext));
        }
        catch (Exception exception) {
            throw new RuntimeException(this.newPlainException(exception));
        }
    }

    public void sendNotification(String string) {
        this.sendNotification(string, null, null);
    }

    public void sendNotification(String string, Object object) {
        this.sendNotification(string, object, null);
    }

    public void sendNotification(String string, Object object, String string2) {
        Notification notification = new Notification(string, this, this.sequenceNumber.incrementAndGet(), System.currentTimeMillis(), string2);
        if (object != null) {
            notification.setUserData(object);
        }
        this.emitter.sendNotification(notification);
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.emitter.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public synchronized boolean isSampledStatisticsEnabled() {
        return this.sampledStatisticsEnabled;
    }

    @Override
    public void setSampledStatisticsEnabled(boolean bl) {
        if (bl != this.sampledStatisticsEnabled) {
            this.sampledStatisticsEnabled = bl;
            if (bl) {
                this.sampledStatistics = new SampledStatisticsImpl(this.scheduler);
            } else {
                this.sampledStatistics.shutdown();
                this.sampledStatistics = NULL_SAMPLED_STATISTICS;
            }
            this.sendNotification("sampledStatisticsEnabled", bl);
        }
    }

    @Override
    public long getJobsCompletedMostRecentSample() {
        return this.sampledStatistics.getJobsCompletedMostRecentSample();
    }

    @Override
    public long getJobsExecutedMostRecentSample() {
        return this.sampledStatistics.getJobsExecutingMostRecentSample();
    }

    @Override
    public long getJobsScheduledMostRecentSample() {
        return this.sampledStatistics.getJobsScheduledMostRecentSample();
    }

    @Override
    public Map<String, Long> getPerformanceMetrics() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("JobsCompleted", this.getJobsCompletedMostRecentSample());
        hashMap.put("JobsExecuted", this.getJobsExecutedMostRecentSample());
        hashMap.put("JobsScheduled", this.getJobsScheduledMostRecentSample());
        return hashMap;
    }

    static {
        NULL_SAMPLED_STATISTICS = new NullSampledStatisticsImpl();
        String[] stringArray = new String[]{"schedulerStarted", "schedulerPaused", "schedulerShutdown"};
        String string = Notification.class.getName();
        String string2 = "QuartzScheduler JMX Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, string, "QuartzScheduler JMX Event")};
    }

    private class Emitter
    extends NotificationBroadcasterSupport {
        private Emitter() {
        }

        @Override
        public MBeanNotificationInfo[] getNotificationInfo() {
            return QuartzSchedulerMBeanImpl.this.getNotificationInfo();
        }
    }
}

