/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java.generics;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeFactory;
import org.hibernate.annotations.common.reflection.java.generics.TypeSwitch;
import org.hibernate.annotations.common.reflection.java.generics.TypeUtils;

class ApproximatingTypeEnvironment
implements TypeEnvironment {
    ApproximatingTypeEnvironment() {
    }

    public Type bind(Type type) {
        Type type2 = this.fineApproximation(type);
        assert (TypeUtils.isResolved(type2));
        return type2;
    }

    private Type fineApproximation(Type type) {
        return (Type)new TypeSwitch<Type>(){

            @Override
            public Type caseWildcardType(WildcardType wildcardType) {
                return wildcardType;
            }

            @Override
            public Type caseClass(Class clazz) {
                return clazz;
            }

            @Override
            public Type caseGenericArrayType(GenericArrayType genericArrayType) {
                if (TypeUtils.isResolved(genericArrayType)) {
                    return genericArrayType;
                }
                Type type = genericArrayType.getGenericComponentType();
                Type type2 = ApproximatingTypeEnvironment.this.bind(type);
                if (type2 instanceof Class) {
                    return Array.newInstance((Class)type2, 0).getClass();
                }
                return Object[].class;
            }

            @Override
            public Type caseParameterizedType(ParameterizedType parameterizedType) {
                if (TypeUtils.isResolved(parameterizedType)) {
                    return parameterizedType;
                }
                if (!TypeUtils.isCollection(parameterizedType)) {
                    return Object.class;
                }
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                Type[] typeArray2 = new Type[typeArray.length];
                for (int i = 0; i < typeArray.length; ++i) {
                    typeArray2[i] = ApproximatingTypeEnvironment.this.coarseApproximation(typeArray[i]);
                }
                return TypeFactory.createParameterizedType(ApproximatingTypeEnvironment.this.bind(parameterizedType.getRawType()), typeArray2, parameterizedType.getOwnerType());
            }

            @Override
            public Type defaultCase(Type type) {
                return ApproximatingTypeEnvironment.this.coarseApproximation(type);
            }
        }.doSwitch(type);
    }

    private Type coarseApproximation(Type type) {
        Type type2 = (Type)new TypeSwitch<Type>(){

            @Override
            public Type caseWildcardType(WildcardType wildcardType) {
                return this.approximateTo(wildcardType.getUpperBounds());
            }

            @Override
            public Type caseGenericArrayType(GenericArrayType genericArrayType) {
                if (TypeUtils.isResolved(genericArrayType)) {
                    return genericArrayType;
                }
                return Object[].class;
            }

            @Override
            public Type caseParameterizedType(ParameterizedType parameterizedType) {
                if (TypeUtils.isResolved(parameterizedType)) {
                    return parameterizedType;
                }
                return Object.class;
            }

            @Override
            public Type caseTypeVariable(TypeVariable typeVariable) {
                return this.approximateTo(typeVariable.getBounds());
            }

            private Type approximateTo(Type[] typeArray) {
                if (typeArray.length != 1) {
                    return Object.class;
                }
                return ApproximatingTypeEnvironment.this.coarseApproximation(typeArray[0]);
            }

            @Override
            public Type defaultCase(Type type) {
                return type;
            }
        }.doSwitch(type);
        assert (TypeUtils.isResolved(type2));
        return type2;
    }

    public String toString() {
        return "approximated_types";
    }
}

