/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.java.generics.TypeUtils;

public class ReflectionUtil {
    public static boolean isProperty(Method method, Type type, Filter filter) {
        return !(!ReflectionUtil.isPropertyType(type) || method.isSynthetic() || method.isBridge() || !filter.returnStatic() && Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is"));
    }

    public static boolean isProperty(Field field, Type type, Filter filter) {
        return !(!filter.returnStatic() && Modifier.isStatic(field.getModifiers()) || !filter.returnTransient() && Modifier.isTransient(field.getModifiers()) || field.isSynthetic() || !ReflectionUtil.isPropertyType(type));
    }

    private static boolean isPropertyType(Type type) {
        return !TypeUtils.isVoid(type);
    }
}

