/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.StatusCode;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.io.ConnectionState;
import org.eclipse.jetty.websocket.common.io.DisconnectCallback;
import org.eclipse.jetty.websocket.common.io.FrameFlusher;
import org.eclipse.jetty.websocket.common.io.ReadState;

public abstract class AbstractWebSocketConnection
extends AbstractConnection
implements LogicalConnection,
Connection.UpgradeTo,
Dumpable {
    private static final Logger LOG = Log.getLogger(AbstractWebSocketConnection.class);
    private static final AtomicLong ID_GEN = new AtomicLong(0L);
    private static final int MIN_BUFFER_SIZE = 28;
    private final ByteBufferPool bufferPool;
    private final Scheduler scheduler;
    private final Generator generator;
    private final Parser parser;
    private final WebSocketPolicy policy;
    private final ReadState readState = new ReadState();
    private final ConnectionState connectionState = new ConnectionState();
    private final FrameFlusher flusher;
    private final String id;
    private final LongAdder bytesIn = new LongAdder();
    private WebSocketSession session;
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
    private ByteBuffer initialBuffer;
    private Stats stats = new Stats();
    private CloseInfo fatalCloseInfo;

    public AbstractWebSocketConnection(EndPoint endPoint, Executor executor, Scheduler scheduler, WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool) {
        super(endPoint, executor);
        this.id = Long.toString(ID_GEN.incrementAndGet());
        this.policy = webSocketPolicy;
        this.bufferPool = byteBufferPool;
        this.generator = new Generator(webSocketPolicy, byteBufferPool);
        this.parser = new Parser(webSocketPolicy, byteBufferPool);
        this.scheduler = scheduler;
        this.flusher = new Flusher(byteBufferPool, this.generator, endPoint);
        this.setInputBufferSize(webSocketPolicy.getInputBufferSize());
        this.setMaxIdleTimeout(webSocketPolicy.getIdleTimeout());
    }

    @Override
    public Executor getExecutor() {
        return super.getExecutor();
    }

    @Override
    public void close(CloseInfo closeInfo, Callback callback) {
        if (this.connectionState.closing()) {
            boolean bl;
            boolean bl2 = bl = closeInfo.getStatusCode() == 1005 || StatusCode.isTransmittable(closeInfo.getStatusCode());
            if (bl) {
                CloseFrame closeFrame = closeInfo.asFrame();
                this.outgoingFrame(closeFrame, new CallbackBridge(callback), BatchMode.OFF);
                if (StatusCode.isFatal(closeInfo.getStatusCode())) {
                    this.fatalCloseInfo = closeInfo;
                }
            } else {
                this.disconnect();
            }
        } else if (callback != null) {
            callback.failed(new IllegalStateException("Local Close already called"));
        }
    }

    @Override
    public void close(Throwable throwable) {
        String string;
        int n;
        this.session.callApplicationOnError(throwable);
        int n2 = n = this.policy.getBehavior() == WebSocketBehavior.SERVER ? 1011 : 1006;
        if (throwable instanceof CloseException) {
            n = ((CloseException)throwable).getStatusCode();
        }
        if (StringUtil.isBlank(string = throwable.getMessage())) {
            string = throwable.getClass().getSimpleName();
        }
        CloseInfo closeInfo = new CloseInfo(n, string);
        this.session.callApplicationOnClose(closeInfo);
        this.close(closeInfo, new DisconnectCallback(this));
    }

    @Override
    public boolean canWriteWebSocketFrames() {
        return this.connectionState.canWriteWebSocketFrames();
    }

    @Override
    public boolean canReadWebSocketFrames() {
        return this.connectionState.canReadWebSocketFrames();
    }

    @Override
    public String toStateString() {
        return this.connectionState.toString();
    }

    @Override
    public boolean opening() {
        return this.connectionState.opening();
    }

    @Override
    public boolean opened() {
        if (this.connectionState.opened()) {
            if (BufferUtil.hasContent(this.initialBuffer)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parsing upgrade initial buffer ({} remaining)", this.initialBuffer.remaining());
                }
                this.parser.parse(this.initialBuffer);
                this.initialBuffer = null;
            }
            this.fillInterested();
            return true;
        }
        return false;
    }

    @Override
    public void remoteClose(CloseInfo closeInfo) {
        this.session.callApplicationOnClose(closeInfo);
        this.close(closeInfo, new DisconnectCallback(this));
    }

    @Override
    public void setSession(WebSocketSession webSocketSession) {
        this.session = webSocketSession;
    }

    @Override
    public boolean onIdleExpired() {
        return super.onIdleExpired();
    }

    @Override
    public void close() {
        this.close(new CloseInfo(), Callback.NOOP);
    }

    @Override
    public void disconnect() {
        if (this.connectionState.disconnected()) {
            Object object;
            if (this.connectionState.wasOpened()) {
                object = this.fatalCloseInfo;
                if (object == null) {
                    object = new CloseInfo(1006, "Disconnected");
                }
                this.session.callApplicationOnClose((CloseInfo)object);
            } else {
                this.session.callApplicationOnError(new WebSocketException("Shutdown"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} disconnect()", new Object[]{this.policy.getBehavior()});
            }
            this.flusher.terminate(new EOFException("Disconnected"));
            object = this.getEndPoint();
            object.shutdownOutput();
            object.close();
        }
    }

    @Override
    public void fillInterested() {
        this.stats.countFillInterestedEvents.incrementAndGet();
        super.fillInterested();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getIdleTimeout() {
        return this.getEndPoint().getIdleTimeout();
    }

    @Override
    public long getMaxIdleTimeout() {
        return this.getEndPoint().getIdleTimeout();
    }

    public Parser getParser() {
        return this.parser;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Deprecated
    public Stats getStats() {
        return this.stats;
    }

    @Override
    public boolean isOpen() {
        return this.getEndPoint().isOpen();
    }

    @Override
    public boolean isReading() {
        return this.readState.isReading();
    }

    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillable()", new Object[]{this.policy.getBehavior()});
        }
        this.stats.countOnFillableEvents.incrementAndGet();
        if (this.readState.getBuffer() != null) {
            throw new IllegalStateException();
        }
        ByteBuffer byteBuffer = this.bufferPool.acquire(this.getInputBufferSize(), true);
        this.onFillable(byteBuffer);
    }

    private void onFillable(ByteBuffer byteBuffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillable(ByteBuffer): {}", new Object[]{this.policy.getBehavior(), byteBuffer});
        }
        block11: while (true) {
            ReadState.Action action = this.readState.getAction(byteBuffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("ReadState Action: {}", new Object[]{action});
            }
            switch (action) {
                case PARSE: {
                    try {
                        this.parser.parseSingleFrame(byteBuffer);
                    }
                    catch (Throwable throwable) {
                        this.close(throwable);
                        this.readState.discard();
                    }
                    continue block11;
                }
                case FILL: {
                    try {
                        int n = this.getEndPoint().fill(byteBuffer);
                        if (n < 0) {
                            this.readState.eof();
                            break;
                        }
                        if (n == 0) {
                            this.bufferPool.release(byteBuffer);
                            this.fillInterested();
                            return;
                        }
                        this.bytesIn.add(n);
                        if (!LOG.isDebugEnabled()) continue block11;
                        LOG.debug("Filled {} bytes - {}", n, BufferUtil.toDetailString(byteBuffer));
                    }
                    catch (IOException iOException) {
                        this.close(iOException);
                        this.readState.eof();
                    }
                    continue block11;
                }
                case DISCARD: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Discarded buffer - {}", BufferUtil.toDetailString(byteBuffer));
                    }
                    BufferUtil.clear(byteBuffer);
                    break;
                }
                case SUSPEND: {
                    return;
                }
                case EOF: {
                    this.bufferPool.release(byteBuffer);
                    CloseInfo closeInfo = new CloseInfo(1001);
                    this.close(closeInfo, new DisconnectCallback(this));
                    return;
                }
                default: {
                    throw new IllegalStateException(action.name());
                }
            }
        }
    }

    @Override
    public void resume() {
        ByteBuffer byteBuffer = this.readState.resume();
        if (byteBuffer != null) {
            this.getExecutor().execute(() -> this.onFillable(byteBuffer));
        }
    }

    @Override
    public SuspendToken suspend() {
        this.readState.suspending();
        return this;
    }

    @Override
    protected void onFillInterestedFailed(Throwable throwable) {
        LOG.ignore(throwable);
        this.stats.countFillInterestedEvents.incrementAndGet();
        super.onFillInterestedFailed(throwable);
    }

    protected void setInitialBuffer(ByteBuffer byteBuffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set initial buffer - {}", BufferUtil.toDetailString(byteBuffer));
        }
        this.initialBuffer = byteBuffer;
    }

    @Override
    protected boolean onReadTimeout(Throwable throwable) {
        this.close(new CloseException(1001, throwable));
        return false;
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("outgoingFrame({}, {})", frame, writeCallback);
        }
        if (this.flusher.enqueue(frame, writeCallback, batchMode)) {
            this.flusher.iterate();
        }
    }

    public void setExtensions(List<ExtensionConfig> list) {
        this.extensions = list;
    }

    @Override
    public void setInputBufferSize(int n) {
        if (n < 28) {
            throw new IllegalArgumentException("Cannot have buffer size less than 28");
        }
        super.setInputBufferSize(n);
    }

    @Override
    public void setMaxIdleTimeout(long l) {
        this.getEndPoint().setIdleTimeout(l);
    }

    @Override
    public String dumpSelf() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        EndPoint endPoint = this.getEndPoint();
        String string2 = endPoint.toString();
        if (endPoint instanceof AbstractEndPoint) {
            string2 = ((AbstractEndPoint)endPoint).toEndPointString();
        }
        Dumpable.dumpObjects(appendable, string, this, string2, this.flusher, this.generator, this.parser);
    }

    @Override
    public String toConnectionString() {
        return String.format("%s@%x[s=%s,f=%s,g=%s,p=%s]", this.getClass().getSimpleName(), this.hashCode(), this.connectionState, this.flusher, this.generator, this.parser);
    }

    @Override
    public void onUpgradeTo(ByteBuffer byteBuffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onUpgradeTo({})", BufferUtil.toDetailString(byteBuffer));
        }
        this.setInitialBuffer(byteBuffer);
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incomingFrames) {
        this.getParser().setIncomingFramesHandler(incomingFrames);
    }

    @Override
    public long getMessagesIn() {
        return this.parser.getMessagesIn();
    }

    @Override
    public long getMessagesOut() {
        return this.flusher.getMessagesOut();
    }

    @Override
    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    @Override
    public long getBytesOut() {
        return this.flusher.getBytesOut();
    }

    @Deprecated
    public static class Stats {
        private AtomicLong countFillInterestedEvents = new AtomicLong(0L);
        private AtomicLong countOnFillableEvents = new AtomicLong(0L);
        private AtomicLong countFillableErrors = new AtomicLong(0L);

        public long getFillableErrorCount() {
            return this.countFillableErrors.get();
        }

        public long getFillInterestedCount() {
            return this.countFillInterestedEvents.get();
        }

        public long getOnFillableCount() {
            return this.countOnFillableEvents.get();
        }
    }

    private class Flusher
    extends FrameFlusher {
        private Flusher(ByteBufferPool byteBufferPool, Generator generator, EndPoint endPoint) {
            super(byteBufferPool, generator, endPoint, AbstractWebSocketConnection.this.getPolicy().getMaxBinaryMessageBufferSize(), 8);
        }

        @Override
        public void onCompleteFailure(Throwable throwable) {
            AbstractWebSocketConnection.this.close(throwable);
            super.onCompleteFailure(throwable);
        }
    }

    private static class CallbackBridge
    implements WriteCallback {
        private final Callback callback;

        public CallbackBridge(Callback callback) {
            this.callback = callback != null ? callback : Callback.NOOP;
        }

        @Override
        public void writeFailed(Throwable throwable) {
            this.callback.failed(throwable);
        }

        @Override
        public void writeSuccess() {
            this.callback.succeeded();
        }
    }
}

