/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverImpl;
import org.eclipse.jetty.websocket.common.events.JettyAnnotatedEventDriver;
import org.eclipse.jetty.websocket.common.events.JettyAnnotatedMetadata;
import org.eclipse.jetty.websocket.common.events.JettyAnnotatedScanner;

public class JettyAnnotatedImpl
implements EventDriverImpl {
    private ConcurrentHashMap<Class<?>, JettyAnnotatedMetadata> cache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventDriver create(Object object, WebSocketPolicy webSocketPolicy) {
        Class<?> clazz = object.getClass();
        JettyAnnotatedImpl jettyAnnotatedImpl = this;
        synchronized (jettyAnnotatedImpl) {
            JettyAnnotatedMetadata jettyAnnotatedMetadata = this.cache.get(clazz);
            if (jettyAnnotatedMetadata == null) {
                JettyAnnotatedScanner jettyAnnotatedScanner = new JettyAnnotatedScanner();
                jettyAnnotatedMetadata = jettyAnnotatedScanner.scan(clazz);
                this.cache.put(clazz, jettyAnnotatedMetadata);
            }
            return new JettyAnnotatedEventDriver(webSocketPolicy, object, jettyAnnotatedMetadata);
        }
    }

    @Override
    public String describeRule() {
        return "class is annotated with @" + WebSocket.class.getName();
    }

    @Override
    public boolean supports(Object object) {
        WebSocket webSocket = object.getClass().getAnnotation(WebSocket.class);
        return webSocket != null;
    }

    public String toString() {
        return String.format("%s [cache.count=%d]", this.getClass().getSimpleName(), this.cache.size());
    }
}

