/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.message.MessageAppender;

public abstract class AbstractEventDriver
extends AbstractLifeCycle
implements IncomingFrames,
EventDriver {
    private final Logger logger = Log.getLogger(this.getClass());
    protected final Logger targetLog;
    protected WebSocketPolicy policy;
    protected final Object websocket;
    protected WebSocketSession session;
    protected MessageAppender activeMessage;

    public AbstractEventDriver(WebSocketPolicy webSocketPolicy, Object object) {
        this.policy = webSocketPolicy;
        this.websocket = Objects.requireNonNull(object, "WebSocket endpoint may not be null");
        this.targetLog = Log.getLogger(object.getClass());
    }

    protected void appendMessage(ByteBuffer byteBuffer, boolean bl) throws IOException {
        this.activeMessage.appendFrame(byteBuffer, bl);
        if (bl) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    protected void dispatch(Runnable runnable) {
        this.session.dispatch(runnable);
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("incomingFrame({})", frame);
        }
        try {
            this.onFrame(frame);
            byte by = frame.getOpCode();
            switch (by) {
                case 8: {
                    boolean bl = true;
                    CloseFrame closeFrame = (CloseFrame)frame;
                    CloseInfo closeInfo = new CloseInfo(closeFrame, bl);
                    this.session.getConnection().remoteClose(closeInfo);
                    return;
                }
                case 9: {
                    ByteBuffer byteBuffer;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("PING: {}", BufferUtil.toDetailString(frame.getPayload()));
                    }
                    if (frame.hasPayload()) {
                        byteBuffer = ByteBuffer.allocate(frame.getPayload().remaining());
                        BufferUtil.put(frame.getPayload().slice(), byteBuffer);
                        BufferUtil.flipToFlush(byteBuffer, 0);
                    } else {
                        byteBuffer = ByteBuffer.allocate(0);
                    }
                    this.onPing(frame.getPayload());
                    this.session.getRemote().sendPong(byteBuffer);
                    break;
                }
                case 10: {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("PONG: {}", BufferUtil.toDetailString(frame.getPayload()));
                    }
                    this.onPong(frame.getPayload());
                    break;
                }
                case 2: {
                    this.onBinaryFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 1: {
                    this.onTextFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 0: {
                    this.onContinuationFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                default: {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Unhandled OpCode: {}", by);
                    }
                    break;
                }
            }
        }
        catch (Utf8Appendable.NotUtf8Exception notUtf8Exception) {
            this.session.close(new BadPayloadException(notUtf8Exception));
        }
        catch (Throwable throwable) {
            this.session.close(throwable);
        }
    }

    @Override
    public void onContinuationFrame(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (this.activeMessage == null) {
            throw new IOException("Out of order Continuation frame encountered");
        }
        this.appendMessage(byteBuffer, bl);
    }

    @Override
    public void onPong(ByteBuffer byteBuffer) {
    }

    @Override
    public void onPing(ByteBuffer byteBuffer) {
    }

    @Override
    public BatchMode getBatchMode() {
        return null;
    }

    @Override
    public void openSession(WebSocketSession webSocketSession) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("openSession({}) objectFactory={}", webSocketSession, webSocketSession.getContainerScope().getObjectFactory());
        }
        this.session = webSocketSession;
        this.session.getContainerScope().getObjectFactory().decorate(this.websocket);
        try {
            this.onConnect();
        }
        catch (Throwable throwable) {
            this.session.close(throwable);
        }
    }
}

