/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public final class WSURI {
    public static URI toHttp(URI uRI) throws URISyntaxException {
        Objects.requireNonNull(uRI, "Input URI must not be null");
        String string = uRI.getScheme();
        if ("http".equalsIgnoreCase(string) || "https".equalsIgnoreCase(string)) {
            return uRI;
        }
        if ("ws".equalsIgnoreCase(string)) {
            return new URI("http" + uRI.toString().substring(string.length()));
        }
        if ("wss".equalsIgnoreCase(string)) {
            return new URI("https" + uRI.toString().substring(string.length()));
        }
        throw new URISyntaxException(uRI.toString(), "Unrecognized WebSocket scheme");
    }

    public static URI toWebsocket(CharSequence charSequence) throws URISyntaxException {
        return WSURI.toWebsocket(new URI(charSequence.toString()));
    }

    public static URI toWebsocket(CharSequence charSequence, String string) throws URISyntaxException {
        if (string == null) {
            return WSURI.toWebsocket(new URI(charSequence.toString()));
        }
        return WSURI.toWebsocket(new URI(charSequence.toString() + '?' + string));
    }

    public static URI toWebsocket(URI uRI) throws URISyntaxException {
        Objects.requireNonNull(uRI, "Input URI must not be null");
        String string = uRI.getScheme();
        if ("ws".equalsIgnoreCase(string) || "wss".equalsIgnoreCase(string)) {
            return uRI;
        }
        if ("http".equalsIgnoreCase(string)) {
            return new URI("ws" + uRI.toString().substring(string.length()));
        }
        if ("https".equalsIgnoreCase(string)) {
            return new URI("wss" + uRI.toString().substring(string.length()));
        }
        throw new URISyntaxException(uRI.toString(), "Unrecognized HTTP scheme");
    }
}

