/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api;

import org.eclipse.jetty.websocket.api.MessageTooLargeException;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;

public class WebSocketPolicy {
    private static final int KB = 1024;
    private int maxTextMessageSize = 65536;
    private int maxTextMessageBufferSize = 32768;
    private int maxBinaryMessageSize = 65536;
    private int maxBinaryMessageBufferSize = 32768;
    private long asyncWriteTimeout = 60000L;
    private long idleTimeout = 300000L;
    private int inputBufferSize = 4096;
    private final WebSocketBehavior behavior;

    public static WebSocketPolicy newClientPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.CLIENT);
    }

    public static WebSocketPolicy newServerPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.SERVER);
    }

    public WebSocketPolicy(WebSocketBehavior webSocketBehavior) {
        this.behavior = webSocketBehavior;
    }

    private void assertLessThan(String string, long l, String string2, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException(String.format("%s [%d] must be less than %s [%d]", string, l, string2, l2));
        }
    }

    private void assertGreaterThan(String string, long l, long l2) {
        if (l < l2) {
            throw new IllegalArgumentException(String.format("%s [%d] must be a greater than or equal to " + l2, string, l));
        }
    }

    public void assertValidBinaryMessageSize(int n) {
        if (this.maxBinaryMessageSize > 0 && n > this.maxBinaryMessageSize) {
            throw new MessageTooLargeException("Binary message size [" + n + "] exceeds maximum size [" + this.maxBinaryMessageSize + "]");
        }
    }

    public void assertValidTextMessageSize(int n) {
        if (this.maxTextMessageSize > 0 && n > this.maxTextMessageSize) {
            throw new MessageTooLargeException("Text message size [" + n + "] exceeds maximum size [" + this.maxTextMessageSize + "]");
        }
    }

    public WebSocketPolicy clonePolicy() {
        WebSocketPolicy webSocketPolicy = new WebSocketPolicy(this.behavior);
        webSocketPolicy.idleTimeout = this.getIdleTimeout();
        webSocketPolicy.maxTextMessageSize = this.getMaxTextMessageSize();
        webSocketPolicy.maxTextMessageBufferSize = this.getMaxTextMessageBufferSize();
        webSocketPolicy.maxBinaryMessageSize = this.getMaxBinaryMessageSize();
        webSocketPolicy.maxBinaryMessageBufferSize = this.getMaxBinaryMessageBufferSize();
        webSocketPolicy.inputBufferSize = this.getInputBufferSize();
        webSocketPolicy.asyncWriteTimeout = this.getAsyncWriteTimeout();
        return webSocketPolicy;
    }

    @Deprecated
    public WebSocketPolicy clonePolicy(WebSocketBehavior webSocketBehavior) {
        return this.delegateAs(webSocketBehavior);
    }

    public WebSocketPolicy delegateAs(WebSocketBehavior webSocketBehavior) {
        if (webSocketBehavior == this.behavior) {
            return this;
        }
        return new Delegated(this, webSocketBehavior);
    }

    @Deprecated
    public long getAsyncWriteTimeout() {
        return this.asyncWriteTimeout;
    }

    public WebSocketBehavior getBehavior() {
        return this.behavior;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public int getMaxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    public int getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public int getMaxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    public void setAsyncWriteTimeout(long l) {
        this.assertLessThan("AsyncWriteTimeout", l, "IdleTimeout", this.idleTimeout);
        this.asyncWriteTimeout = l;
    }

    public void setIdleTimeout(long l) {
        this.assertGreaterThan("IdleTimeout", l, 0L);
        this.idleTimeout = l;
    }

    public void setInputBufferSize(int n) {
        this.assertGreaterThan("InputBufferSize", n, 1L);
        this.inputBufferSize = n;
    }

    public void setMaxBinaryMessageBufferSize(int n) {
        this.assertGreaterThan("MaxBinaryMessageBufferSize", n, 1L);
        this.maxBinaryMessageBufferSize = n;
    }

    public void setMaxBinaryMessageSize(int n) {
        this.assertGreaterThan("MaxBinaryMessageSize", n, -1L);
        this.maxBinaryMessageSize = n;
    }

    public void setMaxTextMessageBufferSize(int n) {
        this.assertGreaterThan("MaxTextMessageBufferSize", n, 1L);
        this.maxTextMessageBufferSize = n;
    }

    public void setMaxTextMessageSize(int n) {
        this.assertGreaterThan("MaxTextMessageSize", n, -1L);
        this.maxTextMessageSize = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("@").append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[behavior=").append((Object)this.getBehavior());
        stringBuilder.append(",maxTextMessageSize=").append(this.getMaxTextMessageSize());
        stringBuilder.append(",maxTextMessageBufferSize=").append(this.getMaxTextMessageBufferSize());
        stringBuilder.append(",maxBinaryMessageSize=").append(this.getMaxBinaryMessageSize());
        stringBuilder.append(",maxBinaryMessageBufferSize=").append(this.getMaxTextMessageBufferSize());
        stringBuilder.append(",asyncWriteTimeout=").append(this.getAsyncWriteTimeout());
        stringBuilder.append(",idleTimeout=").append(this.getIdleTimeout());
        stringBuilder.append(",inputBufferSize=").append(this.getInputBufferSize());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private class Delegated
    extends WebSocketPolicy {
        private final WebSocketPolicy delegated;

        public Delegated(WebSocketPolicy webSocketPolicy2, WebSocketBehavior webSocketBehavior) {
            super(webSocketBehavior);
            this.delegated = webSocketPolicy2;
        }

        @Override
        public void assertValidBinaryMessageSize(int n) {
            this.delegated.assertValidBinaryMessageSize(n);
        }

        @Override
        public void assertValidTextMessageSize(int n) {
            this.delegated.assertValidTextMessageSize(n);
        }

        @Override
        public WebSocketPolicy clonePolicy() {
            return this.delegated.clonePolicy();
        }

        @Override
        public WebSocketPolicy clonePolicy(WebSocketBehavior webSocketBehavior) {
            return this.delegated.clonePolicy(webSocketBehavior);
        }

        @Override
        public WebSocketPolicy delegateAs(WebSocketBehavior webSocketBehavior) {
            return this.delegated.delegateAs(webSocketBehavior);
        }

        @Override
        public long getAsyncWriteTimeout() {
            return this.delegated.getAsyncWriteTimeout();
        }

        @Override
        public long getIdleTimeout() {
            return this.delegated.getIdleTimeout();
        }

        @Override
        public int getInputBufferSize() {
            return this.delegated.getInputBufferSize();
        }

        @Override
        public int getMaxBinaryMessageBufferSize() {
            return this.delegated.getMaxBinaryMessageBufferSize();
        }

        @Override
        public int getMaxBinaryMessageSize() {
            return this.delegated.getMaxBinaryMessageSize();
        }

        @Override
        public int getMaxTextMessageBufferSize() {
            return this.delegated.getMaxTextMessageBufferSize();
        }

        @Override
        public int getMaxTextMessageSize() {
            return this.delegated.getMaxTextMessageSize();
        }

        @Override
        public void setAsyncWriteTimeout(long l) {
            this.delegated.setAsyncWriteTimeout(l);
        }

        @Override
        public void setIdleTimeout(long l) {
            this.delegated.setIdleTimeout(l);
        }

        @Override
        public void setInputBufferSize(int n) {
            this.delegated.setInputBufferSize(n);
        }

        @Override
        public void setMaxBinaryMessageBufferSize(int n) {
            this.delegated.setMaxBinaryMessageBufferSize(n);
        }

        @Override
        public void setMaxBinaryMessageSize(int n) {
            this.delegated.setMaxBinaryMessageSize(n);
        }

        @Override
        public void setMaxTextMessageBufferSize(int n) {
            this.delegated.setMaxTextMessageBufferSize(n);
        }

        @Override
        public void setMaxTextMessageSize(int n) {
            this.delegated.setMaxTextMessageSize(n);
        }
    }
}

