/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.AtomicBiInteger;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.ThreadPoolBudget;
import org.eclipse.jetty.util.thread.TryExecutor;

@ManagedObject(value="A pool for reserved threads")
public class ReservedThreadExecutor
extends AbstractLifeCycle
implements TryExecutor,
Dumpable {
    private static final Logger LOG = Log.getLogger(ReservedThreadExecutor.class);
    private static final long DEFAULT_IDLE_TIMEOUT = TimeUnit.MINUTES.toNanos(1L);
    private static final Runnable STOP = new Runnable(){

        @Override
        public void run() {
        }

        public String toString() {
            return "STOP";
        }
    };
    private final Executor _executor;
    private final int _capacity;
    private final Set<ReservedThread> _threads = ConcurrentHashMap.newKeySet();
    private final SynchronousQueue<Runnable> _queue = new SynchronousQueue(false);
    private final AtomicBiInteger _count = new AtomicBiInteger();
    private final AtomicLong _lastEmptyTime = new AtomicLong(System.nanoTime());
    private ThreadPoolBudget.Lease _lease;
    private long _idleTimeNanos = DEFAULT_IDLE_TIMEOUT;

    public ReservedThreadExecutor(Executor executor, int n) {
        this._executor = executor;
        this._capacity = ReservedThreadExecutor.reservedThreads(executor, n);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", this);
        }
    }

    private static int reservedThreads(Executor executor, int n) {
        if (n >= 0) {
            return n;
        }
        int n2 = ProcessorUtils.availableProcessors();
        if (executor instanceof ThreadPool.SizedThreadPool) {
            int n3 = ((ThreadPool.SizedThreadPool)executor).getMaxThreads();
            return Math.max(1, Math.min(n2, n3 / 10));
        }
        return n2;
    }

    public Executor getExecutor() {
        return this._executor;
    }

    @ManagedAttribute(value="max number of reserved threads", readonly=true)
    public int getCapacity() {
        return this._capacity;
    }

    @ManagedAttribute(value="available reserved threads", readonly=true)
    public int getAvailable() {
        return this._count.getLo();
    }

    @ManagedAttribute(value="pending reserved threads", readonly=true)
    public int getPending() {
        return this._count.getHi();
    }

    @ManagedAttribute(value="idle timeout in ms", readonly=true)
    public long getIdleTimeoutMs() {
        return TimeUnit.NANOSECONDS.toMillis(this._idleTimeNanos);
    }

    public void setIdleTimeout(long l, TimeUnit timeUnit) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._idleTimeNanos = l <= 0L || timeUnit == null ? DEFAULT_IDLE_TIMEOUT : timeUnit.toNanos(l);
    }

    @Override
    public void doStart() throws Exception {
        this._lease = ThreadPoolBudget.leaseFrom(this.getExecutor(), this, this._capacity);
        this._count.set(0, 0);
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        if (this._lease != null) {
            this._lease.close();
        }
        super.doStop();
        int n = this._count.getAndSetLo(-1);
        for (int i = 0; i < n; ++i) {
            Thread.yield();
            this._queue.offer(STOP);
        }
        this._threads.stream().filter(object -> ((ReservedThread)object).isReserved()).map(reservedThread -> ((ReservedThread)reservedThread)._thread).filter(Objects::nonNull).forEach(Thread::interrupt);
        this._threads.clear();
        this._count.getAndSetHi(0);
    }

    @Override
    public void execute(Runnable runnable) throws RejectedExecutionException {
        this._executor.execute(runnable);
    }

    @Override
    public boolean tryExecute(Runnable runnable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} tryExecute {}", this, runnable);
        }
        if (runnable == null) {
            return false;
        }
        boolean bl = this._queue.offer(runnable);
        int n = this._count.getLo();
        while (bl && n > 0 && !this._count.compareAndSetLo(n--, n)) {
            n = this._count.getLo();
        }
        if (n == 0 && runnable != STOP) {
            this.startReservedThread();
        }
        return bl;
    }

    private void startReservedThread() {
        int n;
        int n2;
        long l;
        do {
            l = this._count.get();
            n2 = AtomicBiInteger.getHi(l);
            n = AtomicBiInteger.getLo(l);
            if (n < 0 || n2 + n >= this._capacity) {
                return;
            }
            if (n != 0) continue;
            this._lastEmptyTime.set(System.nanoTime());
        } while (!this._count.compareAndSet(l, n2 + 1, n));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} startReservedThread p={}", this, n2 + 1);
        }
        try {
            ReservedThread reservedThread = new ReservedThread();
            this._threads.add(reservedThread);
            this._executor.execute(reservedThread);
        }
        catch (Throwable throwable) {
            this._count.add(-1, 0);
            LOG.ignore(throwable);
        }
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObjects(appendable, string, this, new DumpableCollection("threads", this._threads.stream().filter(object -> ((ReservedThread)object).isReserved()).collect(Collectors.toList())));
    }

    @Override
    public String toString() {
        return String.format("%s@%x{reserved=%d/%d,pending=%d}", this.getClass().getSimpleName(), this.hashCode(), this._count.getLo(), this._capacity, this._count.getHi());
    }

    static /* synthetic */ int access$600(ReservedThreadExecutor reservedThreadExecutor) {
        return reservedThreadExecutor._capacity;
    }

    static /* synthetic */ AtomicLong access$700(ReservedThreadExecutor reservedThreadExecutor) {
        return reservedThreadExecutor._lastEmptyTime;
    }

    static /* synthetic */ Set access$800(ReservedThreadExecutor reservedThreadExecutor) {
        return reservedThreadExecutor._threads;
    }

    private class ReservedThread
    implements Runnable {
        private volatile State _state = State.PENDING;
        private volatile Thread _thread;

        private ReservedThread() {
        }

        private boolean isReserved() {
            return this._state == State.RESERVED;
        }

        private Runnable reservedWait() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} waiting {}", this, ReservedThreadExecutor.this);
            }
            while (ReservedThreadExecutor.this._count.getLo() >= 0) {
                try {
                    Runnable runnable = (Runnable)ReservedThreadExecutor.this._queue.poll(ReservedThreadExecutor.this._idleTimeNanos, TimeUnit.NANOSECONDS);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} task={} {}", this, runnable, ReservedThreadExecutor.this);
                    }
                    if (runnable != null) {
                        return runnable;
                    }
                    int n = ReservedThreadExecutor.this._count.getLo();
                    while (n > 0 && !ReservedThreadExecutor.this._count.compareAndSetLo(n--, n)) {
                        n = ReservedThreadExecutor.this._count.getLo();
                    }
                    this._state = n >= 0 ? State.IDLE : State.STOPPED;
                    return STOP;
                }
                catch (InterruptedException interruptedException) {
                    LOG.ignore(interruptedException);
                }
            }
            this._state = State.STOPPED;
            return STOP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            this._thread = Thread.currentThread();
            try {
                while (true) lbl-1000:
                // 5 sources

                {
                    var1_1 = ReservedThreadExecutor.access$200(ReservedThreadExecutor.this).get();
                    var3_2 = AtomicBiInteger.getHi(var1_1) - (this._state == State.PENDING ? 1 : 0);
                    var4_3 = AtomicBiInteger.getLo(var1_1);
                    if (var4_3 < 0 || var4_3 >= ReservedThreadExecutor.access$600(ReservedThreadExecutor.this)) {
                        var5_4 = State.STOPPED;
                    } else {
                        var6_5 = System.nanoTime();
                        var8_8 = ReservedThreadExecutor.access$700(ReservedThreadExecutor.this).get();
                        if (var4_3 > 0 && ReservedThreadExecutor.access$300(ReservedThreadExecutor.this) < var6_5 - var8_8 && ReservedThreadExecutor.access$700(ReservedThreadExecutor.this).compareAndSet(var8_8, var6_5)) {
                            var5_4 = State.IDLE;
                        } else {
                            var5_4 = State.RESERVED;
                            ++var4_3;
                        }
                    }
                    if (!ReservedThreadExecutor.access$200(ReservedThreadExecutor.this).compareAndSet(var1_1, var3_2, var4_3)) continue;
                    if (ReservedThreadExecutor.access$100().isDebugEnabled()) {
                        ReservedThreadExecutor.access$100().debug("{} was={} next={} size={}+{} capacity={}", new Object[]{this, this._state, var5_4, var3_2, var4_3, ReservedThreadExecutor.access$600(ReservedThreadExecutor.this)});
                    }
                    this._state = var5_4;
                    if (var5_4 != State.RESERVED || (var6_6 = this.reservedWait()) == ReservedThreadExecutor.access$500()) ** break;
                    try {
                        this._state = State.RUNNING;
                        var6_6.run();
                    }
                    catch (Throwable var7_7) {
                        ReservedThreadExecutor.access$100().warn("Unable to run task", var7_7);
                    }
                    finally {
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                ** if (!ReservedThreadExecutor.access$100().isDebugEnabled()) goto lbl-1000
            }
            catch (Throwable var11_10) {
                if (ReservedThreadExecutor.access$100().isDebugEnabled()) {
                    ReservedThreadExecutor.access$100().debug("{} exited {}", new Object[]{this, ReservedThreadExecutor.this});
                }
                ReservedThreadExecutor.access$800(ReservedThreadExecutor.this).remove(this);
                this._thread = null;
                throw var11_10;
            }
lbl-1000:
            // 1 sources

            {
                ReservedThreadExecutor.access$100().debug("{} exited {}", new Object[]{this, ReservedThreadExecutor.this});
            }
lbl-1000:
            // 2 sources

            {
            }
            ReservedThreadExecutor.access$800(ReservedThreadExecutor.this).remove(this);
            this._thread = null;
        }

        public String toString() {
            return String.format("%s@%x{%s,thread=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state, this._thread});
        }
    }

    private static enum State {
        PENDING,
        RESERVED,
        RUNNING,
        IDLE,
        STOPPED;

    }
}

