/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.statistic;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

public class SampleStatistic {
    private final LongAccumulator _max = new LongAccumulator(Math::max, 0L);
    private final AtomicLong _total = new AtomicLong();
    private final AtomicLong _count = new AtomicLong();
    private final LongAdder _totalVariance100 = new LongAdder();

    public void reset() {
        this._max.reset();
        this._total.set(0L);
        this._count.set(0L);
        this._totalVariance100.reset();
    }

    public void record(long l) {
        long l2 = this._total.addAndGet(l);
        long l3 = this._count.incrementAndGet();
        if (l3 > 1L) {
            long l4 = l2 * 10L / l3;
            long l5 = l * 10L - l4;
            this._totalVariance100.add(l5 * l5);
        }
        this._max.accumulate(l);
    }

    @Deprecated
    public void set(long l) {
        this.record(l);
    }

    public long getMax() {
        return this._max.get();
    }

    public long getTotal() {
        return this._total.get();
    }

    public long getCount() {
        return this._count.get();
    }

    public double getMean() {
        long l = this.getCount();
        return l > 0L ? (double)this._total.get() / (double)this._count.get() : 0.0;
    }

    public double getVariance() {
        long l = this._totalVariance100.sum();
        long l2 = this.getCount();
        return l2 > 1L ? (double)l / 100.0 / (double)(l2 - 1L) : 0.0;
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public String toString() {
        return String.format("%s@%x{count=%d,mean=%d,total=%d,stddev=%f}", this.getClass().getSimpleName(), this.hashCode(), this.getCount(), this.getMax(), this.getTotal(), this.getStdDev());
    }
}

