/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.compression;

import java.util.zip.Deflater;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.compression.CompressionPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class DeflaterPool
extends CompressionPool<Deflater> {
    private final int compressionLevel;
    private final boolean nowrap;

    public DeflaterPool(int n, int n2, boolean bl) {
        super(n);
        this.compressionLevel = n2;
        this.nowrap = bl;
    }

    @Override
    protected Deflater newObject() {
        return new Deflater(this.compressionLevel, this.nowrap);
    }

    @Override
    protected void end(Deflater deflater) {
        deflater.end();
    }

    @Override
    protected void reset(Deflater deflater) {
        deflater.reset();
    }

    public static DeflaterPool ensurePool(Container container) {
        DeflaterPool deflaterPool = container.getBean(DeflaterPool.class);
        if (deflaterPool != null) {
            return deflaterPool;
        }
        int n = -1;
        ThreadPool.SizedThreadPool sizedThreadPool = container.getBean(ThreadPool.SizedThreadPool.class);
        if (sizedThreadPool != null) {
            n = sizedThreadPool.getMaxThreads();
        }
        deflaterPool = new DeflaterPool(n, -1, true);
        container.addBean(deflaterPool, true);
        return deflaterPool;
    }
}

