/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.AtomicBiInteger;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;

@ManagedObject
public class Pool<T>
implements AutoCloseable,
Dumpable {
    private static final Logger LOGGER = Log.getLogger(Pool.class);
    private final List<Entry> entries = new CopyOnWriteArrayList<Entry>();
    private final int maxEntries;
    private final StrategyType strategyType;
    private final Locker locker = new Locker();
    private final ThreadLocal<Entry> cache;
    private final AtomicInteger nextIndex;
    private volatile boolean closed;
    @Deprecated
    private volatile int maxUsage = -1;
    @Deprecated
    private volatile int maxMultiplex = -1;

    public Pool(StrategyType strategyType, int n) {
        this(strategyType, n, false);
    }

    public Pool(StrategyType strategyType, int n, boolean bl) {
        this.maxEntries = n;
        this.strategyType = Objects.requireNonNull(strategyType);
        this.cache = bl ? new ThreadLocal() : null;
        this.nextIndex = strategyType == StrategyType.ROUND_ROBIN ? new AtomicInteger() : null;
    }

    @ManagedAttribute(value="The number of reserved entries")
    public int getReservedCount() {
        return (int)this.entries.stream().filter(Entry::isReserved).count();
    }

    @ManagedAttribute(value="The number of idle entries")
    public int getIdleCount() {
        return (int)this.entries.stream().filter(Entry::isIdle).count();
    }

    @ManagedAttribute(value="The number of in-use entries")
    public int getInUseCount() {
        return (int)this.entries.stream().filter(Entry::isInUse).count();
    }

    @ManagedAttribute(value="The number of closed entries")
    public int getClosedCount() {
        return (int)this.entries.stream().filter(Entry::isClosed).count();
    }

    @ManagedAttribute(value="The maximum number of entries")
    public int getMaxEntries() {
        return this.maxEntries;
    }

    @ManagedAttribute(value="The default maximum multiplex count of entries")
    @Deprecated
    public int getMaxMultiplex() {
        return this.maxMultiplex == -1 ? 1 : this.maxMultiplex;
    }

    @Deprecated
    protected int getMaxMultiplex(T t) {
        return this.getMaxMultiplex();
    }

    @Deprecated
    public final void setMaxMultiplex(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Max multiplex must be >= 1");
        }
        try (Locker.Lock lock = this.locker.lock();){
            if (this.closed) {
                return;
            }
            if (this.entries.stream().anyMatch(MonoEntry.class::isInstance)) {
                throw new IllegalStateException("Pool entries do not support multiplexing");
            }
            this.maxMultiplex = n;
        }
    }

    @ManagedAttribute(value="The default maximum usage count of entries")
    @Deprecated
    public int getMaxUsageCount() {
        return this.maxUsage;
    }

    @Deprecated
    protected int getMaxUsageCount(T t) {
        return this.getMaxUsageCount();
    }

    @Deprecated
    public final void setMaxUsageCount(int n) {
        List<Closeable> list;
        if (n == 0) {
            throw new IllegalArgumentException("Max usage count must be != 0");
        }
        try (Locker.Lock lock = this.locker.lock();){
            if (this.closed) {
                return;
            }
            if (this.entries.stream().anyMatch(MonoEntry.class::isInstance)) {
                throw new IllegalStateException("Pool entries do not support max usage");
            }
            this.maxUsage = n;
            list = this.entries.stream().filter(entry -> entry.isIdleAndOverUsed() && this.remove((Entry)entry) && ((Entry)entry).pooled instanceof Closeable).map(entry -> (Closeable)((Entry)entry).pooled).collect(Collectors.toList());
        }
        list.forEach(IO::close);
    }

    @Deprecated
    public Entry reserve(int n) {
        try (Locker.Lock lock = this.locker.lock();){
            if (this.closed) {
                Entry entry = null;
                return entry;
            }
            int n2 = this.maxEntries - this.entries.size();
            if (n2 <= 0) {
                Entry entry = null;
                return entry;
            }
            if (n >= 0 && this.getReservedCount() * this.getMaxMultiplex() >= n) {
                Entry entry = null;
                return entry;
            }
            Entry entry = this.newEntry();
            this.entries.add(entry);
            Entry entry2 = entry;
            return entry2;
        }
    }

    public Entry reserve() {
        try (Locker.Lock lock = this.locker.lock();){
            if (this.closed) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} is closed, returning null reserved entry", this);
                }
                Entry entry = null;
                return entry;
            }
            int n = this.entries.size();
            if (n >= this.maxEntries) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} has no space: {} >= {}, returning null reserved entry", this, n, this.maxEntries);
                }
                Entry entry = null;
                return entry;
            }
            Entry entry = this.newEntry();
            this.entries.add(entry);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} returning new reserved entry {}", this, entry);
            }
            Entry entry2 = entry;
            return entry2;
        }
    }

    private Entry newEntry() {
        if (this.maxMultiplex >= 0 || this.maxUsage >= 0) {
            return new MultiEntry();
        }
        return new MonoEntry();
    }

    @Deprecated
    public Entry acquireAt(int n) {
        if (this.closed) {
            return null;
        }
        try {
            Entry entry = this.entries.get(n);
            if (entry.tryAcquire()) {
                return entry;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public Entry acquire() {
        Entry entry;
        if (this.closed) {
            return null;
        }
        int n = this.entries.size();
        if (n == 0) {
            return null;
        }
        if (this.cache != null && (entry = this.cache.get()) != null && entry.tryAcquire()) {
            return entry;
        }
        int n2 = this.startIndex(n);
        int n3 = n;
        while (n3-- > 0) {
            try {
                Entry entry2 = this.entries.get(n2);
                if (entry2 != null && entry2.tryAcquire()) {
                    return entry2;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                LOGGER.ignore(indexOutOfBoundsException);
                n = this.entries.size();
                if (n == 0) break;
            }
            n2 = (n2 + 1) % n;
        }
        return null;
    }

    private int startIndex(int n2) {
        switch (this.strategyType) {
            case FIRST: {
                return 0;
            }
            case RANDOM: {
                return ThreadLocalRandom.current().nextInt(n2);
            }
            case ROUND_ROBIN: {
                return this.nextIndex.getAndUpdate(n -> Math.max(0, n + 1)) % n2;
            }
            case THREAD_ID: {
                return (int)(Thread.currentThread().getId() % (long)n2);
            }
        }
        throw new IllegalArgumentException("Unknown strategy type: " + (Object)((Object)this.strategyType));
    }

    public Entry acquire(Function<Entry, T> function) {
        T t;
        Entry entry = this.acquire();
        if (entry != null) {
            return entry;
        }
        entry = this.reserve();
        if (entry == null) {
            return null;
        }
        try {
            t = function.apply(entry);
        }
        catch (Throwable throwable) {
            this.remove(entry);
            throw throwable;
        }
        if (t == null) {
            this.remove(entry);
            return null;
        }
        return entry.enable(t, true) ? entry : null;
    }

    public boolean release(Entry entry) {
        if (this.closed) {
            return false;
        }
        boolean bl = entry.tryRelease();
        if (bl && this.cache != null) {
            this.cache.set(entry);
        }
        return bl;
    }

    public boolean remove(Entry entry) {
        if (this.closed) {
            return false;
        }
        if (!entry.tryRemove()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Attempt to remove an object from the pool that is still in use: {}", entry);
            }
            return false;
        }
        boolean bl = this.entries.remove(entry);
        if (!bl && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Attempt to remove an object from the pool that does not exist: {}", entry);
        }
        return bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        ArrayList<Entry> arrayList;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing {}", this);
        }
        try (Locker.Lock lock = this.locker.lock();){
            this.closed = true;
            arrayList = new ArrayList<Entry>(this.entries);
            this.entries.clear();
        }
        for (Entry entry : arrayList) {
            boolean bl = entry.tryRemove();
            if (bl) {
                if (!(entry.pooled instanceof Closeable)) continue;
                IO.close((Closeable)entry.pooled);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Pooled object still in use: {}", entry);
        }
    }

    public int size() {
        return this.entries.size();
    }

    public Collection<Entry> values() {
        return Collections.unmodifiableCollection(this.entries);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObjects(appendable, string, this, new DumpableCollection("entries", this.entries));
    }

    public String toString() {
        return String.format("%s@%x[inUse=%d,size=%d,capacity=%d,closed=%b]", this.getClass().getSimpleName(), this.hashCode(), this.getInUseCount(), this.size(), this.getMaxEntries(), this.isClosed());
    }

    class MultiEntry
    extends Entry {
        private final AtomicBiInteger state;

        MultiEntry() {
            this.state = new AtomicBiInteger(Integer.MIN_VALUE, 0);
        }

        @Override
        void setUsageCount(int n) {
            this.state.getAndSetHi(n);
        }

        @Override
        protected boolean tryEnable(boolean bl) {
            int n = bl ? 1 : 0;
            return this.state.compareAndSet(Integer.MIN_VALUE, n, 0, n);
        }

        @Override
        boolean tryAcquire() {
            int n;
            int n2;
            int n3;
            long l;
            do {
                boolean bl;
                l = this.state.get();
                n2 = AtomicBiInteger.getHi(l);
                n = AtomicBiInteger.getLo(l);
                boolean bl2 = bl = n2 < 0;
                if (bl) {
                    return false;
                }
                Object t = this.getPooled();
                int n4 = Pool.this.getMaxUsageCount(t);
                int n5 = Pool.this.getMaxMultiplex(t);
                if (n5 > 0 && n >= n5) {
                    return false;
                }
                if (n4 <= 0 || n2 < n4) continue;
                return false;
            } while (!this.state.compareAndSet(l, n3 = n2 == Integer.MAX_VALUE ? Integer.MAX_VALUE : n2 + 1, n + 1));
            return true;
        }

        @Override
        boolean tryRelease() {
            int n;
            int n2;
            long l;
            do {
                boolean bl;
                boolean bl2 = bl = (n2 = AtomicBiInteger.getHi(l = this.state.get())) < 0;
                if (bl) {
                    return false;
                }
                n = AtomicBiInteger.getLo(l) - 1;
                if (n >= 0) continue;
                throw new IllegalStateException("Cannot release an already released entry");
            } while (!this.state.compareAndSet(l, n2, n));
            int n3 = Pool.this.getMaxUsageCount(this.getPooled());
            boolean bl = n3 > 0 && n2 >= n3;
            return !bl || n != 0;
        }

        @Override
        boolean tryRemove() {
            int n;
            int n2;
            long l;
            int n3;
            boolean bl;
            while (!(bl = this.state.compareAndSet(n3 = AtomicBiInteger.getHi(l = this.state.get()), -1, n2 = AtomicBiInteger.getLo(l), n = Math.max(n2 - 1, 0)))) {
            }
            return n == 0;
        }

        @Override
        public boolean isClosed() {
            return this.state.getHi() < 0;
        }

        @Override
        public boolean isReserved() {
            return this.state.getHi() == Integer.MIN_VALUE;
        }

        @Override
        public boolean isIdle() {
            long l = this.state.get();
            return AtomicBiInteger.getHi(l) >= 0 && AtomicBiInteger.getLo(l) == 0;
        }

        @Override
        public boolean isInUse() {
            long l = this.state.get();
            return AtomicBiInteger.getHi(l) >= 0 && AtomicBiInteger.getLo(l) > 0;
        }

        @Override
        public boolean isOverUsed() {
            int n = Pool.this.getMaxUsageCount();
            int n2 = this.state.getHi();
            return n > 0 && n2 >= n;
        }

        @Override
        boolean isIdleAndOverUsed() {
            int n = Pool.this.getMaxUsageCount();
            long l = this.state.get();
            int n2 = AtomicBiInteger.getHi(l);
            int n3 = AtomicBiInteger.getLo(l);
            return n > 0 && n2 >= n && n3 == 0;
        }

        @Override
        int getUsageCount() {
            return Math.max(this.state.getHi(), 0);
        }

        public String toString() {
            long l = this.state.get();
            int n = AtomicBiInteger.getHi(l);
            int n2 = AtomicBiInteger.getLo(l);
            String string = n < 0 ? (n == Integer.MIN_VALUE ? "PENDING" : "CLOSED") : (n2 == 0 ? "IDLE" : "ACTIVE");
            return String.format("%s@%x{%s,usage=%d,multiplex=%d,pooled=%s}", this.getClass().getSimpleName(), this.hashCode(), string, Math.max(n, 0), Math.max(n2, 0), this.getPooled());
        }
    }

    private class MonoEntry
    extends Entry {
        private final AtomicInteger state;

        private MonoEntry() {
            this.state = new AtomicInteger(Integer.MIN_VALUE);
        }

        @Override
        protected boolean tryEnable(boolean bl) {
            return this.state.compareAndSet(Integer.MIN_VALUE, bl ? 1 : 0);
        }

        @Override
        boolean tryAcquire() {
            int n;
            do {
                if ((n = this.state.get()) == 0) continue;
                return false;
            } while (!this.state.compareAndSet(n, 1));
            return true;
        }

        @Override
        boolean tryRelease() {
            int n;
            do {
                if ((n = this.state.get()) < 0) {
                    return false;
                }
                if (n != 0) continue;
                throw new IllegalStateException("Cannot release an already released entry");
            } while (!this.state.compareAndSet(n, 0));
            return true;
        }

        @Override
        boolean tryRemove() {
            this.state.set(-1);
            return true;
        }

        @Override
        public boolean isClosed() {
            return this.state.get() < 0;
        }

        @Override
        public boolean isReserved() {
            return this.state.get() == Integer.MIN_VALUE;
        }

        @Override
        public boolean isIdle() {
            return this.state.get() == 0;
        }

        @Override
        public boolean isInUse() {
            return this.state.get() == 1;
        }

        public String toString() {
            String string;
            switch (this.state.get()) {
                case -2147483648: {
                    string = "PENDING";
                    break;
                }
                case -1: {
                    string = "CLOSED";
                    break;
                }
                case 0: {
                    string = "IDLE";
                    break;
                }
                default: {
                    string = "ACTIVE";
                }
            }
            return String.format("%s@%x{%s,pooled=%s}", this.getClass().getSimpleName(), this.hashCode(), string, this.getPooled());
        }
    }

    public abstract class Entry {
        private T pooled;

        public boolean enable(T t, boolean bl) {
            Objects.requireNonNull(t);
            if (!this.isReserved()) {
                if (this.isClosed()) {
                    return false;
                }
                throw new IllegalStateException("Entry already enabled: " + this);
            }
            this.pooled = t;
            if (this.tryEnable(bl)) {
                return true;
            }
            this.pooled = null;
            if (this.isClosed()) {
                return false;
            }
            throw new IllegalStateException("Entry already enabled: " + this);
        }

        public T getPooled() {
            return this.pooled;
        }

        public boolean release() {
            return Pool.this.release(this);
        }

        public boolean remove() {
            return Pool.this.remove(this);
        }

        abstract boolean tryEnable(boolean var1);

        abstract boolean tryAcquire();

        abstract boolean tryRelease();

        abstract boolean tryRemove();

        public abstract boolean isClosed();

        public abstract boolean isReserved();

        public abstract boolean isIdle();

        public abstract boolean isInUse();

        @Deprecated
        public boolean isOverUsed() {
            return false;
        }

        boolean isIdleAndOverUsed() {
            return false;
        }

        int getUsageCount() {
            return 0;
        }

        void setUsageCount(int n) {
        }
    }

    public static enum StrategyType {
        FIRST,
        RANDOM,
        THREAD_ID,
        ROUND_ROBIN;

    }
}

