/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

public class MathUtils {
    private MathUtils() {
    }

    public static boolean sumOverflows(int n, int n2) {
        try {
            Math.addExact(n, n2);
            return false;
        }
        catch (ArithmeticException arithmeticException) {
            return true;
        }
    }

    public static long cappedAdd(long l, long l2) {
        try {
            return Math.addExact(l, l2);
        }
        catch (ArithmeticException arithmeticException) {
            return Long.MAX_VALUE;
        }
    }

    public static int cappedAdd(int n, int n2, int n3) {
        try {
            int n4 = Math.addExact(n, n2);
            return Math.min(n4, n3);
        }
        catch (ArithmeticException arithmeticException) {
            return n3;
        }
    }
}

