/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

public class JavaVersion {
    public static final String JAVA_TARGET_PLATFORM = "org.eclipse.jetty.javaTargetPlatform";
    public static final JavaVersion VERSION = JavaVersion.parse(System.getProperty("java.version"));
    private final String version;
    private final int platform;
    private final int major;
    private final int minor;
    private final int micro;

    public static JavaVersion parse(String string) {
        String[] stringArray = string.split("[^0-9]");
        int n = Math.min(stringArray.length, 3);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                n = i - 1;
                break;
            }
        }
        return new JavaVersion(string, nArray[0] >= 9 || n == 1 ? nArray[0] : nArray[1], nArray[0], n > 1 ? nArray[1] : 0, n > 2 ? nArray[2] : 0);
    }

    private JavaVersion(String string, int n, int n2, int n3, int n4) {
        this.version = string;
        this.platform = n;
        this.major = n2;
        this.minor = n3;
        this.micro = n4;
    }

    public String getVersion() {
        return this.version;
    }

    public int getPlatform() {
        return this.platform;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    @Deprecated
    public int getUpdate() {
        return 0;
    }

    @Deprecated
    public String getSuffix() {
        return null;
    }

    public String toString() {
        return this.version;
    }
}

