/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.util.MemoryUtils;

public class BlockingArrayQueue<E>
extends AbstractList<E>
implements BlockingQueue<E> {
    private static final int HEAD_OFFSET = MemoryUtils.getIntegersPerCacheLine() - 1;
    private static final int TAIL_OFFSET = HEAD_OFFSET + MemoryUtils.getIntegersPerCacheLine();
    public static final int DEFAULT_CAPACITY = 128;
    public static final int DEFAULT_GROWTH = 64;
    private final int _maxCapacity;
    private final int _growCapacity;
    private final int[] _indexes = new int[TAIL_OFFSET + 1];
    private final Lock _tailLock = new ReentrantLock();
    private final AtomicInteger _size = new AtomicInteger();
    private final Lock _headLock = new ReentrantLock();
    private final Condition _notEmpty = this._headLock.newCondition();
    private Object[] _elements;

    public BlockingArrayQueue() {
        this._elements = new Object[128];
        this._growCapacity = 64;
        this._maxCapacity = Integer.MAX_VALUE;
    }

    public BlockingArrayQueue(int n) {
        this._elements = new Object[n];
        this._growCapacity = -1;
        this._maxCapacity = n;
    }

    public BlockingArrayQueue(int n, int n2) {
        this._elements = new Object[n];
        this._growCapacity = n2;
        this._maxCapacity = Integer.MAX_VALUE;
    }

    public BlockingArrayQueue(int n, int n2, int n3) {
        if (n > n3) {
            throw new IllegalArgumentException();
        }
        this._elements = new Object[n];
        this._growCapacity = n2;
        this._maxCapacity = n3;
    }

    @Override
    public void clear() {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
                this._indexes[BlockingArrayQueue.TAIL_OFFSET] = 0;
                this._size.set(0);
            }
            finally {
                this._headLock.unlock();
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    @Override
    public int size() {
        return this._size.get();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public E poll() {
        if (this._size.get() == 0) {
            return null;
        }
        Object object = null;
        this._headLock.lock();
        try {
            if (this._size.get() > 0) {
                int n = this._indexes[HEAD_OFFSET];
                object = this._elements[n];
                this._elements[n] = null;
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = (n + 1) % this._elements.length;
                if (this._size.decrementAndGet() > 0) {
                    this._notEmpty.signal();
                }
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)object;
    }

    @Override
    public E peek() {
        if (this._size.get() == 0) {
            return null;
        }
        Object object = null;
        this._headLock.lock();
        try {
            if (this._size.get() > 0) {
                object = this._elements[this._indexes[HEAD_OFFSET]];
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)object;
    }

    @Override
    public E remove() {
        E e = this.poll();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E element() {
        E e = this.peek();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Objects.requireNonNull(e);
        boolean bl = false;
        this._tailLock.lock();
        try {
            int n = this._size.get();
            if (n >= this._maxCapacity) {
                boolean bl2 = false;
                return bl2;
            }
            if (n == this._elements.length) {
                this._headLock.lock();
                try {
                    if (!this.grow()) {
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                finally {
                    this._headLock.unlock();
                }
            }
            int n2 = this._indexes[TAIL_OFFSET];
            this._elements[n2] = e;
            this._indexes[BlockingArrayQueue.TAIL_OFFSET] = (n2 + 1) % this._elements.length;
            bl = this._size.getAndIncrement() == 0;
        }
        finally {
            this._tailLock.unlock();
        }
        if (bl) {
            this._headLock.lock();
            try {
                this._notEmpty.signal();
            }
            finally {
                this._headLock.unlock();
            }
        }
        return true;
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException();
    }

    @Override
    public void put(E e) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public E take() throws InterruptedException {
        Object object = null;
        this._headLock.lockInterruptibly();
        try {
            try {
                while (this._size.get() == 0) {
                    this._notEmpty.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this._notEmpty.signal();
                throw interruptedException;
            }
            int n = this._indexes[HEAD_OFFSET];
            object = this._elements[n];
            this._elements[n] = null;
            this._indexes[BlockingArrayQueue.HEAD_OFFSET] = (n + 1) % this._elements.length;
            if (this._size.decrementAndGet() > 0) {
                this._notEmpty.signal();
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        Object object = null;
        this._headLock.lockInterruptibly();
        try {
            while (this._size.get() == 0) {
                if (l2 <= 0L) {
                    E e = null;
                    return e;
                }
                try {
                    l2 = this._notEmpty.awaitNanos(l2);
                }
                catch (InterruptedException interruptedException) {
                    this._notEmpty.signal();
                    throw interruptedException;
                }
            }
            int n = this._indexes[HEAD_OFFSET];
            object = this._elements[n];
            this._elements[n] = null;
            this._indexes[BlockingArrayQueue.HEAD_OFFSET] = (n + 1) % this._elements.length;
            if (this._size.decrementAndGet() > 0) {
                this._notEmpty.signal();
            }
        }
        finally {
            this._headLock.unlock();
        }
        return (E)object;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean remove(Object var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int remainingCapacity() {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int n = this.getCapacity() - this.size();
                this._headLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        int n2;
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                if (this._size.get() == 0) {
                    int n3 = 0;
                    return n3;
                }
                int n4 = this._indexes[HEAD_OFFSET];
                int n5 = this._indexes[TAIL_OFFSET];
                int n6 = this._elements.length;
                int n7 = n4;
                for (n2 = 0; n2 < n && (n7 != n5 || n2 <= 0); ++n2) {
                    collection.add(this._elements[n7]);
                    if (++n7 != n6) continue;
                    n7 = 0;
                }
                if (n7 == n5) {
                    this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
                    this._indexes[BlockingArrayQueue.TAIL_OFFSET] = 0;
                    this._size.set(0);
                } else {
                    this._indexes[BlockingArrayQueue.HEAD_OFFSET] = n7;
                    this._size.addAndGet(-n2);
                }
            }
            finally {
                this._headLock.unlock();
            }
        }
        finally {
            this._tailLock.unlock();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int n) {
        this._tailLock.lock();
        try {
            Object object;
            this._headLock.lock();
            try {
                if (n < 0 || n >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + n + "<=" + this._size + ")");
                }
                int n2 = this._indexes[HEAD_OFFSET] + n;
                int n3 = this._elements.length;
                if (n2 >= n3) {
                    n2 -= n3;
                }
                object = this._elements[n2];
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return (E)object;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int n, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int n2 = this._size.get();
                if (n < 0 || n > n2) {
                    throw new IndexOutOfBoundsException("!(0<" + n + "<=" + this._size + ")");
                }
                if (n == n2) {
                    this.add(e);
                } else {
                    if (this._indexes[TAIL_OFFSET] == this._indexes[HEAD_OFFSET] && !this.grow()) {
                        throw new IllegalStateException("full");
                    }
                    int n3 = this._indexes[HEAD_OFFSET] + n;
                    int n4 = this._elements.length;
                    if (n3 >= n4) {
                        n3 -= n4;
                    }
                    this._size.incrementAndGet();
                    int n5 = this._indexes[TAIL_OFFSET];
                    this._indexes[BlockingArrayQueue.TAIL_OFFSET] = n5 = (n5 + 1) % n4;
                    if (n3 < n5) {
                        System.arraycopy(this._elements, n3, this._elements, n3 + 1, n5 - n3);
                        this._elements[n3] = e;
                    } else {
                        if (n5 > 0) {
                            System.arraycopy(this._elements, 0, this._elements, 1, n5);
                            this._elements[0] = this._elements[n4 - 1];
                        }
                        System.arraycopy(this._elements, n3, this._elements, n3 + 1, n4 - n3 - 1);
                        this._elements[n3] = e;
                    }
                }
            }
            finally {
                this._headLock.unlock();
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int n, E e) {
        Objects.requireNonNull(e);
        this._tailLock.lock();
        try {
            Object object;
            this._headLock.lock();
            try {
                if (n < 0 || n >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + n + "<=" + this._size + ")");
                }
                int n2 = this._indexes[HEAD_OFFSET] + n;
                int n3 = this._elements.length;
                if (n2 >= n3) {
                    n2 -= n3;
                }
                Object object2 = this._elements[n2];
                this._elements[n2] = e;
                object = object2;
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return (E)object;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int n) {
        this._tailLock.lock();
        try {
            Object object;
            this._headLock.lock();
            try {
                if (n < 0 || n >= this._size.get()) {
                    throw new IndexOutOfBoundsException("!(0<" + n + "<=" + this._size + ")");
                }
                int n2 = this._indexes[HEAD_OFFSET] + n;
                int n3 = this._elements.length;
                if (n2 >= n3) {
                    n2 -= n3;
                }
                Object object2 = this._elements[n2];
                int n4 = this._indexes[TAIL_OFFSET];
                if (n2 < n4) {
                    System.arraycopy(this._elements, n2 + 1, this._elements, n2, n4 - n2);
                    int n5 = TAIL_OFFSET;
                    this._indexes[n5] = this._indexes[n5] - 1;
                } else {
                    System.arraycopy(this._elements, n2 + 1, this._elements, n2, n3 - n2 - 1);
                    this._elements[n3 - 1] = this._elements[0];
                    if (n4 > 0) {
                        System.arraycopy(this._elements, 1, this._elements, 0, n4);
                        int n6 = TAIL_OFFSET;
                        this._indexes[n6] = this._indexes[n6] - 1;
                    } else {
                        this._indexes[BlockingArrayQueue.TAIL_OFFSET] = n3 - 1;
                    }
                    this._elements[this._indexes[BlockingArrayQueue.TAIL_OFFSET]] = null;
                }
                this._size.decrementAndGet();
                object = object2;
                this._headLock.unlock();
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
            return (E)object;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<E> listIterator(int n) {
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                Object[] objectArray = new Object[this.size()];
                if (this.size() > 0) {
                    int n2 = this._indexes[HEAD_OFFSET];
                    int n3 = this._indexes[TAIL_OFFSET];
                    if (n2 < n3) {
                        System.arraycopy(this._elements, n2, objectArray, 0, n3 - n2);
                    } else {
                        int n4 = this._elements.length - n2;
                        System.arraycopy(this._elements, n2, objectArray, 0, n4);
                        System.arraycopy(this._elements, 0, objectArray, n4, n3);
                    }
                }
                Itr itr = new Itr(objectArray, n);
                this._headLock.unlock();
                return itr;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    public int getCapacity() {
        this._tailLock.lock();
        try {
            int n = this._elements.length;
            return n;
        }
        finally {
            this._tailLock.unlock();
        }
    }

    public int getMaxCapacity() {
        return this._maxCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean grow() {
        if (this._growCapacity <= 0) {
            return false;
        }
        this._tailLock.lock();
        try {
            this._headLock.lock();
            try {
                int n;
                int n2 = this._indexes[HEAD_OFFSET];
                int n3 = this._indexes[TAIL_OFFSET];
                int n4 = this._elements.length;
                Object[] objectArray = new Object[n4 + this._growCapacity];
                if (n2 < n3) {
                    n = n3 - n2;
                    System.arraycopy(this._elements, n2, objectArray, 0, n);
                } else if (n2 > n3 || this._size.get() > 0) {
                    n = n4 + n3 - n2;
                    int bl = n4 - n2;
                    System.arraycopy(this._elements, n2, objectArray, 0, bl);
                    System.arraycopy(this._elements, 0, objectArray, bl, n3);
                } else {
                    n = 0;
                }
                this._elements = objectArray;
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
                this._indexes[BlockingArrayQueue.TAIL_OFFSET] = n;
                boolean bl = true;
                this._headLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this._headLock.unlock();
                throw throwable;
            }
        }
        finally {
            this._tailLock.unlock();
        }
    }

    private class Itr
    implements ListIterator<E> {
        private final Object[] _elements;
        private int _cursor;

        public Itr(Object[] objectArray, int n) {
            this._elements = objectArray;
            this._cursor = n;
        }

        @Override
        public boolean hasNext() {
            return this._cursor < this._elements.length;
        }

        @Override
        public E next() {
            return this._elements[this._cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this._cursor > 0;
        }

        @Override
        public E previous() {
            return this._elements[--this._cursor];
        }

        @Override
        public int nextIndex() {
            return this._cursor + 1;
        }

        @Override
        public int previousIndex() {
            return this._cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

