/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayUtil
implements Cloneable,
Serializable {
    public static <T> T[] removeFromArray(T[] TArray, Object object) {
        if (object == null || TArray == null) {
            return TArray;
        }
        int n = TArray.length;
        while (n-- > 0) {
            if (!object.equals(TArray[n])) continue;
            Class<?> clazz = TArray == null ? object.getClass() : TArray.getClass().getComponentType();
            Object[] objectArray = (Object[])Array.newInstance(clazz, Array.getLength(TArray) - 1);
            if (n > 0) {
                System.arraycopy(TArray, 0, objectArray, 0, n);
            }
            if (n + 1 < TArray.length) {
                System.arraycopy(TArray, n + 1, objectArray, n, TArray.length - (n + 1));
            }
            return objectArray;
        }
        return TArray;
    }

    public static <T> T[] add(T[] TArray, T[] TArray2) {
        if (TArray == null || TArray.length == 0) {
            return TArray2;
        }
        if (TArray2 == null || TArray2.length == 0) {
            return TArray;
        }
        T[] TArray3 = Arrays.copyOf(TArray, TArray.length + TArray2.length);
        System.arraycopy(TArray2, 0, TArray3, TArray.length, TArray2.length);
        return TArray3;
    }

    public static <T> T[] addToArray(T[] TArray, T t, Class<?> clazz) {
        if (TArray == null) {
            if (clazz == null && t != null) {
                clazz = t.getClass();
            }
            Object[] objectArray = (Object[])Array.newInstance(clazz, 1);
            objectArray[0] = t;
            return objectArray;
        }
        T[] TArray2 = Arrays.copyOf(TArray, TArray.length + 1);
        TArray2[TArray.length] = t;
        return TArray2;
    }

    public static <T> T[] prependToArray(T t, T[] TArray, Class<?> clazz) {
        if (TArray == null) {
            if (clazz == null && t != null) {
                clazz = t.getClass();
            }
            Object[] objectArray = (Object[])Array.newInstance(clazz, 1);
            objectArray[0] = t;
            return objectArray;
        }
        Class<?> clazz2 = TArray.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz2, Array.getLength(TArray) + 1);
        System.arraycopy(TArray, 0, objectArray, 1, TArray.length);
        objectArray[0] = t;
        return objectArray;
    }

    public static <E> List<E> asMutableList(E[] EArray) {
        if (EArray == null || EArray.length == 0) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(EArray));
    }

    public static <T> T[] removeNulls(T[] TArray) {
        for (T t : TArray) {
            if (t != null) continue;
            ArrayList<T> arrayList = new ArrayList<T>();
            for (T t2 : TArray) {
                if (t2 == null) continue;
                arrayList.add(t2);
            }
            return arrayList.toArray(Arrays.copyOf(TArray, arrayList.size()));
        }
        return TArray;
    }
}

