/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToIntFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class SslConnection
extends AbstractConnection
implements Connection.UpgradeTo {
    private static final Logger LOG = Log.getLogger(SslConnection.class);
    private static final String TLS_1_3 = "TLSv1.3";
    private final AtomicReference<HandshakeState> _handshake = new AtomicReference<HandshakeState>(HandshakeState.INITIAL);
    private final List<SslHandshakeListener> handshakeListeners = new ArrayList<SslHandshakeListener>();
    private final AtomicLong _bytesIn = new AtomicLong();
    private final AtomicLong _bytesOut = new AtomicLong();
    private final ByteBufferPool _bufferPool;
    private final SSLEngine _sslEngine;
    private final DecryptedEndPoint _decryptedEndPoint;
    private ByteBuffer _decryptedInput;
    private ByteBuffer _encryptedInput;
    private ByteBuffer _encryptedOutput;
    private final boolean _encryptedDirectBuffers;
    private final boolean _decryptedDirectBuffers;
    private boolean _renegotiationAllowed;
    private int _renegotiationLimit = -1;
    private boolean _closedOutbound;
    private boolean _requireCloseMessage;
    private FlushState _flushState = FlushState.IDLE;
    private FillState _fillState = FillState.IDLE;
    private boolean _underflown;
    private final Runnable _runFillable = new RunnableTask("runFillable"){

        @Override
        public void run() {
            SslConnection.this._decryptedEndPoint.getFillInterest().fillable();
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return SslConnection.this._decryptedEndPoint.getFillInterest().getCallbackInvocationType();
        }
    };
    private final Callback _sslReadCallback = new Callback(){

        @Override
        public void succeeded() {
            SslConnection.this.onFillable();
        }

        @Override
        public void failed(Throwable throwable) {
            SslConnection.this.onFillInterestedFailed(throwable);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return SslConnection.this.getDecryptedEndPoint().getFillInterest().getCallbackInvocationType();
        }

        public String toString() {
            return String.format("SSLC.NBReadCB@%x{%s}", SslConnection.this.hashCode(), SslConnection.this);
        }
    };

    public SslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine sSLEngine) {
        this(byteBufferPool, executor, endPoint, sSLEngine, false, false);
    }

    public SslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine sSLEngine, boolean bl, boolean bl2) {
        super(endPoint, executor);
        this._bufferPool = byteBufferPool;
        this._sslEngine = sSLEngine;
        this._decryptedEndPoint = this.newDecryptedEndPoint();
        this._encryptedDirectBuffers = bl;
        this._decryptedDirectBuffers = bl2;
    }

    @Override
    public long getBytesIn() {
        return this._bytesIn.get();
    }

    @Override
    public long getBytesOut() {
        return this._bytesOut.get();
    }

    public void addHandshakeListener(SslHandshakeListener sslHandshakeListener) {
        this.handshakeListeners.add(sslHandshakeListener);
    }

    public boolean removeHandshakeListener(SslHandshakeListener sslHandshakeListener) {
        return this.handshakeListeners.remove(sslHandshakeListener);
    }

    protected DecryptedEndPoint newDecryptedEndPoint() {
        return new DecryptedEndPoint();
    }

    public SSLEngine getSSLEngine() {
        return this._sslEngine;
    }

    public DecryptedEndPoint getDecryptedEndPoint() {
        return this._decryptedEndPoint;
    }

    public boolean isRenegotiationAllowed() {
        return this._renegotiationAllowed;
    }

    public void setRenegotiationAllowed(boolean bl) {
        this._renegotiationAllowed = bl;
    }

    public int getRenegotiationLimit() {
        return this._renegotiationLimit;
    }

    public void setRenegotiationLimit(int n) {
        this._renegotiationLimit = n;
    }

    @Deprecated
    public boolean isAllowMissingCloseMessage() {
        return !this.isRequireCloseMessage();
    }

    @Deprecated
    public void setAllowMissingCloseMessage(boolean bl) {
        this.setRequireCloseMessage(!bl);
    }

    public boolean isRequireCloseMessage() {
        return this._requireCloseMessage;
    }

    public void setRequireCloseMessage(boolean bl) {
        this._requireCloseMessage = bl;
    }

    private boolean isHandshakeInitial() {
        return this._handshake.get() == HandshakeState.INITIAL;
    }

    private boolean isHandshakeSucceeded() {
        return this._handshake.get() == HandshakeState.SUCCEEDED;
    }

    private boolean isHandshakeComplete() {
        HandshakeState handshakeState = this._handshake.get();
        return handshakeState == HandshakeState.SUCCEEDED || handshakeState == HandshakeState.FAILED;
    }

    private int getApplicationBufferSize() {
        return this.getBufferSize(SSLSession::getApplicationBufferSize);
    }

    private int getPacketBufferSize() {
        return this.getBufferSize(SSLSession::getPacketBufferSize);
    }

    private int getBufferSize(ToIntFunction<SSLSession> toIntFunction) {
        SSLSession sSLSession = this._sslEngine.getHandshakeSession();
        SSLSession sSLSession2 = this._sslEngine.getSession();
        int n = toIntFunction.applyAsInt(sSLSession2);
        if (sSLSession == null || sSLSession == sSLSession2) {
            return n;
        }
        int n2 = toIntFunction.applyAsInt(sSLSession);
        return Math.max(n2, n);
    }

    private void acquireEncryptedInput() {
        if (this._encryptedInput == null) {
            this._encryptedInput = this._bufferPool.acquire(this.getPacketBufferSize(), this._encryptedDirectBuffers);
        }
    }

    private void acquireEncryptedOutput() {
        if (this._encryptedOutput == null) {
            this._encryptedOutput = this._bufferPool.acquire(this.getPacketBufferSize(), this._encryptedDirectBuffers);
        }
    }

    @Override
    public void onUpgradeTo(ByteBuffer byteBuffer) {
        this.acquireEncryptedInput();
        BufferUtil.append(this._encryptedInput, byteBuffer);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.getDecryptedEndPoint().getConnection().onOpen();
    }

    @Override
    public void onClose() {
        this._decryptedEndPoint.getConnection().onClose();
        super.onClose();
    }

    @Override
    public void close() {
        this.getDecryptedEndPoint().getConnection().close();
    }

    @Override
    public boolean onIdleExpired() {
        return this.getDecryptedEndPoint().getConnection().onIdleExpired();
    }

    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">c.onFillable {}", this);
        }
        if (this._decryptedEndPoint.isInputShutdown()) {
            this._decryptedEndPoint.close();
        }
        this._decryptedEndPoint.onFillable();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<c.onFillable {}", this);
        }
    }

    @Override
    public void onFillInterestedFailed(Throwable throwable) {
        this._decryptedEndPoint.onFillableFail(throwable == null ? new IOException() : throwable);
    }

    protected SSLEngineResult wrap(SSLEngine sSLEngine, ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) throws SSLException {
        return sSLEngine.wrap(byteBufferArray, byteBuffer);
    }

    protected SSLEngineResult unwrap(SSLEngine sSLEngine, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        return sSLEngine.unwrap(byteBuffer, byteBuffer2);
    }

    @Override
    public String toConnectionString() {
        ByteBuffer byteBuffer = this._encryptedInput;
        int n = byteBuffer == null ? -1 : byteBuffer.remaining();
        byteBuffer = this._encryptedOutput;
        int n2 = byteBuffer == null ? -1 : byteBuffer.remaining();
        byteBuffer = this._decryptedInput;
        int n3 = byteBuffer == null ? -1 : byteBuffer.remaining();
        Connection connection = this._decryptedEndPoint.getConnection();
        return String.format("%s@%x{%s,eio=%d/%d,di=%d,fill=%s,flush=%s}~>%s=>%s", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._sslEngine.getHandshakeStatus(), n, n2, n3, this._fillState, this._flushState, this._decryptedEndPoint.toEndPointString(), connection instanceof AbstractConnection ? ((AbstractConnection)connection).toConnectionString() : connection});
    }

    private void releaseEncryptedInputBuffer() {
        if (this._encryptedInput != null && !this._encryptedInput.hasRemaining()) {
            this._bufferPool.release(this._encryptedInput);
            this._encryptedInput = null;
        }
    }

    protected void releaseDecryptedInputBuffer() {
        if (this._decryptedInput != null && !this._decryptedInput.hasRemaining()) {
            this._bufferPool.release(this._decryptedInput);
            this._decryptedInput = null;
        }
    }

    private void releaseEncryptedOutputBuffer() {
        if (!Thread.holdsLock(this._decryptedEndPoint)) {
            throw new IllegalStateException();
        }
        if (this._encryptedOutput != null && !this._encryptedOutput.hasRemaining()) {
            this._bufferPool.release(this._encryptedOutput);
            this._encryptedOutput = null;
        }
    }

    protected int networkFill(ByteBuffer byteBuffer) throws IOException {
        return this.getEndPoint().fill(byteBuffer);
    }

    protected boolean networkFlush(ByteBuffer byteBuffer) throws IOException {
        return this.getEndPoint().flush(byteBuffer);
    }

    static /* synthetic */ void access$800(SslConnection sslConnection) {
        sslConnection.acquireEncryptedInput();
    }

    static /* synthetic */ ByteBuffer access$602(SslConnection sslConnection, ByteBuffer byteBuffer) {
        sslConnection._decryptedInput = byteBuffer;
        return sslConnection._decryptedInput;
    }

    static /* synthetic */ boolean access$900(SslConnection sslConnection) {
        return sslConnection._decryptedDirectBuffers;
    }

    static /* synthetic */ ByteBufferPool access$1000(SslConnection sslConnection) {
        return sslConnection._bufferPool;
    }

    static /* synthetic */ AtomicLong access$1200(SslConnection sslConnection) {
        return sslConnection._bytesIn;
    }

    static /* synthetic */ boolean access$1300(SslConnection sslConnection) {
        return sslConnection.isHandshakeInitial();
    }

    static /* synthetic */ boolean access$1602(SslConnection sslConnection, boolean bl) {
        sslConnection._underflown = bl;
        return sslConnection._underflown;
    }

    static /* synthetic */ Executor access$1700(SslConnection sslConnection) {
        return sslConnection.getExecutor();
    }

    static /* synthetic */ void access$1800(SslConnection sslConnection) {
        sslConnection.releaseEncryptedInputBuffer();
    }

    static /* synthetic */ Executor access$1900(SslConnection sslConnection) {
        return sslConnection.getExecutor();
    }

    static /* synthetic */ AtomicLong access$2500(SslConnection sslConnection) {
        return sslConnection._bytesOut;
    }

    static /* synthetic */ int access$2600(SslConnection sslConnection) {
        return sslConnection.getPacketBufferSize();
    }

    static /* synthetic */ void access$2700(SslConnection sslConnection) {
        sslConnection.acquireEncryptedOutput();
    }

    public class DecryptedEndPoint
    extends AbstractEndPoint {
        private final Callback _incompleteWriteCallback;
        private Throwable _failure;

        public DecryptedEndPoint() {
            super(null);
            this._incompleteWriteCallback = new IncompleteWriteCallback();
            super.setIdleTimeout(-1L);
        }

        @Override
        public long getIdleTimeout() {
            return SslConnection.this.getEndPoint().getIdleTimeout();
        }

        @Override
        public void setIdleTimeout(long l) {
            SslConnection.this.getEndPoint().setIdleTimeout(l);
        }

        @Override
        public boolean isOpen() {
            return SslConnection.this.getEndPoint().isOpen();
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return SslConnection.this.getEndPoint().getLocalAddress();
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return SslConnection.this.getEndPoint().getRemoteAddress();
        }

        @Override
        public WriteFlusher getWriteFlusher() {
            return super.getWriteFlusher();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onFillable() {
            block10: {
                try {
                    boolean bl;
                    DecryptedEndPoint decryptedEndPoint = SslConnection.this._decryptedEndPoint;
                    synchronized (decryptedEndPoint) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("onFillable {}", SslConnection.this);
                        }
                        SslConnection.this._fillState = FillState.IDLE;
                        bl = SslConnection.this._flushState == FlushState.WAIT_FOR_FILL;
                    }
                    this.getFillInterest().fillable();
                    if (!bl) break block10;
                    decryptedEndPoint = SslConnection.this._decryptedEndPoint;
                    synchronized (decryptedEndPoint) {
                        bl = SslConnection.this._flushState == FlushState.WAIT_FOR_FILL;
                    }
                    if (bl) {
                        this.fill(BufferUtil.EMPTY_BUFFER);
                    }
                }
                catch (Throwable throwable) {
                    this.close(throwable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onFillableFail(Throwable throwable) {
            boolean bl = false;
            DecryptedEndPoint decryptedEndPoint = SslConnection.this._decryptedEndPoint;
            synchronized (decryptedEndPoint) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onFillableFail {}", SslConnection.this, throwable);
                }
                SslConnection.this._fillState = FillState.IDLE;
                if (SslConnection.this._flushState == FlushState.WAIT_FOR_FILL) {
                    SslConnection.this._flushState = FlushState.IDLE;
                    bl = true;
                }
            }
            this.getFillInterest().onFail(throwable);
            if (bl && !this.getWriteFlusher().onFail(throwable)) {
                this.close(throwable);
            }
        }

        @Override
        public void setConnection(Connection connection) {
            if (connection instanceof AbstractConnection) {
                AbstractConnection abstractConnection = (AbstractConnection)connection;
                int n = SslConnection.this.getApplicationBufferSize();
                if (abstractConnection.getInputBufferSize() < n) {
                    abstractConnection.setInputBufferSize(n);
                }
            }
            super.setConnection(connection);
        }

        public SslConnection getSslConnection() {
            return SslConnection.this;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int fill(ByteBuffer var1_1) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 26[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void needsFillInterest() {
            try {
                boolean bl;
                ByteBuffer byteBuffer = null;
                boolean bl2 = false;
                DecryptedEndPoint decryptedEndPoint = SslConnection.this._decryptedEndPoint;
                synchronized (decryptedEndPoint) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(">needFillInterest s={}/{} uf={} ei={} di={} {}", new Object[]{SslConnection.this._flushState, SslConnection.this._fillState, SslConnection.this._underflown, BufferUtil.toDetailString(SslConnection.this._encryptedInput), BufferUtil.toDetailString(SslConnection.this._decryptedInput), SslConnection.this});
                    }
                    if (SslConnection.this._fillState != FillState.IDLE) {
                        return;
                    }
                    bl = BufferUtil.hasContent(SslConnection.this._decryptedInput) || BufferUtil.hasContent(SslConnection.this._encryptedInput) && !SslConnection.this._underflown;
                    SSLEngineResult.HandshakeStatus handshakeStatus = SslConnection.this._sslEngine.getHandshakeStatus();
                    switch (handshakeStatus) {
                        case NEED_TASK: {
                            bl = true;
                            break;
                        }
                        case NEED_UNWRAP: 
                        case NOT_HANDSHAKING: {
                            if (bl) break;
                            bl2 = true;
                            SslConnection.this._fillState = FillState.INTERESTED;
                            if (SslConnection.this._flushState != FlushState.IDLE || !BufferUtil.hasContent(SslConnection.this._encryptedOutput)) break;
                            SslConnection.this._flushState = FlushState.WRITING;
                            byteBuffer = SslConnection.this._encryptedOutput;
                            break;
                        }
                        case NEED_WRAP: {
                            if (bl) break;
                            SslConnection.this._fillState = FillState.WAIT_FOR_FLUSH;
                            if (SslConnection.this._flushState != FlushState.IDLE) break;
                            SslConnection.this._flushState = FlushState.WRITING;
                            byteBuffer = BufferUtil.hasContent(SslConnection.this._encryptedOutput) ? SslConnection.this._encryptedOutput : BufferUtil.EMPTY_BUFFER;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected HandshakeStatus " + (Object)((Object)handshakeStatus));
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<needFillInterest s={}/{} f={} i={} w={}", new Object[]{SslConnection.this._flushState, SslConnection.this._fillState, bl, bl2, BufferUtil.toDetailString(byteBuffer)});
                    }
                }
                if (byteBuffer != null) {
                    SslConnection.this.getEndPoint().write(this._incompleteWriteCallback, byteBuffer);
                } else if (bl) {
                    SslConnection.this.getExecutor().execute(SslConnection.this._runFillable);
                } else if (bl2) {
                    this.ensureFillInterested();
                }
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SslConnection.this.toString(), throwable);
                }
                this.close(throwable);
                throw throwable;
            }
        }

        private void handshakeSucceeded() throws SSLException {
            if (SslConnection.this._handshake.compareAndSet(HandshakeState.HANDSHAKE, HandshakeState.SUCCEEDED)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("handshake succeeded {} {} {}/{}", SslConnection.this, SslConnection.this._sslEngine.getUseClientMode() ? "client" : "resumed server", SslConnection.this._sslEngine.getSession().getProtocol(), SslConnection.this._sslEngine.getSession().getCipherSuite());
                }
                this.notifyHandshakeSucceeded(SslConnection.this._sslEngine);
            } else if (SslConnection.this.isHandshakeSucceeded() && SslConnection.this._renegotiationLimit > 0) {
                SslConnection.this._renegotiationLimit--;
            }
        }

        private Throwable handshakeFailed(Throwable throwable) {
            if (SslConnection.this._handshake.compareAndSet(HandshakeState.HANDSHAKE, HandshakeState.FAILED)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("handshake failed {} {}", SslConnection.this, throwable);
                }
                if (!(throwable instanceof SSLHandshakeException)) {
                    throwable = new SSLHandshakeException(throwable.getMessage()).initCause(throwable);
                }
                this.notifyHandshakeFailed(SslConnection.this._sslEngine, throwable);
            }
            return throwable;
        }

        private void terminateInput() {
            try {
                SslConnection.this._sslEngine.closeInbound();
            }
            catch (Throwable throwable) {
                LOG.ignore(throwable);
            }
        }

        private Throwable closeInbound() throws SSLException {
            SSLEngineResult.HandshakeStatus handshakeStatus = SslConnection.this._sslEngine.getHandshakeStatus();
            try {
                SslConnection.this._sslEngine.closeInbound();
                return null;
            }
            catch (SSLException sSLException) {
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && SslConnection.this.isRequireCloseMessage()) {
                    throw sSLException;
                }
                LOG.ignore(sSLException);
                return sSLException;
            }
            catch (Throwable throwable) {
                LOG.ignore(throwable);
                return throwable;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean flush(ByteBuffer ... var1_1) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onIncompleteFlush() {
            try {
                boolean bl = false;
                ByteBuffer byteBuffer = null;
                DecryptedEndPoint decryptedEndPoint = SslConnection.this._decryptedEndPoint;
                synchronized (decryptedEndPoint) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(">onIncompleteFlush {} {}", SslConnection.this, BufferUtil.toDetailString(SslConnection.this._encryptedOutput));
                    }
                    if (SslConnection.this._flushState != FlushState.IDLE) {
                        return;
                    }
                    block11: while (true) {
                        SSLEngineResult.HandshakeStatus handshakeStatus = SslConnection.this._sslEngine.getHandshakeStatus();
                        switch (handshakeStatus) {
                            case NOT_HANDSHAKING: 
                            case NEED_TASK: 
                            case NEED_WRAP: {
                                byteBuffer = BufferUtil.hasContent(SslConnection.this._encryptedOutput) ? SslConnection.this._encryptedOutput : BufferUtil.EMPTY_BUFFER;
                                SslConnection.this._flushState = FlushState.WRITING;
                                break block11;
                            }
                            case NEED_UNWRAP: {
                                if (BufferUtil.hasContent(SslConnection.this._encryptedOutput)) {
                                    byteBuffer = SslConnection.this._encryptedOutput;
                                    SslConnection.this._flushState = FlushState.WRITING;
                                    break block11;
                                }
                                if (SslConnection.this._fillState != FillState.IDLE) {
                                    SslConnection.this._flushState = FlushState.WAIT_FOR_FILL;
                                    break block11;
                                }
                                try {
                                    int n = this.fill(BufferUtil.EMPTY_BUFFER);
                                    if (SslConnection.this._sslEngine.getHandshakeStatus() != handshakeStatus) continue block11;
                                    if (n < 0) {
                                        throw new IOException("Broken pipe");
                                    }
                                }
                                catch (IOException iOException) {
                                    LOG.debug(iOException);
                                    this.close(iOException);
                                    byteBuffer = BufferUtil.EMPTY_BUFFER;
                                    SslConnection.this._flushState = FlushState.WRITING;
                                    break block11;
                                }
                                bl = true;
                                SslConnection.this._fillState = FillState.INTERESTED;
                                SslConnection.this._flushState = FlushState.WAIT_FOR_FILL;
                                break block11;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected HandshakeStatus " + (Object)((Object)handshakeStatus));
                            }
                        }
                        break;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<onIncompleteFlush s={}/{} fi={} w={}", new Object[]{SslConnection.this._flushState, SslConnection.this._fillState, bl, BufferUtil.toDetailString(byteBuffer)});
                    }
                }
                if (byteBuffer != null) {
                    SslConnection.this.getEndPoint().write(this._incompleteWriteCallback, byteBuffer);
                } else if (bl) {
                    this.ensureFillInterested();
                }
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(SslConnection.this.toString(), throwable);
                }
                this.close(throwable);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doShutdownOutput() {
            EndPoint endPoint = SslConnection.this.getEndPoint();
            try {
                boolean bl;
                boolean bl2 = false;
                Object object = SslConnection.this._decryptedEndPoint;
                synchronized (object) {
                    boolean bl3 = endPoint.isInputShutdown();
                    boolean bl4 = endPoint.isOutputShutdown();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("shutdownOutput: {} oshut={}, ishut={}", SslConnection.this, bl4, bl3);
                    }
                    this.closeOutbound();
                    if (!SslConnection.this._closedOutbound) {
                        SslConnection.this._closedOutbound = true;
                        bl2 = !bl4;
                    }
                    bl = bl3;
                }
                if (bl2 && !this.flush(BufferUtil.EMPTY_BUFFER) && !bl) {
                    object = null;
                    DecryptedEndPoint decryptedEndPoint = SslConnection.this._decryptedEndPoint;
                    synchronized (decryptedEndPoint) {
                        if (BufferUtil.hasContent(SslConnection.this._encryptedOutput)) {
                            object = SslConnection.this._encryptedOutput;
                            SslConnection.this._flushState = FlushState.WRITING;
                        }
                    }
                    if (object != null) {
                        endPoint.write(Callback.from(() -> {
                            DecryptedEndPoint decryptedEndPoint = SslConnection.this._decryptedEndPoint;
                            synchronized (decryptedEndPoint) {
                                SslConnection.this._flushState = FlushState.IDLE;
                                SslConnection.this.releaseEncryptedOutputBuffer();
                            }
                        }, throwable -> endPoint.close()), new ByteBuffer[]{object});
                    }
                }
                if (bl) {
                    endPoint.close();
                } else {
                    this.ensureFillInterested();
                }
            }
            catch (Throwable throwable2) {
                LOG.ignore(throwable2);
                endPoint.close();
            }
        }

        private void closeOutbound() {
            block2: {
                try {
                    SslConnection.this._sslEngine.closeOutbound();
                }
                catch (Throwable throwable) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug(throwable);
                }
            }
        }

        private void ensureFillInterested() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ensureFillInterested {}", SslConnection.this);
            }
            SslConnection.this.tryFillInterested(SslConnection.this._sslReadCallback);
        }

        @Override
        public boolean isOutputShutdown() {
            return this.isOutboundDone() || SslConnection.this.getEndPoint().isOutputShutdown();
        }

        private boolean isOutboundDone() {
            try {
                return SslConnection.this._sslEngine.isOutboundDone();
            }
            catch (Throwable throwable) {
                LOG.ignore(throwable);
                return true;
            }
        }

        @Override
        public void doClose() {
            this.doShutdownOutput();
            SslConnection.this.getEndPoint().close();
            super.doClose();
        }

        @Override
        public Object getTransport() {
            return SslConnection.this.getEndPoint();
        }

        @Override
        public boolean isInputShutdown() {
            return BufferUtil.isEmpty(SslConnection.this._decryptedInput) && (SslConnection.this.getEndPoint().isInputShutdown() || this.isInboundDone());
        }

        private boolean isInboundDone() {
            try {
                return SslConnection.this._sslEngine.isInboundDone();
            }
            catch (Throwable throwable) {
                LOG.ignore(throwable);
                return true;
            }
        }

        private void notifyHandshakeSucceeded(SSLEngine sSLEngine) throws SSLException {
            SslHandshakeListener.Event event = null;
            for (SslHandshakeListener sslHandshakeListener : SslConnection.this.handshakeListeners) {
                if (event == null) {
                    event = new SslHandshakeListener.Event(sSLEngine);
                }
                try {
                    sslHandshakeListener.handshakeSucceeded(event);
                }
                catch (SSLException sSLException) {
                    throw sSLException;
                }
                catch (Throwable throwable) {
                    LOG.info("Exception while notifying listener " + sslHandshakeListener, throwable);
                }
            }
        }

        private void notifyHandshakeFailed(SSLEngine sSLEngine, Throwable throwable) {
            SslHandshakeListener.Event event = null;
            for (SslHandshakeListener sslHandshakeListener : SslConnection.this.handshakeListeners) {
                if (event == null) {
                    event = new SslHandshakeListener.Event(sSLEngine);
                }
                try {
                    sslHandshakeListener.handshakeFailed(event, throwable);
                }
                catch (Throwable throwable2) {
                    LOG.info("Exception while notifying listener " + sslHandshakeListener, throwable2);
                }
            }
        }

        private boolean isRenegotiating() {
            if (!SslConnection.this.isHandshakeComplete()) {
                return false;
            }
            if (this.isTLS13()) {
                return false;
            }
            return SslConnection.this._sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }

        private boolean allowRenegotiate() {
            if (!SslConnection.this.isRenegotiationAllowed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Renegotiation denied {}", SslConnection.this);
                }
                this.terminateInput();
                return false;
            }
            if (SslConnection.this.getRenegotiationLimit() == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Renegotiation limit exceeded {}", SslConnection.this);
                }
                this.terminateInput();
                return false;
            }
            return true;
        }

        private boolean isTLS13() {
            String string = SslConnection.this._sslEngine.getSession().getProtocol();
            return SslConnection.TLS_1_3.equals(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Throwable handleException(Throwable throwable, String string) {
            DecryptedEndPoint decryptedEndPoint = SslConnection.this._decryptedEndPoint;
            synchronized (decryptedEndPoint) {
                if (this._failure == null) {
                    this._failure = throwable;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this + " stored " + string + " exception", throwable);
                    }
                } else if (throwable != this._failure) {
                    this._failure.addSuppressed(throwable);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this + " suppressed " + string + " exception", throwable);
                    }
                }
                return this._failure;
            }
        }

        private void rethrow(Throwable throwable) throws IOException {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable);
        }

        @Override
        public String toString() {
            return super.toEndPointString();
        }

        private /* synthetic */ void lambda$fill$1() {
            SslConnection.this._decryptedEndPoint.getWriteFlusher().completeWrite();
        }

        private /* synthetic */ void lambda$fill$0(Throwable throwable) {
            SslConnection.this._decryptedEndPoint.getWriteFlusher().onFail(throwable);
        }

        private final class IncompleteWriteCallback
        implements Callback,
        Invocable {
            private IncompleteWriteCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void succeeded() {
                boolean bl;
                boolean bl2;
                DecryptedEndPoint decryptedEndPoint = SslConnection.this._decryptedEndPoint;
                synchronized (decryptedEndPoint) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("IncompleteWriteCB succeeded {}", SslConnection.this);
                    }
                    SslConnection.this.releaseEncryptedOutputBuffer();
                    SslConnection.this._flushState = FlushState.IDLE;
                    bl2 = SslConnection.this._fillState == FillState.INTERESTED;
                    boolean bl3 = bl = SslConnection.this._fillState == FillState.WAIT_FOR_FLUSH;
                    if (bl) {
                        SslConnection.this._fillState = FillState.IDLE;
                    }
                }
                if (bl2) {
                    DecryptedEndPoint.this.ensureFillInterested();
                } else if (bl) {
                    SslConnection.this._decryptedEndPoint.getFillInterest().fillable();
                }
                SslConnection.this._decryptedEndPoint.getWriteFlusher().completeWrite();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable throwable) {
                boolean bl;
                DecryptedEndPoint decryptedEndPoint = SslConnection.this._decryptedEndPoint;
                synchronized (decryptedEndPoint) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("IncompleteWriteCB failed {}", SslConnection.this, throwable);
                    }
                    BufferUtil.clear(SslConnection.this._encryptedOutput);
                    SslConnection.this.releaseEncryptedOutputBuffer();
                    SslConnection.this._flushState = FlushState.IDLE;
                    boolean bl2 = bl = SslConnection.this._fillState == FillState.WAIT_FOR_FLUSH || SslConnection.this._fillState == FillState.INTERESTED;
                    if (bl) {
                        SslConnection.this._fillState = FillState.IDLE;
                    }
                }
                SslConnection.this.getExecutor().execute(() -> {
                    if (bl) {
                        SslConnection.this._decryptedEndPoint.getFillInterest().onFail(throwable);
                    }
                    SslConnection.this._decryptedEndPoint.getWriteFlusher().onFail(throwable);
                });
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return SslConnection.this._decryptedEndPoint.getWriteFlusher().getCallbackInvocationType();
            }

            public String toString() {
                return String.format("SSL@%h.DEP.writeCallback", SslConnection.this);
            }
        }
    }

    private abstract class RunnableTask
    implements Runnable,
    Invocable {
        private final String _operation;

        protected RunnableTask(String string) {
            this._operation = string;
        }

        public String toString() {
            return String.format("SSL:%s:%s:%s", new Object[]{SslConnection.this, this._operation, this.getInvocationType()});
        }
    }

    private static enum FlushState {
        IDLE,
        WRITING,
        WAIT_FOR_FILL;

    }

    private static enum FillState {
        IDLE,
        INTERESTED,
        WAIT_FOR_FLUSH;

    }

    private static enum HandshakeState {
        INITIAL,
        HANDSHAKE,
        SUCCEEDED,
        FAILED;

    }
}

