/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntConsumer;
import org.eclipse.jetty.util.BufferUtil;

public interface ByteBufferPool {
    public ByteBuffer acquire(int var1, boolean var2);

    public void release(ByteBuffer var1);

    default public void remove(ByteBuffer byteBuffer) {
    }

    default public ByteBuffer newByteBuffer(int n, boolean bl) {
        return bl ? BufferUtil.allocateDirect(n) : BufferUtil.allocate(n);
    }

    public static class Bucket {
        private final Queue<ByteBuffer> _queue = new ConcurrentLinkedQueue<ByteBuffer>();
        private final ByteBufferPool _pool;
        private final int _capacity;
        private final int _maxSize;
        private final AtomicInteger _size;
        private final AtomicLong _lastUpdate = new AtomicLong(System.nanoTime());
        private final IntConsumer _memoryFunction;

        @Deprecated
        public Bucket(ByteBufferPool byteBufferPool, int n2, int n3) {
            this(byteBufferPool, n2, n3, n -> {});
        }

        public Bucket(ByteBufferPool byteBufferPool, int n, int n2, IntConsumer intConsumer) {
            this._pool = byteBufferPool;
            this._capacity = n;
            this._maxSize = n2;
            this._size = n2 > 0 ? new AtomicInteger() : null;
            this._memoryFunction = Objects.requireNonNull(intConsumer);
        }

        public ByteBuffer acquire() {
            ByteBuffer byteBuffer = this._queue.poll();
            if (byteBuffer != null) {
                if (this._size != null) {
                    this._size.decrementAndGet();
                }
                this._memoryFunction.accept(-byteBuffer.capacity());
            }
            return byteBuffer;
        }

        @Deprecated
        public ByteBuffer acquire(boolean bl) {
            ByteBuffer byteBuffer = this.acquire();
            if (byteBuffer == null) {
                return this._pool.newByteBuffer(this._capacity, bl);
            }
            return byteBuffer;
        }

        public void release(ByteBuffer byteBuffer) {
            this.resetUpdateTime();
            BufferUtil.reset(byteBuffer);
            if (this._size == null || this._size.incrementAndGet() <= this._maxSize) {
                this._queue.offer(byteBuffer);
                this._memoryFunction.accept(byteBuffer.capacity());
            } else {
                this._size.decrementAndGet();
            }
        }

        void resetUpdateTime() {
            this._lastUpdate.lazySet(System.nanoTime());
        }

        public void clear() {
            ByteBuffer byteBuffer;
            int n;
            int n2 = n = this._size == null ? 0 : this._size.get() - 1;
            while (n >= 0 && (byteBuffer = this.acquire()) != null) {
                if (this._size == null) continue;
                --n;
            }
        }

        boolean isEmpty() {
            return this._queue.isEmpty();
        }

        int size() {
            return this._queue.size();
        }

        long getLastUpdate() {
            return this._lastUpdate.get();
        }

        public String toString() {
            return String.format("%s@%x{capacity=%d, size=%d, maxSize=%d}", this.getClass().getSimpleName(), this.hashCode(), this._capacity, this.size(), this._maxSize);
        }
    }

    public static class Lease {
        private final ByteBufferPool byteBufferPool;
        private final List<ByteBuffer> buffers;
        private final List<Boolean> recycles;

        public Lease(ByteBufferPool byteBufferPool) {
            this.byteBufferPool = byteBufferPool;
            this.buffers = new ArrayList<ByteBuffer>();
            this.recycles = new ArrayList<Boolean>();
        }

        public ByteBuffer acquire(int n, boolean bl) {
            ByteBuffer byteBuffer = this.byteBufferPool.acquire(n, bl);
            BufferUtil.clearToFill(byteBuffer);
            return byteBuffer;
        }

        public void append(ByteBuffer byteBuffer, boolean bl) {
            this.buffers.add(byteBuffer);
            this.recycles.add(bl);
        }

        public void insert(int n, ByteBuffer byteBuffer, boolean bl) {
            this.buffers.add(n, byteBuffer);
            this.recycles.add(n, bl);
        }

        public List<ByteBuffer> getByteBuffers() {
            return this.buffers;
        }

        public long getTotalLength() {
            long l = 0L;
            for (ByteBuffer byteBuffer : this.buffers) {
                l += (long)byteBuffer.remaining();
            }
            return l;
        }

        public int getSize() {
            return this.buffers.size();
        }

        public void recycle() {
            for (int i = 0; i < this.buffers.size(); ++i) {
                ByteBuffer byteBuffer = this.buffers.get(i);
                if (!this.recycles.get(i).booleanValue()) continue;
                this.release(byteBuffer);
            }
            this.buffers.clear();
            this.recycles.clear();
        }

        public void release(ByteBuffer byteBuffer) {
            this.byteBufferPool.release(byteBuffer);
        }
    }
}

