/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.NullByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class ByteBufferAccumulator
implements AutoCloseable {
    private final List<ByteBuffer> _buffers = new ArrayList<ByteBuffer>();
    private final ByteBufferPool _bufferPool;
    private final boolean _direct;

    public ByteBufferAccumulator() {
        this(null, false);
    }

    public ByteBufferAccumulator(ByteBufferPool byteBufferPool, boolean bl) {
        this._bufferPool = byteBufferPool == null ? new NullByteBufferPool() : byteBufferPool;
        this._direct = bl;
    }

    public int getLength() {
        int n = 0;
        for (ByteBuffer byteBuffer : this._buffers) {
            n = Math.addExact(n, byteBuffer.remaining());
        }
        return n;
    }

    public ByteBufferPool getByteBufferPool() {
        return this._bufferPool;
    }

    public ByteBuffer ensureBuffer(int n) {
        return this.ensureBuffer(1, n);
    }

    public ByteBuffer ensureBuffer(int n, int n2) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = this._buffers.isEmpty() ? BufferUtil.EMPTY_BUFFER : this._buffers.get(this._buffers.size() - 1);
        if (BufferUtil.space(byteBuffer) < n) {
            byteBuffer = this._bufferPool.acquire(n2, this._direct);
            this._buffers.add(byteBuffer);
        }
        return byteBuffer;
    }

    public void copyBytes(byte[] byArray, int n, int n2) {
        this.copyBuffer(BufferUtil.toBuffer(byArray, n, n2));
    }

    public void copyBuffer(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            ByteBuffer byteBuffer2 = this.ensureBuffer(byteBuffer.remaining());
            int n = BufferUtil.flipToFill(byteBuffer2);
            BufferUtil.put(byteBuffer, byteBuffer2);
            BufferUtil.flipToFlush(byteBuffer2, n);
        }
    }

    public ByteBuffer takeByteBuffer() {
        if (this._buffers.size() == 1) {
            ByteBuffer byteBuffer = this._buffers.get(0);
            this._buffers.clear();
            return byteBuffer;
        }
        int n = this.getLength();
        ByteBuffer byteBuffer = this._bufferPool.acquire(n, this._direct);
        BufferUtil.clearToFill(byteBuffer);
        for (ByteBuffer byteBuffer2 : this._buffers) {
            byteBuffer.put(byteBuffer2);
            this._bufferPool.release(byteBuffer2);
        }
        BufferUtil.flipToFlush(byteBuffer, 0);
        this._buffers.clear();
        return byteBuffer;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer = this.takeByteBuffer();
        this._buffers.add(byteBuffer);
        return byteBuffer;
    }

    public byte[] toByteArray() {
        int n = this.getLength();
        if (n == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = BufferUtil.toBuffer(byArray);
        BufferUtil.clear(byteBuffer);
        this.writeTo(byteBuffer);
        return byArray;
    }

    public void writeTo(ByteBuffer byteBuffer) {
        int n = BufferUtil.flipToFill(byteBuffer);
        for (ByteBuffer byteBuffer2 : this._buffers) {
            byteBuffer.put(byteBuffer2.slice());
        }
        BufferUtil.flipToFlush(byteBuffer, n);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        for (ByteBuffer byteBuffer : this._buffers) {
            BufferUtil.writeTo(byteBuffer.slice(), outputStream);
        }
    }

    @Override
    public void close() {
        this._buffers.forEach(this._bufferPool::release);
        this._buffers.clear();
    }
}

