/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.Objects;
import org.eclipse.jetty.http.pathmap.MatchedPath;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.http.pathmap.RegexPathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;

public interface PathSpec
extends Comparable<PathSpec> {
    public static PathSpec from(String string) {
        Objects.requireNonNull(string, "null PathSpec not supported");
        if (string.length() == 0) {
            return new ServletPathSpec("");
        }
        return string.charAt(0) == '^' ? new RegexPathSpec(string) : new ServletPathSpec(string);
    }

    public int getSpecLength();

    public PathSpecGroup getGroup();

    public int getPathDepth();

    @Deprecated
    public String getPathInfo(String var1);

    @Deprecated
    public String getPathMatch(String var1);

    public String getDeclaration();

    public String getPrefix();

    public String getSuffix();

    @Deprecated
    public boolean matches(String var1);

    public MatchedPath matched(String var1);
}

