/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.MatchedPath;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Path Mappings")
public class PathMappings<E>
implements Iterable<MappedResource<E>>,
Dumpable {
    private static final Logger LOG = Log.getLogger(PathMappings.class);
    private final Set<MappedResource<E>> _mappings = new TreeSet<MappedResource>(Comparator.comparing(MappedResource::getPathSpec));
    private boolean _optimizedExact = true;
    private Trie<MappedResource<E>> _exactMap = new ArrayTernaryTrie<MappedResource<E>>(false);
    private boolean _optimizedPrefix = true;
    private Trie<MappedResource<E>> _prefixMap = new ArrayTernaryTrie<MappedResource<E>>(false);
    private boolean _optimizedSuffix = true;
    private Trie<MappedResource<E>> _suffixMap = new ArrayTernaryTrie<MappedResource<E>>(false);

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObjects(appendable, string, this.toString(), this._mappings);
    }

    @ManagedAttribute(value="mappings", readonly=true)
    public List<MappedResource<E>> getMappings() {
        return new ArrayList<MappedResource<E>>(this._mappings);
    }

    public int size() {
        return this._mappings.size();
    }

    public void reset() {
        this._mappings.clear();
        this._prefixMap.clear();
        this._suffixMap.clear();
    }

    public void removeIf(Predicate<MappedResource<E>> predicate) {
        this._mappings.removeIf(predicate);
    }

    public List<MatchedResource<E>> getMatchedList(String string) {
        ArrayList<MatchedResource<MatchedResource<E>>> arrayList = new ArrayList<MatchedResource<MatchedResource<E>>>();
        for (MappedResource<E> mappedResource : this._mappings) {
            MatchedPath matchedPath = mappedResource.getPathSpec().matched(string);
            if (matchedPath == null) continue;
            arrayList.add(new MatchedResource<E>(mappedResource.getResource(), mappedResource.getPathSpec(), matchedPath));
        }
        return arrayList;
    }

    public List<MappedResource<E>> getMatches(String string) {
        boolean bl = "/".equals(string);
        ArrayList<MappedResource<MappedResource<E>>> arrayList = new ArrayList<MappedResource<MappedResource<E>>>();
        block4: for (MappedResource<E> mappedResource : this._mappings) {
            switch (mappedResource.getPathSpec().getGroup()) {
                case ROOT: {
                    if (!bl) continue block4;
                    arrayList.add(mappedResource);
                    continue block4;
                }
                case DEFAULT: {
                    if (!bl && mappedResource.getPathSpec().matched(string) == null) continue block4;
                    arrayList.add(mappedResource);
                    continue block4;
                }
            }
            if (mappedResource.getPathSpec().matched(string) == null) continue;
            arrayList.add(mappedResource);
        }
        return arrayList;
    }

    public MatchedResource<E> getMatched(String string) {
        PathSpecGroup pathSpecGroup = null;
        boolean bl = false;
        for (MappedResource<E> mappedResource : this._mappings) {
            MatchedPath matchedPath;
            PathSpecGroup pathSpecGroup2 = mappedResource.getPathSpec().getGroup();
            if (pathSpecGroup2 == pathSpecGroup && bl) continue;
            if (pathSpecGroup2 != pathSpecGroup) {
                bl = false;
                switch (pathSpecGroup2) {
                    case EXACT: {
                        MappedResource<E> mappedResource2;
                        if (!this._optimizedExact) break;
                        int n = string.length();
                        while (n >= 0) {
                            if ((mappedResource2 = this._exactMap.getBest(string, 0, n--)) == null || (matchedPath = mappedResource2.getPathSpec().matched(string)) == null) continue;
                            return new MatchedResource<E>(mappedResource2.getResource(), mappedResource2.getPathSpec(), matchedPath);
                        }
                        bl = true;
                        break;
                    }
                    case PREFIX_GLOB: {
                        MappedResource<E> mappedResource2;
                        if (!this._optimizedPrefix) break;
                        int n = string.length();
                        while (n >= 0) {
                            if ((mappedResource2 = this._prefixMap.getBest(string, 0, n--)) == null || (matchedPath = mappedResource2.getPathSpec().matched(string)) == null) continue;
                            return new MatchedResource<E>(mappedResource2.getResource(), mappedResource2.getPathSpec(), matchedPath);
                        }
                        bl = true;
                        break;
                    }
                    case SUFFIX_GLOB: {
                        MappedResource<E> mappedResource2;
                        if (!this._optimizedSuffix) break;
                        int n = 0;
                        while ((n = string.indexOf(46, n + 1)) > 0) {
                            mappedResource2 = this._suffixMap.get(string, n + 1, string.length() - n - 1);
                            if (mappedResource2 == null || (matchedPath = mappedResource2.getPathSpec().matched(string)) == null) continue;
                            return new MatchedResource<E>(mappedResource2.getResource(), mappedResource2.getPathSpec(), matchedPath);
                        }
                        bl = true;
                        break;
                    }
                }
            }
            if ((matchedPath = mappedResource.getPathSpec().matched(string)) != null) {
                return new MatchedResource<E>(mappedResource.getResource(), mappedResource.getPathSpec(), matchedPath);
            }
            pathSpecGroup = pathSpecGroup2;
        }
        return null;
    }

    @Deprecated
    public MappedResource<E> getMatch(String string) {
        throw new UnsupportedOperationException("Use .getMatched(String) instead");
    }

    @Override
    public Iterator<MappedResource<E>> iterator() {
        return this._mappings.iterator();
    }

    @Deprecated
    public static PathSpec asPathSpec(String string) {
        return PathSpec.from(string);
    }

    public E get(PathSpec pathSpec) {
        return this._mappings.stream().filter(mappedResource -> mappedResource.getPathSpec().equals(pathSpec)).map(MappedResource::getResource).findFirst().orElse(null);
    }

    public boolean put(String string, E e) {
        return this.put(PathSpec.from(string), e);
    }

    public boolean put(PathSpec pathSpec, E e) {
        MappedResource<E> mappedResource = new MappedResource<E>(pathSpec, e);
        boolean bl = this._mappings.add(mappedResource);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} to {}", bl ? "Added" : "Ignored", mappedResource, this);
        }
        if (bl) {
            switch (pathSpec.getGroup()) {
                case EXACT: {
                    if (pathSpec instanceof ServletPathSpec) {
                        String string = pathSpec.getDeclaration();
                        while (string != null && !this._exactMap.put(string, mappedResource)) {
                            this._exactMap = new ArrayTernaryTrie<MappedResource<E>>((ArrayTernaryTrie)this._exactMap, 1.5);
                        }
                        break;
                    }
                    this._optimizedExact = false;
                    break;
                }
                case PREFIX_GLOB: {
                    if (pathSpec instanceof ServletPathSpec) {
                        String string = pathSpec.getPrefix();
                        while (string != null && !this._prefixMap.put(string, mappedResource)) {
                            this._prefixMap = new ArrayTernaryTrie<MappedResource<E>>((ArrayTernaryTrie)this._prefixMap, 1.5);
                        }
                        break;
                    }
                    this._optimizedPrefix = false;
                    break;
                }
                case SUFFIX_GLOB: {
                    if (pathSpec instanceof ServletPathSpec) {
                        String string = pathSpec.getSuffix();
                        while (string != null && !this._suffixMap.put(string, mappedResource)) {
                            this._suffixMap = new ArrayTernaryTrie<MappedResource<E>>((ArrayTernaryTrie)this._prefixMap, 1.5);
                        }
                        break;
                    }
                    this._optimizedSuffix = false;
                    break;
                }
            }
        }
        return bl;
    }

    public boolean remove(PathSpec pathSpec) {
        Iterator<MappedResource<E>> iterator = this._mappings.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!iterator.next().getPathSpec().equals(pathSpec)) continue;
            bl = true;
            iterator.remove();
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} to {}", bl ? "Removed" : "Ignored", pathSpec, this);
        }
        if (bl) {
            switch (pathSpec.getGroup()) {
                case EXACT: {
                    String string = pathSpec.getDeclaration();
                    if (string == null) break;
                    this._exactMap.remove(string);
                    this._optimizedExact = this.canBeOptimized(PathSpecGroup.EXACT);
                    break;
                }
                case PREFIX_GLOB: {
                    String string = pathSpec.getPrefix();
                    if (string == null) break;
                    this._prefixMap.remove(string);
                    this._optimizedPrefix = this.canBeOptimized(PathSpecGroup.PREFIX_GLOB);
                    break;
                }
                case SUFFIX_GLOB: {
                    String string = pathSpec.getSuffix();
                    if (string == null) break;
                    this._suffixMap.remove(string);
                    this._optimizedSuffix = this.canBeOptimized(PathSpecGroup.SUFFIX_GLOB);
                }
            }
        }
        return bl;
    }

    private boolean canBeOptimized(PathSpecGroup pathSpecGroup) {
        return this._mappings.stream().filter(mappedResource -> mappedResource.getPathSpec().getGroup() == pathSpecGroup).allMatch(mappedResource -> mappedResource.getPathSpec() instanceof ServletPathSpec);
    }

    public String toString() {
        return String.format("%s[size=%d]", this.getClass().getSimpleName(), this._mappings.size());
    }
}

