/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.eclipse.jetty.http.Http1FieldPreEncoder;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFieldPreEncoder;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PreEncodedHttpField
extends HttpField {
    private static final Logger LOG = Log.getLogger(PreEncodedHttpField.class);
    private static final HttpFieldPreEncoder[] __encoders;
    private final byte[][] _encodedField = new byte[__encoders.length][];

    private static int index(HttpVersion httpVersion) {
        switch (httpVersion) {
            case HTTP_1_0: 
            case HTTP_1_1: {
                return 0;
            }
            case HTTP_2: {
                return 1;
            }
        }
        return -1;
    }

    public PreEncodedHttpField(HttpHeader httpHeader, String string, String string2) {
        super(httpHeader, string, string2);
        for (int i = 0; i < __encoders.length; ++i) {
            this._encodedField[i] = __encoders[i].getEncodedField(httpHeader, string, string2);
        }
    }

    public PreEncodedHttpField(HttpHeader httpHeader, String string) {
        this(httpHeader, httpHeader.asString(), string);
    }

    public PreEncodedHttpField(String string, String string2) {
        this(null, string, string2);
    }

    public void putTo(ByteBuffer byteBuffer, HttpVersion httpVersion) {
        byteBuffer.put(this._encodedField[PreEncodedHttpField.index(httpVersion)]);
    }

    static {
        ArrayList<HttpFieldPreEncoder> arrayList = new ArrayList<HttpFieldPreEncoder>();
        Iterator<HttpFieldPreEncoder> iterator = ServiceLoader.load(HttpFieldPreEncoder.class).iterator();
        while (iterator.hasNext()) {
            try {
                HttpFieldPreEncoder httpFieldPreEncoder = iterator.next();
                if (PreEncodedHttpField.index(httpFieldPreEncoder.getHttpVersion()) < 0) continue;
                arrayList.add(httpFieldPreEncoder);
            }
            catch (Error | RuntimeException throwable) {
                LOG.debug(throwable);
            }
        }
        LOG.debug("HttpField encoders loaded: {}", arrayList);
        int n = arrayList.size();
        __encoders = new HttpFieldPreEncoder[n == 0 ? 1 : n];
        for (HttpFieldPreEncoder httpFieldPreEncoder : arrayList) {
            int n2 = PreEncodedHttpField.index(httpFieldPreEncoder.getHttpVersion());
            if (__encoders[n2] == null) {
                PreEncodedHttpField.__encoders[n2] = httpFieldPreEncoder;
                continue;
            }
            LOG.warn("multiple PreEncoders for " + (Object)((Object)httpFieldPreEncoder.getHttpVersion()), new Object[0]);
        }
        if (__encoders[0] == null) {
            PreEncodedHttpField.__encoders[0] = new Http1FieldPreEncoder();
        }
    }
}

