/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.component.Destroyable;

public class GZIPContentDecoder
implements Destroyable {
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private final List<ByteBuffer> _inflateds = new ArrayList<ByteBuffer>();
    private final Inflater _inflater = new Inflater(true);
    private final ByteBufferPool _pool;
    private final int _bufferSize;
    private State _state;
    private int _size;
    private long _value;
    private byte _flags;
    private ByteBuffer _inflated;

    public GZIPContentDecoder() {
        this(null, 2048);
    }

    public GZIPContentDecoder(int n) {
        this(null, n);
    }

    public GZIPContentDecoder(ByteBufferPool byteBufferPool, int n) {
        this._bufferSize = n;
        this._pool = byteBufferPool;
        this.reset();
    }

    public ByteBuffer decode(ByteBuffer byteBuffer) {
        this.decodeChunks(byteBuffer);
        if (this._inflateds.isEmpty()) {
            if (BufferUtil.isEmpty(this._inflated) || this._state == State.CRC || this._state == State.ISIZE) {
                return BufferUtil.EMPTY_BUFFER;
            }
            ByteBuffer byteBuffer2 = this._inflated;
            this._inflated = null;
            return byteBuffer2;
        }
        this._inflateds.add(this._inflated);
        this._inflated = null;
        int n = this._inflateds.stream().mapToInt(Buffer::remaining).sum();
        ByteBuffer byteBuffer3 = this.acquire(n);
        for (ByteBuffer byteBuffer4 : this._inflateds) {
            BufferUtil.append(byteBuffer3, byteBuffer4);
            this.release(byteBuffer4);
        }
        this._inflateds.clear();
        return byteBuffer3;
    }

    protected boolean decodedChunk(ByteBuffer byteBuffer) {
        if (this._inflated == null) {
            this._inflated = byteBuffer;
        } else if (BufferUtil.space(this._inflated) >= byteBuffer.remaining()) {
            BufferUtil.append(this._inflated, byteBuffer);
            this.release(byteBuffer);
        } else {
            this._inflateds.add(this._inflated);
            this._inflated = byteBuffer;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decodeChunks(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = null;
        try {
            block29: while (true) {
                int n;
                block44: {
                    switch (this._state) {
                        case INITIAL: {
                            this._state = State.ID;
                            break;
                        }
                        case FLAGS: {
                            if ((this._flags & 4) == 4) {
                                this._state = State.EXTRA_LENGTH;
                                this._size = 0;
                                this._value = 0L;
                                break;
                            }
                            if ((this._flags & 8) == 8) {
                                this._state = State.NAME;
                                break;
                            }
                            if ((this._flags & 0x10) == 16) {
                                this._state = State.COMMENT;
                                break;
                            }
                            if ((this._flags & 2) == 2) {
                                this._state = State.HCRC;
                                this._size = 0;
                                this._value = 0L;
                                break;
                            }
                            this._state = State.DATA;
                            continue block29;
                        }
                        case DATA: {
                            break block44;
                        }
                    }
                    if (byteBuffer.hasRemaining()) {
                        n = byteBuffer.get();
                        switch (this._state) {
                            case ID: {
                                this._value += (long)((n & 0xFF) << 8 * this._size);
                                ++this._size;
                                if (this._size != 2) continue block29;
                                if (this._value != 35615L) {
                                    throw new ZipException("Invalid gzip bytes");
                                }
                                this._state = State.CM;
                                continue block29;
                            }
                            case CM: {
                                if ((n & 0xFF) != 8) {
                                    throw new ZipException("Invalid gzip compression method");
                                }
                                this._state = State.FLG;
                                continue block29;
                            }
                            case FLG: {
                                this._flags = (byte)n;
                                this._state = State.MTIME;
                                this._size = 0;
                                this._value = 0L;
                                continue block29;
                            }
                            case MTIME: {
                                ++this._size;
                                if (this._size != 4) continue block29;
                                this._state = State.XFL;
                                continue block29;
                            }
                            case XFL: {
                                this._state = State.OS;
                                continue block29;
                            }
                            case OS: {
                                this._state = State.FLAGS;
                                continue block29;
                            }
                            case EXTRA_LENGTH: {
                                this._value += (long)((n & 0xFF) << 8 * this._size);
                                ++this._size;
                                if (this._size != 2) continue block29;
                                this._state = State.EXTRA;
                                continue block29;
                            }
                            case EXTRA: {
                                --this._value;
                                if (this._value != 0L) continue block29;
                                this._flags = (byte)(this._flags & 0xFFFFFFFB);
                                this._state = State.FLAGS;
                                continue block29;
                            }
                            case NAME: {
                                if (n != 0) continue block29;
                                this._flags = (byte)(this._flags & 0xFFFFFFF7);
                                this._state = State.FLAGS;
                                continue block29;
                            }
                            case COMMENT: {
                                if (n != 0) continue block29;
                                this._flags = (byte)(this._flags & 0xFFFFFFEF);
                                this._state = State.FLAGS;
                                continue block29;
                            }
                            case HCRC: {
                                ++this._size;
                                if (this._size != 2) continue block29;
                                this._flags = (byte)(this._flags & 0xFFFFFFFD);
                                this._state = State.FLAGS;
                                continue block29;
                            }
                            case CRC: {
                                this._value += (long)((n & 0xFF) << 8 * this._size);
                                ++this._size;
                                if (this._size != 4) continue block29;
                                this._state = State.ISIZE;
                                this._size = 0;
                                this._value = 0L;
                                continue block29;
                            }
                            case ISIZE: {
                                this._value |= ((long)n & 0xFFL) << 8 * this._size;
                                ++this._size;
                                if (this._size != 4) continue block29;
                                if (this._value != (this._inflater.getBytesWritten() & 0xFFFFFFFFL)) {
                                    throw new ZipException("Invalid input size");
                                }
                                this.reset();
                                if (byteBuffer2 == null) return;
                                this.release(byteBuffer2);
                                return;
                            }
                        }
                        throw new ZipException();
                    }
                    if (byteBuffer2 == null) return;
                    this.release(byteBuffer2);
                    return;
                }
                while (true) {
                    if (byteBuffer2 == null) {
                        byteBuffer2 = this.acquire(this._bufferSize);
                    }
                    try {
                        n = this._inflater.inflate(byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.capacity());
                        byteBuffer2.limit(n);
                    }
                    catch (DataFormatException dataFormatException) {
                        throw new ZipException(dataFormatException.getMessage());
                    }
                    if (byteBuffer2.hasRemaining()) {
                        ByteBuffer byteBuffer3 = byteBuffer2;
                        byteBuffer2 = null;
                        if (!this.decodedChunk(byteBuffer3)) continue;
                        if (byteBuffer2 == null) return;
                        this.release(byteBuffer2);
                        return;
                    }
                    if (this._inflater.needsInput()) {
                        if (!byteBuffer.hasRemaining()) {
                            if (byteBuffer2 == null) return;
                            this.release(byteBuffer2);
                            return;
                        }
                        if (byteBuffer.hasArray()) {
                            this._inflater.setInput(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                            byteBuffer.position(byteBuffer.limit());
                            continue;
                        }
                        byte[] byArray = new byte[byteBuffer.remaining()];
                        byteBuffer.get(byArray);
                        this._inflater.setInput(byArray);
                        continue;
                    }
                    if (this._inflater.finished()) break;
                }
                n = this._inflater.getRemaining();
                byteBuffer.position(byteBuffer.limit() - n);
                this._state = State.CRC;
                this._size = 0;
                this._value = 0L;
            }
        }
        catch (ZipException zipException) {
            try {
                throw new RuntimeException(zipException);
            }
            catch (Throwable throwable) {
                if (byteBuffer2 == null) throw throwable;
                this.release(byteBuffer2);
                throw throwable;
            }
        }
    }

    private void reset() {
        this._inflater.reset();
        this._state = State.INITIAL;
        this._size = 0;
        this._value = 0L;
        this._flags = 0;
    }

    @Override
    public void destroy() {
        this._inflater.end();
    }

    public boolean isFinished() {
        return this._state == State.INITIAL;
    }

    public ByteBuffer acquire(int n) {
        return this._pool == null ? BufferUtil.allocate(n) : this._pool.acquire(n, false);
    }

    public void release(ByteBuffer byteBuffer) {
        if (this._pool != null && !BufferUtil.isTheEmptyBuffer(byteBuffer)) {
            this._pool.release(byteBuffer);
        }
    }

    private static enum State {
        INITIAL,
        ID,
        CM,
        FLG,
        MTIME,
        XFL,
        OS,
        FLAGS,
        EXTRA_LENGTH,
        EXTRA,
        NAME,
        COMMENT,
        HCRC,
        DATA,
        CRC,
        ISIZE;

    }
}

