/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class ValidatingConnectionPool
extends DuplexConnectionPool {
    private static final Logger LOG = Log.getLogger(ValidatingConnectionPool.class);
    private final Scheduler scheduler;
    private final long timeout;
    private final Map<Connection, Holder> quarantine;

    public ValidatingConnectionPool(Destination destination, int n, Callback callback, Scheduler scheduler, long l) {
        super((HttpDestination)destination, n, callback);
        this.scheduler = scheduler;
        this.timeout = l;
        this.quarantine = new ConcurrentHashMap<Connection, Holder>(n);
    }

    @ManagedAttribute(value="The number of validating connections", readonly=true)
    public int getValidatingConnectionCount() {
        return this.quarantine.size();
    }

    @Override
    public boolean release(Connection connection) {
        Holder holder = new Holder(connection);
        holder.task = this.scheduler.schedule(holder, this.timeout, TimeUnit.MILLISECONDS);
        this.quarantine.put(connection, holder);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating for {}ms {}", this.timeout, connection);
        }
        this.released(connection);
        return true;
    }

    @Override
    public boolean remove(Connection connection) {
        boolean bl;
        Holder holder = this.quarantine.remove(connection);
        if (holder == null) {
            return super.remove(connection);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed while validating {}", connection);
        }
        if (bl = holder.cancel()) {
            return this.remove(connection, true);
        }
        return super.remove(connection);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        DumpableCollection dumpableCollection = new DumpableCollection("quarantine", this.quarantine.values());
        Dumpable.dumpObjects(appendable, string, this, dumpableCollection);
    }

    @Override
    public String toString() {
        int n = this.quarantine.size();
        return String.format("%s[v=%d]", super.toString(), n);
    }

    private class Holder
    implements Runnable {
        private final long timestamp = System.nanoTime();
        private final AtomicBoolean done = new AtomicBoolean();
        private final Connection connection;
        public Scheduler.Task task;

        public Holder(Connection connection) {
            this.connection = connection;
        }

        @Override
        public void run() {
            if (this.done.compareAndSet(false, true)) {
                boolean bl = ValidatingConnectionPool.this.isClosed();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Validated {}", this.connection);
                }
                ValidatingConnectionPool.this.quarantine.remove(this.connection);
                if (!bl) {
                    ValidatingConnectionPool.this.deactivate(this.connection);
                }
                ValidatingConnectionPool.this.idle(this.connection, bl);
                ValidatingConnectionPool.this.proceed();
            }
        }

        public boolean cancel() {
            if (this.done.compareAndSet(false, true)) {
                this.task.cancel();
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format("%s[validationLeft=%dms]", this.connection, ValidatingConnectionPool.this.timeout - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.timestamp));
        }
    }
}

