/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jetty.client.Synchronizable;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpContent
implements Callback,
Closeable {
    private static final Logger LOG = Log.getLogger(HttpContent.class);
    private static final ByteBuffer AFTER = ByteBuffer.allocate(0);
    private static final ByteBuffer CLOSE = ByteBuffer.allocate(0);
    private final ContentProvider provider;
    private final Iterator<ByteBuffer> iterator;
    private ByteBuffer buffer;
    private ByteBuffer content;
    private boolean last;

    public HttpContent(ContentProvider contentProvider) {
        this.provider = contentProvider;
        this.iterator = contentProvider == null ? Collections.emptyIterator() : contentProvider.iterator();
    }

    private static boolean isTheCloseBuffer(ByteBuffer byteBuffer) {
        boolean bl = byteBuffer == CLOSE;
        return bl;
    }

    public boolean hasContent() {
        return this.provider != null;
    }

    public boolean isLast() {
        return this.last;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean advance() {
        if (this.iterator instanceof Synchronizable) {
            Object object = ((Synchronizable)((Object)this.iterator)).getLock();
            synchronized (object) {
                return this.advance(this.iterator);
            }
        }
        return this.advance(this.iterator);
    }

    private boolean advance(Iterator<ByteBuffer> iterator) {
        boolean bl = iterator.hasNext();
        ByteBuffer byteBuffer = bl ? iterator.next() : null;
        boolean bl2 = bl && iterator.hasNext();
        boolean bl3 = this.last;
        boolean bl4 = this.last = !bl2;
        if (bl) {
            this.buffer = byteBuffer;
            ByteBuffer byteBuffer2 = this.content = byteBuffer == null ? null : byteBuffer.slice();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content to {} chunk {}", bl2 ? "next" : "last", String.valueOf(byteBuffer));
            }
            return byteBuffer != null;
        }
        if (bl3) {
            this.buffer = this.content = AFTER;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content past last chunk", new Object[0]);
            }
        } else {
            this.buffer = this.content = CLOSE;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content to last chunk", new Object[0]);
            }
        }
        return false;
    }

    public boolean isConsumed() {
        return this.buffer == AFTER;
    }

    @Override
    public void succeeded() {
        if (this.isConsumed()) {
            return;
        }
        if (HttpContent.isTheCloseBuffer(this.buffer)) {
            return;
        }
        if (this.iterator instanceof Callback) {
            ((Callback)((Object)this.iterator)).succeeded();
        }
    }

    @Override
    public void failed(Throwable throwable) {
        if (this.isConsumed()) {
            return;
        }
        if (HttpContent.isTheCloseBuffer(this.buffer)) {
            return;
        }
        if (this.iterator instanceof Callback) {
            ((Callback)((Object)this.iterator)).failed(throwable);
        }
    }

    @Override
    public void close() {
        if (this.iterator instanceof Closeable) {
            IO.close((Closeable)((Object)this.iterator));
        }
    }

    public String toString() {
        return String.format("%s@%x - has=%b,last=%b,consumed=%b,buffer=%s", this.getClass().getSimpleName(), this.hashCode(), this.hasContent(), this.isLast(), this.isConsumed(), BufferUtil.toDetailString(this.getContent()));
    }
}

