/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.io.ByteBufferPool;

public class GZIPContentDecoder
extends org.eclipse.jetty.http.GZIPContentDecoder
implements ContentDecoder {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public GZIPContentDecoder() {
        this(8192);
    }

    public GZIPContentDecoder(int n) {
        this(null, n);
    }

    public GZIPContentDecoder(ByteBufferPool byteBufferPool, int n) {
        super(byteBufferPool, n);
    }

    @Override
    protected boolean decodedChunk(ByteBuffer byteBuffer) {
        super.decodedChunk(byteBuffer);
        return true;
    }

    public static class Factory
    extends ContentDecoder.Factory {
        private final int bufferSize;
        private final ByteBufferPool byteBufferPool;

        public Factory() {
            this(8192);
        }

        public Factory(int n) {
            this(null, n);
        }

        public Factory(ByteBufferPool byteBufferPool) {
            this(byteBufferPool, 8192);
        }

        public Factory(ByteBufferPool byteBufferPool, int n) {
            super("gzip");
            this.byteBufferPool = byteBufferPool;
            this.bufferSize = n;
        }

        @Override
        public ContentDecoder newContentDecoder() {
            return new GZIPContentDecoder(this.byteBufferPool, this.bufferSize);
        }
    }
}

