/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.AbstractBranch;

public abstract class AbstractDocument
extends AbstractBranch
implements Document {
    protected String encoding;

    public short getNodeType() {
        return 9;
    }

    public String getPath(Element element) {
        return "/";
    }

    public String getUniquePath(Element element) {
        return "/";
    }

    public Document getDocument() {
        return this;
    }

    public String getXMLEncoding() {
        return null;
    }

    public String getStringValue() {
        Element element = this.getRootElement();
        return element != null ? element.getStringValue() : "";
    }

    public String asXML() {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setEncoding(this.encoding);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xMLWriter = new XMLWriter(stringWriter, outputFormat);
            xMLWriter.write(this);
            xMLWriter.flush();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException while generating textual representation: " + iOException.getMessage());
        }
    }

    public void write(Writer writer) throws IOException {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setEncoding(this.encoding);
        XMLWriter xMLWriter = new XMLWriter(writer, outputFormat);
        xMLWriter.write(this);
    }

    public void accept(Visitor visitor) {
        List list;
        visitor.visit(this);
        DocumentType documentType = this.getDocType();
        if (documentType != null) {
            visitor.visit(documentType);
        }
        if ((list = this.content()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node;
                Object e = iterator.next();
                if (e instanceof String) {
                    node = this.getDocumentFactory().createText((String)e);
                    visitor.visit((Text)node);
                    continue;
                }
                node = (Node)e;
                node.accept(visitor);
            }
        }
    }

    public String toString() {
        return super.toString() + " [Document: name " + this.getName() + "]";
    }

    public void normalize() {
        Element element = this.getRootElement();
        if (element != null) {
            element.normalize();
        }
    }

    public Document addComment(String string) {
        Comment comment = this.getDocumentFactory().createComment(string);
        this.add(comment);
        return this;
    }

    public Document addProcessingInstruction(String string, String string2) {
        ProcessingInstruction processingInstruction = this.getDocumentFactory().createProcessingInstruction(string, string2);
        this.add(processingInstruction);
        return this;
    }

    public Document addProcessingInstruction(String string, Map map) {
        ProcessingInstruction processingInstruction = this.getDocumentFactory().createProcessingInstruction(string, map);
        this.add(processingInstruction);
        return this;
    }

    public Element addElement(String string) {
        Element element = this.getDocumentFactory().createElement(string);
        this.add(element);
        return element;
    }

    public Element addElement(String string, String string2) {
        Element element = this.getDocumentFactory().createElement(string, string2);
        this.add(element);
        return element;
    }

    public Element addElement(QName qName) {
        Element element = this.getDocumentFactory().createElement(qName);
        this.add(element);
        return element;
    }

    public void setRootElement(Element element) {
        this.clearContent();
        if (element != null) {
            super.add(element);
            this.rootElementAdded(element);
        }
    }

    public void add(Element element) {
        this.checkAddElementAllowed(element);
        super.add(element);
        this.rootElementAdded(element);
    }

    public boolean remove(Element element) {
        boolean bl = super.remove(element);
        Element element2 = this.getRootElement();
        if (element2 != null && bl) {
            this.setRootElement(null);
        }
        element.setDocument(null);
        return bl;
    }

    public Node asXPathResult(Element element) {
        return this;
    }

    protected void childAdded(Node node) {
        if (node != null) {
            node.setDocument(this);
        }
    }

    protected void childRemoved(Node node) {
        if (node != null) {
            node.setDocument(null);
        }
    }

    protected void checkAddElementAllowed(Element element) {
        Element element2 = this.getRootElement();
        if (element2 != null) {
            throw new IllegalAddException(this, (Node)element, "Cannot add another element to this Document as it already has a root element of: " + element2.getQualifiedName());
        }
    }

    protected abstract void rootElementAdded(Element var1);

    public void setXMLEncoding(String string) {
        this.encoding = string;
    }
}

