/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.jaxb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.SAXReader;
import org.dom4j.jaxb.JAXBObjectHandler;
import org.dom4j.jaxb.JAXBRuntimeException;
import org.dom4j.jaxb.JAXBSupport;
import org.xml.sax.InputSource;

public class JAXBReader
extends JAXBSupport {
    private SAXReader reader;
    private boolean pruneElements;

    public JAXBReader(String string) {
        super(string);
    }

    public JAXBReader(String string, ClassLoader classLoader) {
        super(string, classLoader);
    }

    public Document read(File file) throws DocumentException {
        return this.getReader().read(file);
    }

    public Document read(File file, Charset charset) throws DocumentException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
            return this.getReader().read(inputStreamReader);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DocumentException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }

    public Document read(InputSource inputSource) throws DocumentException {
        try {
            return this.getReader().read(inputSource);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document read(InputStream inputStream) throws DocumentException {
        try {
            return this.getReader().read(inputStream);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document read(InputStream inputStream, String string) throws DocumentException {
        try {
            return this.getReader().read(inputStream);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document read(Reader reader) throws DocumentException {
        try {
            return this.getReader().read(reader);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document read(Reader reader, String string) throws DocumentException {
        try {
            return this.getReader().read(reader);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document read(String string) throws DocumentException {
        try {
            return this.getReader().read(string);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public Document read(URL uRL) throws DocumentException {
        try {
            return this.getReader().read(uRL);
        }
        catch (JAXBRuntimeException jAXBRuntimeException) {
            Throwable throwable = jAXBRuntimeException.getCause();
            throw new DocumentException(throwable.getMessage(), throwable);
        }
    }

    public void addObjectHandler(String string, JAXBObjectHandler jAXBObjectHandler) {
        UnmarshalElementHandler unmarshalElementHandler = new UnmarshalElementHandler(this, jAXBObjectHandler);
        this.getReader().addHandler(string, unmarshalElementHandler);
    }

    public void removeObjectHandler(String string) {
        this.getReader().removeHandler(string);
    }

    public void addHandler(String string, ElementHandler elementHandler) {
        this.getReader().addHandler(string, elementHandler);
    }

    public void removeHandler(String string) {
        this.getReader().removeHandler(string);
    }

    public void resetHandlers() {
        this.getReader().resetHandlers();
    }

    public boolean isPruneElements() {
        return this.pruneElements;
    }

    public void setPruneElements(boolean bl) {
        this.pruneElements = bl;
        if (bl) {
            this.getReader().setDefaultHandler(new PruningElementHandler());
        }
    }

    private SAXReader getReader() {
        if (this.reader == null) {
            this.reader = new SAXReader();
        }
        return this.reader;
    }

    private class PruningElementHandler
    implements ElementHandler {
        public void onStart(ElementPath elementPath) {
        }

        public void onEnd(ElementPath elementPath) {
            Element element = elementPath.getCurrent();
            element.detach();
            element = null;
        }
    }

    private class UnmarshalElementHandler
    implements ElementHandler {
        private JAXBReader jaxbReader;
        private JAXBObjectHandler handler;

        public UnmarshalElementHandler(JAXBReader jAXBReader2, JAXBObjectHandler jAXBObjectHandler) {
            this.jaxbReader = jAXBReader2;
            this.handler = jAXBObjectHandler;
        }

        public void onStart(ElementPath elementPath) {
        }

        public void onEnd(ElementPath elementPath) {
            try {
                Element element = elementPath.getCurrent();
                javax.xml.bind.Element element2 = this.jaxbReader.unmarshal(element);
                if (this.jaxbReader.isPruneElements()) {
                    element.detach();
                }
                this.handler.handleObject(element2);
            }
            catch (Exception exception) {
                throw new JAXBRuntimeException(exception);
            }
        }
    }
}

