/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.List;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.JAXPHelper;
import org.dom4j.io.SAXHelper;
import org.dom4j.tree.NamespaceStack;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;

public class DOMWriter {
    private static boolean loggedWarning = false;
    private static final String[] DEFAULT_DOM_DOCUMENT_CLASSES = new String[]{"org.apache.xerces.dom.DocumentImpl", "gnu.xml.dom.DomDocument", "org.apache.crimson.tree.XmlDocument", "com.sun.xml.tree.XmlDocument", "oracle.xml.parser.v2.XMLDocument", "oracle.xml.parser.XMLDocument", "org.dom4j.dom.DOMDocument"};
    private Class domDocumentClass;
    private NamespaceStack namespaceStack = new NamespaceStack();
    static /* synthetic */ Class class$org$dom4j$io$DOMWriter;

    public DOMWriter() {
    }

    public DOMWriter(Class clazz) {
        this.domDocumentClass = clazz;
    }

    public Class getDomDocumentClass() throws DocumentException {
        Class<?> clazz = this.domDocumentClass;
        if (clazz == null) {
            int n = DEFAULT_DOM_DOCUMENT_CLASSES.length;
            for (int i = 0; i < n; ++i) {
                try {
                    String string = DEFAULT_DOM_DOCUMENT_CLASSES[i];
                    clazz = Class.forName(string, true, (class$org$dom4j$io$DOMWriter == null ? DOMWriter.class$("org.dom4j.io.DOMWriter") : class$org$dom4j$io$DOMWriter).getClassLoader());
                    if (clazz == null) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    public void setDomDocumentClass(Class clazz) {
        this.domDocumentClass = clazz;
    }

    public void setDomDocumentClassName(String string) throws DocumentException {
        try {
            this.domDocumentClass = Class.forName(string, true, (class$org$dom4j$io$DOMWriter == null ? (class$org$dom4j$io$DOMWriter = DOMWriter.class$("org.dom4j.io.DOMWriter")) : class$org$dom4j$io$DOMWriter).getClassLoader());
        }
        catch (Exception exception) {
            throw new DocumentException("Could not load the DOM Document class: " + string, exception);
        }
    }

    public org.w3c.dom.Document write(Document document) throws DocumentException {
        if (document instanceof org.w3c.dom.Document) {
            return (org.w3c.dom.Document)((Object)document);
        }
        this.resetNamespaceStack();
        org.w3c.dom.Document document2 = this.createDomDocument(document);
        this.appendDOMTree(document2, (org.w3c.dom.Node)document2, document.content());
        this.namespaceStack.clear();
        return document2;
    }

    public org.w3c.dom.Document write(Document document, DOMImplementation dOMImplementation) throws DocumentException {
        if (document instanceof org.w3c.dom.Document) {
            return (org.w3c.dom.Document)((Object)document);
        }
        this.resetNamespaceStack();
        org.w3c.dom.Document document2 = this.createDomDocument(document, dOMImplementation);
        this.appendDOMTree(document2, (org.w3c.dom.Node)document2, document.content());
        this.namespaceStack.clear();
        return document2;
    }

    protected void appendDOMTree(org.w3c.dom.Document document, org.w3c.dom.Node node, List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e instanceof Element) {
                this.appendDOMTree(document, node, (Element)e);
                continue;
            }
            if (e instanceof String) {
                this.appendDOMTree(document, node, (String)e);
                continue;
            }
            if (e instanceof Text) {
                Text text = (Text)e;
                this.appendDOMTree(document, node, text.getText());
                continue;
            }
            if (e instanceof CDATA) {
                this.appendDOMTree(document, node, (CDATA)e);
                continue;
            }
            if (e instanceof Comment) {
                this.appendDOMTree(document, node, (Comment)e);
                continue;
            }
            if (e instanceof Entity) {
                this.appendDOMTree(document, node, (Entity)e);
                continue;
            }
            if (!(e instanceof ProcessingInstruction)) continue;
            this.appendDOMTree(document, node, (ProcessingInstruction)e);
        }
    }

    protected void appendDOMTree(org.w3c.dom.Document document, org.w3c.dom.Node node, Element element) {
        Node node2;
        int n;
        String string = element.getNamespaceURI();
        String string2 = element.getQualifiedName();
        org.w3c.dom.Element element2 = document.createElementNS(string, string2);
        int n2 = this.namespaceStack.size();
        Namespace namespace = element.getNamespace();
        if (this.isNamespaceDeclaration(namespace)) {
            this.namespaceStack.push(namespace);
            this.writeNamespace(element2, namespace);
        }
        List list = element.declaredNamespaces();
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            node2 = (Namespace)list.get(n);
            if (!this.isNamespaceDeclaration((Namespace)node2)) continue;
            this.namespaceStack.push((Namespace)node2);
            this.writeNamespace(element2, (Namespace)node2);
        }
        n3 = element.attributeCount();
        for (n = 0; n < n3; ++n) {
            node2 = element.attribute(n);
            String string3 = node2.getNamespaceURI();
            String string4 = node2.getQualifiedName();
            String string5 = node2.getValue();
            element2.setAttributeNS(string3, string4, string5);
        }
        this.appendDOMTree(document, (org.w3c.dom.Node)element2, element.content());
        node.appendChild(element2);
        while (this.namespaceStack.size() > n2) {
            this.namespaceStack.pop();
        }
    }

    protected void appendDOMTree(org.w3c.dom.Document document, org.w3c.dom.Node node, CDATA cDATA) {
        CDATASection cDATASection = document.createCDATASection(cDATA.getText());
        node.appendChild(cDATASection);
    }

    protected void appendDOMTree(org.w3c.dom.Document document, org.w3c.dom.Node node, Comment comment) {
        org.w3c.dom.Comment comment2 = document.createComment(comment.getText());
        node.appendChild(comment2);
    }

    protected void appendDOMTree(org.w3c.dom.Document document, org.w3c.dom.Node node, String string) {
        org.w3c.dom.Text text = document.createTextNode(string);
        node.appendChild(text);
    }

    protected void appendDOMTree(org.w3c.dom.Document document, org.w3c.dom.Node node, Entity entity) {
        EntityReference entityReference = document.createEntityReference(entity.getName());
        node.appendChild(entityReference);
    }

    protected void appendDOMTree(org.w3c.dom.Document document, org.w3c.dom.Node node, ProcessingInstruction processingInstruction) {
        org.w3c.dom.ProcessingInstruction processingInstruction2 = document.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getText());
        node.appendChild(processingInstruction2);
    }

    protected void writeNamespace(org.w3c.dom.Element element, Namespace namespace) {
        String string = this.attributeNameForNamespace(namespace);
        element.setAttribute(string, namespace.getURI());
    }

    protected String attributeNameForNamespace(Namespace namespace) {
        String string = "xmlns";
        String string2 = namespace.getPrefix();
        if (string2.length() > 0) {
            return string + ":" + string2;
        }
        return string;
    }

    protected org.w3c.dom.Document createDomDocument(Document document) throws DocumentException {
        org.w3c.dom.Document document2 = null;
        if (this.domDocumentClass != null) {
            try {
                document2 = (org.w3c.dom.Document)this.domDocumentClass.newInstance();
            }
            catch (Exception exception) {
                throw new DocumentException("Could not instantiate an instance of DOM Document with class: " + this.domDocumentClass.getName(), exception);
            }
        }
        document2 = this.createDomDocumentViaJAXP();
        if (document2 == null) {
            Class clazz = this.getDomDocumentClass();
            try {
                document2 = (org.w3c.dom.Document)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new DocumentException("Could not instantiate an instance of DOM Document with class: " + clazz.getName(), exception);
            }
        }
        return document2;
    }

    protected org.w3c.dom.Document createDomDocumentViaJAXP() throws DocumentException {
        try {
            return JAXPHelper.createDocument(false, true);
        }
        catch (Throwable throwable) {
            if (!loggedWarning) {
                loggedWarning = true;
                if (SAXHelper.isVerboseErrorReporting()) {
                    System.out.println("Warning: Caught exception attempting to use JAXP to create a W3C DOM document");
                    System.out.println("Warning: Exception was: " + throwable);
                    throwable.printStackTrace();
                } else {
                    System.out.println("Warning: Error occurred using JAXP to create a DOM document.");
                }
            }
            return null;
        }
    }

    protected org.w3c.dom.Document createDomDocument(Document document, DOMImplementation dOMImplementation) throws DocumentException {
        String string = null;
        String string2 = null;
        DocumentType documentType = null;
        return dOMImplementation.createDocument(string, string2, documentType);
    }

    protected boolean isNamespaceDeclaration(Namespace namespace) {
        String string;
        return namespace != null && namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE && (string = namespace.getURI()) != null && string.length() > 0 && !this.namespaceStack.contains(namespace);
    }

    protected void resetNamespaceStack() {
        this.namespaceStack.clear();
        this.namespaceStack.push(Namespace.XML_NAMESPACE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

