/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.ArrayList;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.NamespaceStack;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMReader {
    private DocumentFactory factory;
    private NamespaceStack namespaceStack;

    public DOMReader() {
        this.factory = DocumentFactory.getInstance();
        this.namespaceStack = new NamespaceStack(this.factory);
    }

    public DOMReader(DocumentFactory documentFactory) {
        this.factory = documentFactory;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    public DocumentFactory getDocumentFactory() {
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory;
        this.namespaceStack.setDocumentFactory(this.factory);
    }

    public Document read(org.w3c.dom.Document document) {
        if (document instanceof Document) {
            return (Document)((Object)document);
        }
        Document document2 = this.createDocument();
        this.clearNamespaceStack();
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            this.readTree(nodeList.item(i), document2);
        }
        return document2;
    }

    protected void readTree(Node node, Branch branch) {
        Element element = null;
        Document document = null;
        if (branch instanceof Element) {
            element = (Element)branch;
        } else {
            document = (Document)branch;
        }
        switch (node.getNodeType()) {
            case 1: {
                this.readElement(node, branch);
                break;
            }
            case 7: {
                if (branch instanceof Element) {
                    Element element2 = (Element)branch;
                    element2.addProcessingInstruction(node.getNodeName(), node.getNodeValue());
                    break;
                }
                Document document2 = (Document)branch;
                document2.addProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                if (branch instanceof Element) {
                    ((Element)branch).addComment(node.getNodeValue());
                    break;
                }
                ((Document)branch).addComment(node.getNodeValue());
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                document.addDocType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
                break;
            }
            case 3: {
                element.addText(node.getNodeValue());
                break;
            }
            case 4: {
                element.addCDATA(node.getNodeValue());
                break;
            }
            case 5: {
                Node node2 = node.getFirstChild();
                if (node2 != null) {
                    element.addEntity(node.getNodeName(), node2.getNodeValue());
                    break;
                }
                element.addEntity(node.getNodeName(), "");
                break;
            }
            case 6: {
                element.addEntity(node.getNodeName(), node.getNodeValue());
                break;
            }
            default: {
                System.out.println("WARNING: Unknown DOM node type: " + node.getNodeType());
            }
        }
    }

    protected void readElement(Node node, Branch branch) {
        Node node2;
        int n;
        Object object;
        NamedNodeMap namedNodeMap;
        int n2 = this.namespaceStack.size();
        String string = node.getNamespaceURI();
        String string2 = node.getPrefix();
        if (string2 == null) {
            string2 = "";
        }
        if ((namedNodeMap = node.getAttributes()) != null && string == null && (object = namedNodeMap.getNamedItem("xmlns")) != null) {
            string = object.getNodeValue();
            string2 = "";
        }
        object = this.namespaceStack.getQName(string, node.getLocalName(), node.getNodeName());
        Element element = branch.addElement((QName)object);
        if (namedNodeMap != null) {
            Object object2;
            int n3 = namedNodeMap.getLength();
            ArrayList<Node> arrayList = new ArrayList<Node>(n3);
            for (n = 0; n < n3; ++n) {
                node2 = namedNodeMap.item(n);
                object2 = node2.getNodeName();
                if (((String)object2).startsWith("xmlns")) {
                    String string3 = this.getPrefix((String)object2);
                    String string4 = node2.getNodeValue();
                    Namespace namespace = this.namespaceStack.addNamespace(string3, string4);
                    element.add(namespace);
                    continue;
                }
                arrayList.add(node2);
            }
            n3 = arrayList.size();
            for (n = 0; n < n3; ++n) {
                node2 = (Node)arrayList.get(n);
                object2 = this.namespaceStack.getQName(node2.getNamespaceURI(), node2.getLocalName(), node2.getNodeName());
                element.addAttribute((QName)object2, node2.getNodeValue());
            }
        }
        NodeList nodeList = node.getChildNodes();
        n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node2 = nodeList.item(i);
            this.readTree(node2, element);
        }
        while (this.namespaceStack.size() > n2) {
            this.namespaceStack.pop();
        }
    }

    protected Namespace getNamespace(String string, String string2) {
        return this.getDocumentFactory().createNamespace(string, string2);
    }

    protected Document createDocument() {
        return this.getDocumentFactory().createDocument();
    }

    protected void clearNamespaceStack() {
        this.namespaceStack.clear();
        if (!this.namespaceStack.contains(Namespace.XML_NAMESPACE)) {
            this.namespaceStack.push(Namespace.XML_NAMESPACE);
        }
    }

    private String getPrefix(String string) {
        int n = string.indexOf(58, 5);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return "";
    }
}

