/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dom;

import java.util.List;
import org.dom4j.Branch;
import org.dom4j.CharacterData;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Node;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMNodeHelper {
    public static final NodeList EMPTY_NODE_LIST = new EmptyNodeList();

    protected DOMNodeHelper() {
    }

    public static boolean supports(Node node, String string, String string2) {
        return false;
    }

    public static String getNamespaceURI(Node node) {
        return null;
    }

    public static String getPrefix(Node node) {
        return null;
    }

    public static String getLocalName(Node node) {
        return null;
    }

    public static void setPrefix(Node node, String string) throws DOMException {
        DOMNodeHelper.notSupported();
    }

    public static String getNodeValue(Node node) throws DOMException {
        return node.getText();
    }

    public static void setNodeValue(Node node, String string) throws DOMException {
        node.setText(string);
    }

    public static org.w3c.dom.Node getParentNode(Node node) {
        return DOMNodeHelper.asDOMNode(node.getParent());
    }

    public static NodeList getChildNodes(Node node) {
        return EMPTY_NODE_LIST;
    }

    public static org.w3c.dom.Node getFirstChild(Node node) {
        return null;
    }

    public static org.w3c.dom.Node getLastChild(Node node) {
        return null;
    }

    public static org.w3c.dom.Node getPreviousSibling(Node node) {
        int n;
        Element element = node.getParent();
        if (element != null && (n = element.indexOf(node)) > 0) {
            Node node2 = element.node(n - 1);
            return DOMNodeHelper.asDOMNode(node2);
        }
        return null;
    }

    public static org.w3c.dom.Node getNextSibling(Node node) {
        int n;
        Element element = node.getParent();
        if (element != null && (n = element.indexOf(node)) >= 0 && ++n < element.nodeCount()) {
            Node node2 = element.node(n);
            return DOMNodeHelper.asDOMNode(node2);
        }
        return null;
    }

    public static NamedNodeMap getAttributes(Node node) {
        return null;
    }

    public static org.w3c.dom.Document getOwnerDocument(Node node) {
        return DOMNodeHelper.asDOMDocument(node.getDocument());
    }

    public static org.w3c.dom.Node insertBefore(Node node, org.w3c.dom.Node node2, org.w3c.dom.Node node3) throws DOMException {
        if (node instanceof Branch) {
            Branch branch = (Branch)node;
            List list = branch.content();
            int n = list.indexOf(node3);
            if (n < 0) {
                branch.add((Node)((Object)node2));
            } else {
                list.add(n, node2);
            }
            return node2;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node);
    }

    public static org.w3c.dom.Node replaceChild(Node node, org.w3c.dom.Node node2, org.w3c.dom.Node node3) throws DOMException {
        if (node instanceof Branch) {
            Branch branch = (Branch)node;
            List list = branch.content();
            int n = list.indexOf(node3);
            if (n < 0) {
                throw new DOMException(8, "Tried to replace a non existing child for node: " + node);
            }
            list.set(n, node2);
            return node3;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node);
    }

    public static org.w3c.dom.Node removeChild(Node node, org.w3c.dom.Node node2) throws DOMException {
        if (node instanceof Branch) {
            Branch branch = (Branch)node;
            branch.remove((Node)((Object)node2));
            return node2;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node);
    }

    public static org.w3c.dom.Node appendChild(Node node, org.w3c.dom.Node node2) throws DOMException {
        if (node instanceof Branch) {
            Branch branch = (Branch)node;
            org.w3c.dom.Node node3 = node2.getParentNode();
            if (node3 != null) {
                node3.removeChild(node2);
            }
            branch.add((Node)((Object)node2));
            return node2;
        }
        throw new DOMException(3, "Children not allowed for this node: " + node);
    }

    public static boolean hasChildNodes(Node node) {
        return false;
    }

    public static org.w3c.dom.Node cloneNode(Node node, boolean bl) {
        return DOMNodeHelper.asDOMNode((Node)node.clone());
    }

    public static void normalize(Node node) {
        DOMNodeHelper.notSupported();
    }

    public static boolean isSupported(Node node, String string, String string2) {
        return false;
    }

    public static boolean hasAttributes(Node node) {
        if (node != null && node instanceof Element) {
            return ((Element)node).attributeCount() > 0;
        }
        return false;
    }

    public static String getData(CharacterData characterData) throws DOMException {
        return characterData.getText();
    }

    public static void setData(CharacterData characterData, String string) throws DOMException {
        characterData.setText(string);
    }

    public static int getLength(CharacterData characterData) {
        String string = characterData.getText();
        return string != null ? string.length() : 0;
    }

    public static String substringData(CharacterData characterData, int n, int n2) throws DOMException {
        int n3;
        if (n2 < 0) {
            throw new DOMException(1, "Illegal value for count: " + n2);
        }
        String string = characterData.getText();
        int n4 = n3 = string != null ? string.length() : 0;
        if (n < 0 || n >= n3) {
            throw new DOMException(1, "No text at offset: " + n);
        }
        if (n + n2 > n3) {
            return string.substring(n);
        }
        return string.substring(n, n + n2);
    }

    public static void appendData(CharacterData characterData, String string) throws DOMException {
        if (characterData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + characterData);
        }
        String string2 = characterData.getText();
        if (string2 == null) {
            characterData.setText(string2);
        } else {
            characterData.setText(string2 + string);
        }
    }

    public static void insertData(CharacterData characterData, int n, String string) throws DOMException {
        if (characterData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + characterData);
        }
        String string2 = characterData.getText();
        if (string2 == null) {
            characterData.setText(string);
        } else {
            int n2 = string2.length();
            if (n < 0 || n > n2) {
                throw new DOMException(1, "No text at offset: " + n);
            }
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.insert(n, string);
            characterData.setText(stringBuffer.toString());
        }
    }

    public static void deleteData(CharacterData characterData, int n, int n2) throws DOMException {
        if (characterData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + characterData);
        }
        if (n2 < 0) {
            throw new DOMException(1, "Illegal value for count: " + n2);
        }
        String string = characterData.getText();
        if (string != null) {
            int n3 = string.length();
            if (n < 0 || n >= n3) {
                throw new DOMException(1, "No text at offset: " + n);
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.delete(n, n + n2);
            characterData.setText(stringBuffer.toString());
        }
    }

    public static void replaceData(CharacterData characterData, int n, int n2, String string) throws DOMException {
        if (characterData.isReadOnly()) {
            throw new DOMException(7, "CharacterData node is read only: " + characterData);
        }
        if (n2 < 0) {
            throw new DOMException(1, "Illegal value for count: " + n2);
        }
        String string2 = characterData.getText();
        if (string2 != null) {
            int n3 = string2.length();
            if (n < 0 || n >= n3) {
                throw new DOMException(1, "No text at offset: " + n);
            }
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.replace(n, n + n2, string);
            characterData.setText(stringBuffer.toString());
        }
    }

    public static void appendElementsByTagName(List list, Branch branch, String string) {
        boolean bl = "*".equals(string);
        int n = branch.nodeCount();
        for (int i = 0; i < n; ++i) {
            Node node = branch.node(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (bl || string.equals(element.getName())) {
                list.add(element);
            }
            DOMNodeHelper.appendElementsByTagName(list, element, string);
        }
    }

    public static void appendElementsByTagNameNS(List list, Branch branch, String string, String string2) {
        boolean bl = "*".equals(string);
        boolean bl2 = "*".equals(string2);
        int n = branch.nodeCount();
        for (int i = 0; i < n; ++i) {
            Node node = branch.node(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if ((bl || (string == null || string.length() == 0) && (element.getNamespaceURI() == null || element.getNamespaceURI().length() == 0) || string != null && string.equals(element.getNamespaceURI())) && (bl2 || string2.equals(element.getName()))) {
                list.add(element);
            }
            DOMNodeHelper.appendElementsByTagNameNS(list, element, string, string2);
        }
    }

    public static NodeList createNodeList(final List list) {
        return new NodeList(){

            public org.w3c.dom.Node item(int n) {
                if (n >= this.getLength()) {
                    return null;
                }
                return DOMNodeHelper.asDOMNode((Node)list.get(n));
            }

            public int getLength() {
                return list.size();
            }
        };
    }

    public static org.w3c.dom.Node asDOMNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof org.w3c.dom.Node) {
            return (org.w3c.dom.Node)((Object)node);
        }
        System.out.println("Cannot convert: " + node + " into a W3C DOM Node");
        DOMNodeHelper.notSupported();
        return null;
    }

    public static org.w3c.dom.Document asDOMDocument(Document document) {
        if (document == null) {
            return null;
        }
        if (document instanceof org.w3c.dom.Document) {
            return (org.w3c.dom.Document)((Object)document);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static org.w3c.dom.DocumentType asDOMDocumentType(DocumentType documentType) {
        if (documentType == null) {
            return null;
        }
        if (documentType instanceof org.w3c.dom.DocumentType) {
            return (org.w3c.dom.DocumentType)((Object)documentType);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static Text asDOMText(CharacterData characterData) {
        if (characterData == null) {
            return null;
        }
        if (characterData instanceof Text) {
            return (Text)((Object)characterData);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static org.w3c.dom.Element asDOMElement(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof org.w3c.dom.Element) {
            return (org.w3c.dom.Element)((Object)node);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static Attr asDOMAttr(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Attr) {
            return (Attr)((Object)node);
        }
        DOMNodeHelper.notSupported();
        return null;
    }

    public static void notSupported() {
        throw new DOMException(9, "Not supported yet");
    }

    public static class EmptyNodeList
    implements NodeList {
        public org.w3c.dom.Node item(int n) {
            return null;
        }

        public int getLength() {
            return 0;
        }
    }
}

