/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.nio.file.PathMatcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.cryptomator.cryptofs.GlobToRegexConverter;
import org.cryptomator.cryptofs.PatternPathMatcher;
import org.cryptomator.cryptofs.PerProvider;

@PerProvider
class PathMatcherFactory {
    private final GlobToRegexConverter globToRegexConverter;

    @Inject
    public PathMatcherFactory(GlobToRegexConverter globToRegexConverter) {
        this.globToRegexConverter = globToRegexConverter;
    }

    public PathMatcher pathMatcherFrom(String string) {
        return new PatternPathMatcher(this.pattern(string));
    }

    private Pattern pattern(String string) {
        String string2 = string.toLowerCase();
        if (string2.startsWith("glob:")) {
            return Pattern.compile(this.globToRegexConverter.convert(string.substring(5)));
        }
        if (string2.startsWith("regex:")) {
            return Pattern.compile(string.substring(6));
        }
        throw new UnsupportedOperationException();
    }
}

