/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import dagger.Module;
import dagger.Provides;
import java.nio.file.Path;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.OpenFileOnCloseHandler;
import org.cryptomator.cryptofs.OpenFilePath;
import org.cryptomator.cryptofs.PerOpenFile;

@Module
class OpenCryptoFileModule {
    private final Path path;
    private final EffectiveOpenOptions options;
    private final Runnable onClose;

    private OpenCryptoFileModule(Builder builder) {
        this.path = builder.path;
        this.onClose = builder.onClose;
        this.options = builder.options;
    }

    @Provides
    @PerOpenFile
    @OpenFilePath
    public Path providePath() {
        return this.path;
    }

    @Provides
    @PerOpenFile
    @OpenFileOnCloseHandler
    public Runnable provideOnClose() {
        return this.onClose;
    }

    @Provides
    @PerOpenFile
    public EffectiveOpenOptions provideOptions() {
        return this.options;
    }

    public static Builder openCryptoFileModule() {
        return new Builder();
    }

    public static class Builder {
        private Path path;
        private Runnable onClose;
        private EffectiveOpenOptions options;

        private Builder() {
        }

        public Builder withPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder onClose(Runnable runnable) {
            this.onClose = runnable;
            return this;
        }

        public Builder withOptions(EffectiveOpenOptions effectiveOpenOptions) {
            this.options = effectiveOpenOptions;
            return this;
        }

        public OpenCryptoFileModule build() {
            this.validate();
            return new OpenCryptoFileModule(this);
        }

        private void validate() {
            if (this.path == null) {
                throw new IllegalStateException("path must be set");
            }
            if (this.options == null) {
                throw new IllegalStateException("options must be set");
            }
            if (this.onClose == null) {
                throw new IllegalStateException("onClose must be set");
            }
        }
    }
}

