/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.cryptomator.cryptofs.ByteSource;
import org.cryptomator.cryptofs.ChunkCache;
import org.cryptomator.cryptofs.ChunkData;
import org.cryptomator.cryptofs.CryptoFileChannelFactory;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.OpenCounter;
import org.cryptomator.cryptofs.OpenFileOnCloseHandler;
import org.cryptomator.cryptofs.OpenFileSize;
import org.cryptomator.cryptofs.PerOpenFile;
import org.cryptomator.cryptolib.Cryptors;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;

@PerOpenFile
class OpenCryptoFile {
    private final Cryptor cryptor;
    private final FileChannel channel;
    private final FileHeader header;
    private final ChunkCache chunkCache;
    private final AtomicLong size;
    private final Runnable onClose;
    private final OpenCounter openCounter;
    private final CryptoFileChannelFactory cryptoFileChannelFactory;
    private final CryptoFileSystemStats stats;

    @Inject
    public OpenCryptoFile(EffectiveOpenOptions effectiveOpenOptions, Cryptor cryptor, FileChannel fileChannel, FileHeader fileHeader, @OpenFileSize AtomicLong atomicLong, OpenCounter openCounter, CryptoFileChannelFactory cryptoFileChannelFactory, ChunkCache chunkCache, @OpenFileOnCloseHandler Runnable runnable, CryptoFileSystemStats cryptoFileSystemStats) {
        this.cryptor = cryptor;
        this.chunkCache = chunkCache;
        this.openCounter = openCounter;
        this.cryptoFileChannelFactory = cryptoFileChannelFactory;
        this.onClose = runnable;
        this.channel = fileChannel;
        this.header = fileHeader;
        this.size = atomicLong;
        this.stats = cryptoFileSystemStats;
    }

    public FileChannel newFileChannel(EffectiveOpenOptions effectiveOpenOptions) throws IOException {
        return this.cryptoFileChannelFactory.create(this, effectiveOpenOptions);
    }

    public synchronized int read(ByteBuffer byteBuffer, long l) throws IOException {
        int n = byteBuffer.limit();
        long l2 = this.size() - l;
        if (l2 < 1L) {
            return -1;
        }
        byteBuffer.limit((int)Math.min((long)n, l2));
        int n2 = 0;
        int n3 = this.cryptor.fileContentCryptor().cleartextChunkSize();
        while (byteBuffer.hasRemaining()) {
            long l3 = l + (long)n2;
            long l4 = l3 / (long)n3;
            int n4 = (int)(l3 % (long)n3);
            int n5 = Math.min(byteBuffer.remaining(), n3 - n4);
            ChunkData chunkData = this.chunkCache.get(l4);
            chunkData.copyDataStartingAt(n4).to(byteBuffer);
            n2 += n5;
        }
        byteBuffer.limit(n);
        this.stats.addBytesRead(n2);
        return n2;
    }

    public synchronized long append(EffectiveOpenOptions effectiveOpenOptions, ByteBuffer byteBuffer) throws IOException {
        return this.write(effectiveOpenOptions, byteBuffer, this.size());
    }

    public synchronized int write(EffectiveOpenOptions effectiveOpenOptions, ByteBuffer byteBuffer, long l) throws IOException {
        long l2 = this.size();
        int n = byteBuffer.remaining();
        if (l2 < l) {
            this.write(ByteSource.repeatingZeroes(l - l2).followedBy(byteBuffer), l2);
        } else {
            this.write(ByteSource.from(byteBuffer), l);
        }
        this.handleSync(effectiveOpenOptions);
        this.stats.addBytesWritten(n);
        return n;
    }

    private void handleSync(EffectiveOpenOptions effectiveOpenOptions) throws IOException {
        if (effectiveOpenOptions.syncData()) {
            this.force(effectiveOpenOptions.syncDataAndMetadata(), effectiveOpenOptions);
        }
    }

    private void write(ByteSource byteSource, long l) throws IOException {
        int n = this.cryptor.fileContentCryptor().cleartextChunkSize();
        int n2 = 0;
        while (byteSource.hasRemaining()) {
            ChunkData chunkData;
            long l3 = l + (long)n2;
            long l4 = l3 / (long)n;
            int n3 = (int)(l3 % (long)n);
            int n4 = (int)Math.min(byteSource.remaining(), (long)(n - n3));
            long l5 = l3 + (long)n4;
            this.size.getAndUpdate(l2 -> Math.max(l5, l2));
            if (n4 == n) {
                chunkData = ChunkData.emptyWithSize(n);
                chunkData.copyDataStartingAt(n3).from(byteSource);
                this.chunkCache.set(l4, chunkData);
            } else {
                chunkData = this.chunkCache.get(l4);
                chunkData.copyDataStartingAt(n3).from(byteSource);
            }
            n2 += n4;
        }
    }

    public long size() {
        return this.size.get();
    }

    public synchronized void truncate(long l) throws IOException {
        long l3 = this.size.getAndUpdate(l2 -> Math.min(l, l2));
        if (l3 > l) {
            int n = this.cryptor.fileContentCryptor().cleartextChunkSize();
            long l4 = (l + (long)n - 1L) / (long)n - 1L;
            int n2 = (int)(l % (long)n);
            if (n2 > 0) {
                this.chunkCache.get(l4).truncate(n2);
            }
            long l5 = (long)this.cryptor.fileHeaderCryptor().headerSize() + Cryptors.ciphertextSize(l, this.cryptor);
            this.channel.truncate(l5);
        }
    }

    public synchronized void force(boolean bl, EffectiveOpenOptions effectiveOpenOptions) throws IOException {
        this.chunkCache.invalidateAll();
        if (effectiveOpenOptions.writable()) {
            this.channel.write(this.cryptor.fileHeaderCryptor().encryptHeader(this.header), 0L);
        }
        this.channel.force(bl);
    }

    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        return this.channel.lock(l, l2, bl);
    }

    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        return this.channel.tryLock(l, l2, bl);
    }

    public void open(EffectiveOpenOptions effectiveOpenOptions) throws IOException {
        OpenCounter.OpenState openState = this.openCounter.countOpen();
        if (openState == OpenCounter.OpenState.ALREADY_CLOSED) {
            throw new ClosedChannelException();
        }
        if (openState == OpenCounter.OpenState.WAS_OPEN && effectiveOpenOptions.createNew()) {
            throw new IOException("Failed to create new file. File exists.");
        }
    }

    public void close() throws IOException {
        this.cryptoFileChannelFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(EffectiveOpenOptions effectiveOpenOptions) throws IOException {
        this.force(true, effectiveOpenOptions);
        if (this.openCounter.countClose()) {
            try {
                this.onClose.run();
            }
            finally {
                try {
                    this.channel.close();
                }
                finally {
                    this.cryptor.destroy();
                }
            }
        }
    }
}

